/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.exception.ArbitrationException;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.client.AllNodeDownSelectPolicy;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.client.form.Form;
import com.huawei.jetcd.client.impl.HealthCheckHandler;
import com.huawei.jetcd.client.internal.BaseUri;
import com.huawei.jetcd.exception.EtcdAuthException;
import com.huawei.jetcd.exception.EtcdClientException;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerCheckException;
import com.huawei.jetcd.exception.EtcdServerException;
import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public abstract class AbstractClient
implements Closeable {
    protected EtcdConfig config;
    private String uri;
    private final AsyncHttpClient client;
    private List<BaseUri> baseUris;
    private AtomicInteger uriCount = new AtomicInteger(-1);
    private AllNodeDownSelectPolicy allNodeDownSelectPolicy = AllNodeDownSelectPolicy.RANDOM_SELECT_ONE;

    protected AbstractClient(EtcdConfig config, SslContext sslcontext) {
        this.config = config;
        AllNodeDownSelectPolicy pAllNodeDownSelectPolicy = config.getAllNodeDownSelectPolicy();
        if (pAllNodeDownSelectPolicy != null) {
            this.allNodeDownSelectPolicy = pAllNodeDownSelectPolicy;
        }
        Realm realm = null;
        if (config.getUsername() != null) {
            realm = new Realm.Builder(config.getUsername(), config.getPassword()).setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(true).build();
        }
        DefaultAsyncHttpClientConfig httpClientConfig = new DefaultAsyncHttpClientConfig.Builder().setConnectTimeout(config.getConnectTimeOut()).setSslContext(sslcontext).setKeepAlive(config.isKeepAlive()).setRealm(realm).setDisableHttpsEndpointIdentificationAlgorithm(true).build();
        this.client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)httpClientConfig);
        try {
            String httpPrefix = sslcontext != null ? "https://" : "http://";
            this.initServer(httpPrefix);
            if (config.isHealthCheck()) {
                this.startHealthCheck();
            }
        }
        catch (Exception e) {
            LogManager.warn("startHealthCheck execute failed. the client need to close");
            if (this.client != null && !this.client.isClosed()) {
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LogManager.error("close client failed, msg: " + LogManager.getErrorMessage(e2));
                    throw new ArbitrationException("close client failed", (Throwable)e2);
                }
            }
            throw e;
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null && !this.client.isClosed()) {
            this.client.close();
        }
    }

    Response syncExecuteHttp(Form form) throws EtcdException {
        return this.syncExecuteHttp(form, this.config.getReadTimeout());
    }

    Response syncExecuteHttp(Form form, int timeout) throws EtcdException {
        try {
            Request request = this.httpRequest(form, timeout);
            return (Response)this.client.executeRequest(request).get();
        }
        catch (Exception e) {
            if ((e instanceof CertificateException || e instanceof ExecutionException) && this.compareException(e)) {
                LogManager.error("certificate auth failed." + LogManager.getErrorMessage(e));
                throw new EtcdAuthException(400, "certificate auth failed.");
            }
            if (e instanceof InterruptedException) {
                LogManager.error("ip or port error." + LogManager.getErrorMessage(e));
                throw new EtcdClientException("Request Interrupted", 404L);
            }
            return this.syncExecuteRetry(form, e, timeout);
        }
    }

    private boolean compareException(Exception e) {
        if (VerifyUtil.isEmpty(e) || VerifyUtil.isEmpty(e.getMessage())) {
            return false;
        }
        boolean isTrue = false;
        String[] t = e.getMessage().split(":");
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].contains("SSLEngine")) continue;
            isTrue = true;
            break;
        }
        return isTrue;
    }

    private Response syncExecuteRetry(Form form, Throwable cause, int timeOut) throws EtcdException {
        int retryCount = form.getRetryCount();
        if (cause instanceof EtcdServerException) {
            throw (EtcdException)cause;
        }
        if (retryCount == -1 && this.config.getRetryCount() > 0) {
            int initRetryCount = Math.max(this.baseUris.size(), this.config.getRetryCount());
            LogManager.error("Rreqest error.ID: " + form.getId() + " Method: " + (Object)((Object)form.getHttpMethod()) + ", URI: " + form.getURI() + ", retryCount=" + initRetryCount);
            form.setRetryCount(--initRetryCount);
            return this.syncExecuteHttp(form, timeOut);
        }
        if (retryCount <= 0) {
            LogManager.error("Rreqest error.ID: " + form.getId() + ",Method: " + (Object)((Object)form.getHttpMethod()) + ", URI: " + form.getURI() + " reqest error, retryCount=0, abort retry!");
            throw new EtcdClientException("Request error retryCount=0, abort retry!", 404L);
        }
        LogManager.error("Rreqest error.ID: " + form.getId() + " Method: " + (Object)((Object)form.getHttpMethod()) + ", URI: " + form.getURI() + ", retryCount=" + retryCount);
        form.setRetryCount(--retryCount);
        return this.syncExecuteHttp(form, timeOut);
    }

    private List<Param> buildQueryParams(Form form) {
        ArrayList<Param> params = new ArrayList<Param>();
        Map<String, String> keyValuePairs = form.getParamsMap();
        if (keyValuePairs != null && !keyValuePairs.isEmpty()) {
            for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                params.add(new Param(entry.getKey(), entry.getValue()));
            }
            return params;
        }
        return params;
    }

    private Request httpRequest(Form form, int timeOut) throws EtcdException {
        String currentServer = this.getUri();
        if (VerifyUtil.isEmpty(currentServer)) {
            currentServer = this.selectServer().getEtcdUri();
        }
        BoundRequestBuilder builder = null;
        switch (form.getHttpMethod()) {
            case GET: {
                builder = this.client.prepareGet(currentServer + form.getURI());
                break;
            }
            case PUT: {
                builder = this.client.preparePut(currentServer + form.getURI());
                break;
            }
            case POST: {
                builder = this.client.preparePost(currentServer + form.getURI());
                break;
            }
            case DELETE: {
                builder = this.client.prepareDelete(currentServer + form.getURI());
                break;
            }
            default: {
                LogManager.error(String.format(Locale.ROOT, "No suche HttpMethod: %s", form.getHttpMethod().toString()));
                throw new IllegalArgumentException(String.format(Locale.ROOT, "No suche HttpMethod: %s", form.getHttpMethod().toString()));
            }
        }
        builder.setQueryParams(this.buildQueryParams(form));
        if (form.getBody() != null) {
            builder.setBody(form.getBody());
        }
        Request request = ((BoundRequestBuilder)builder.setRequestTimeout(timeOut)).build();
        LogManager.debug("Send request to Server. Method: " + request.getMethod() + ", URI: " + request.getUrl() + ", Retry: " + form.getRetryCount());
        return request;
    }

    private void initServer(String httpPrefix) {
        String[] servers = this.config.getServer();
        this.baseUris = new ArrayList<BaseUri>(servers.length);
        for (String server : servers) {
            this.baseUris.add(new BaseUri(httpPrefix + server));
        }
    }

    private void startHealthCheck() {
        HealthCheckHandler check;
        int size = this.baseUris.size();
        if (size <= 0) {
            LogManager.debug("no arbitration server.");
            return;
        }
        int threshold = (int)Math.ceil((double)size / 2.0);
        ArrayList<HealthCheckHandler> checkers = new ArrayList<HealthCheckHandler>(size);
        for (BaseUri baseUri : this.baseUris) {
            checkers.add(new HealthCheckHandler(baseUri, this.client, this.config.getCheckTimesBeforeMarkedUp()));
        }
        for (int i = 0; i < size; ++i) {
            check = (HealthCheckHandler)((Object)checkers.get(i));
            check.startFutureMoniter();
        }
        int healthNum = 0;
        check = null;
        for (int i = 0; i < size; ++i) {
            try {
                check = (HealthCheckHandler)((Object)checkers.get(i));
                if (!check.isFutureCheckHealth() || ++healthNum < threshold) continue;
                break;
            }
            catch (Throwable e) {
                LogManager.error("the request url is: " + check.toString() + " occur error, cause by " + LogManager.getErrorMessage(e));
            }
        }
        LogManager.debug("the number of checked is : " + healthNum + " and threshold number is : " + threshold);
        if (healthNum < threshold) {
            LogManager.error("arbitration server health check failed.");
            throw new EtcdServerCheckException(1073947394L);
        }
    }

    private BaseUri selectServer() throws EtcdException {
        int count = Math.abs(this.uriCount.incrementAndGet());
        for (int i = 0; i < this.baseUris.size(); ++i) {
            BaseUri baseUri = this.baseUris.get(count % this.baseUris.size());
            if (baseUri.isHealth()) {
                return baseUri;
            }
            ++count;
        }
        return this.allNodeDownSelectPolicy.select(this.baseUris);
    }
}

