/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.parser;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.jetcd.exception.EtcdAuthException;
import com.huawei.jetcd.exception.EtcdClientException;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerException;
import com.huawei.jetcd.model.EtcdHeaders;
import com.huawei.jetcd.model.EtcdInternalResult;
import com.huawei.jetcd.model.EtcdResult;
import java.nio.charset.Charset;
import org.asynchttpclient.Response;

public final class EtcdResultTranslator {
    private static final String X_ETCD_CLUSTER_ID = "X-Etcd-Cluster-Id";
    private static final String X_ETCD_INDEX = "X-Etcd-Index";
    private static final String X_RAFT_INDEX = "X-Raft-Index";
    private static final String X_RAFT_TERM = "X-Raft-Term";
    private static final String UTF_8 = "utf-8";
    private static final int SERVER_SELECT_ERROR = 500;
    private static final int SERVER_NORMAL = 200;

    private EtcdResultTranslator() {
    }

    public static String translateVersion(Response response) throws EtcdException {
        try {
            return response.getResponseBody(Charset.forName(UTF_8));
        }
        catch (Exception e) {
            LogManager.error("Error extracting response entity" + LogManager.getErrorMessage(e));
            throw new EtcdClientException("Error extracting response entity", e);
        }
    }

    public static EtcdResult translateKeyResult(Response response) throws EtcdException {
        if (response == null) {
            LogManager.error("can not translate normal result beacuse parameter error: response null");
            throw new EtcdClientException("HttpResponse return no content!");
        }
        int httpCode = response.getStatusCode();
        if (httpCode == 500) {
            LogManager.error("translate Key Result exception,Etcd servers maybe cann't select leader,httpCode:" + httpCode);
            throw new EtcdClientException("http code = 500,Internal Server Error. Etcd servers maybe cann't select leader!");
        }
        if (httpCode == 401) {
            LogManager.error("translate Key Result exception beacuse response status is Unauthorized.httpCode:" + httpCode);
            throw new EtcdAuthException(401, "Unauthorized");
        }
        if (httpCode == 403) {
            LogManager.error("translate Key Result exception beacuse response status is Forbidden.httpCode:" + httpCode);
            throw new EtcdAuthException(403, "Forbidden");
        }
        EtcdHeaders headers = EtcdResultTranslator.parseHead(response);
        EtcdInternalResult result = EtcdResultTranslator.jsonToBean(response, EtcdInternalResult.class);
        if (result == null) {
            LogManager.error("translate Key Result exception beacuse is null.");
            throw new EtcdClientException("response is null");
        }
        result.setHeaders(headers);
        if (result.getErrorCode() != 0) {
            LogManager.error("translate Key Result exception beacuse result isn't sucess: errorcode:" + result.getErrorCode());
            throw new EtcdServerException(result.getErrorCode(), result.getCause(), result.getMessage(), result.getIndex());
        }
        return result;
    }

    public static <T> T translateNormalResult(Response response, Class<T> cls) throws EtcdException {
        if (response == null) {
            LogManager.error("can not translate normal result beacuse parameter error: response null.");
            throw new EtcdClientException("HttpResponse return no content!");
        }
        int httpCode = response.getStatusCode();
        if (httpCode == 500) {
            LogManager.error("can not translate normal result beacuse server select error.httpCode:" + httpCode);
            throw new EtcdClientException("http code = 500,Internal Server Error. Etcd servers maybe cann't select leader!");
        }
        if (httpCode != 200) {
            LogManager.error("can not translate normal result beacuse server excption.httpCode:" + httpCode);
            throw new EtcdClientException("http code != 200, code=" + httpCode);
        }
        return EtcdResultTranslator.jsonToBean(response, cls);
    }

    private static <T> T jsonToBean(Response response, Class<T> cls) throws EtcdClientException {
        String json = null;
        try {
            json = response.getResponseBody(Charset.forName(UTF_8));
        }
        catch (Exception e) {
            LogManager.error("convert json to bean exception," + LogManager.getErrorMessage(e));
            throw new EtcdClientException("Error extracting response entity", e);
        }
        return JSONObject.toBean(json, cls);
    }

    private static EtcdHeaders parseHead(Response response) {
        String etcdClusterId = response.getHeader((CharSequence)X_ETCD_CLUSTER_ID);
        String indexHeader = response.getHeader((CharSequence)X_ETCD_INDEX);
        String raftIndexHeader = response.getHeader((CharSequence)X_RAFT_INDEX);
        String raftTermHeader = response.getHeader((CharSequence)X_RAFT_TERM);
        EtcdHeaders headers = new EtcdHeaders();
        headers.setEtcdClusterId(etcdClusterId);
        if (indexHeader != null) {
            headers.setEtcdIndex(Long.valueOf(indexHeader));
        }
        if (raftIndexHeader != null) {
            headers.setRaftIndex(Long.valueOf(raftIndexHeader));
        }
        if (raftTermHeader != null) {
            headers.setRaftTerm(Long.valueOf(raftTermHeader));
        }
        return headers;
    }

    public static void checkAuthStatus(Response response) throws EtcdAuthException {
        int httpCode = response.getStatusCode();
        if (httpCode == 401) {
            LogManager.error("AuthStatus Unauthorized exception,httpCode is : " + httpCode);
            throw new EtcdAuthException(401, "Unauthorized");
        }
        if (httpCode == 403) {
            LogManager.error("AuthStatus Forbidden exception,httpCode is : " + httpCode);
            throw new EtcdAuthException(403, "Forbidden");
        }
        if (httpCode == 400) {
            LogManager.error("AuthStatus Bad Request exception,httpCode is : " + httpCode);
            throw new EtcdAuthException(400, "Bad Request");
        }
        if (httpCode == 409) {
            LogManager.error("AuthStatus Conflict exception,httpCode is : " + httpCode);
            throw new EtcdAuthException(409, "Conflict");
        }
        if (httpCode == 404) {
            LogManager.error("AuthStatus Not Found exception,httpCode is : " + httpCode);
            throw new EtcdAuthException(404, "Not Found");
        }
    }
}

