/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signer;

import com.huawei.signer.EncryptFile;
import com.huawei.signer.LogManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ProperUtil {
    private static final String FILE_NAME = "FileName";
    private static final String KEY_NAME = "KeyName";
    private static final String KEY_VALUE = "KeyValue";
    private static final String NODE_VALUE = "NodeValue";
    private List<EncryptFile> utilList = new ArrayList<EncryptFile>();
    private Properties PROPS = new Properties();

    private static boolean isEmpty(String str) {
        return "".equals(str) || str == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEncryptedProperties(String confFile) {
        InputStream is = null;
        try {
            ClassLoader clazzLoader = ProperUtil.class.getClassLoader();
            if (clazzLoader != null) {
                is = clazzLoader.getResourceAsStream(confFile);
            }
            if (is != null) {
                this.PROPS.load(is);
                this.initMaps();
            } else {
                LogManager.error("get resource failed.");
            }
        }
        catch (IOException e) {
            LogManager.error("read default.properties fail." + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogManager.error("close exception: " + e);
                }
            }
        }
    }

    private void initMaps() throws IOException {
        Set<Object> keys = this.PROPS.keySet();
        for (String string : keys) {
            EncryptFile fileUtil = new EncryptFile();
            if (!string.startsWith(FILE_NAME)) continue;
            String endStr = string.substring(FILE_NAME.length());
            String fileN = this.PROPS.getProperty(string);
            String keyN = this.PROPS.getProperty(KEY_NAME + endStr);
            String node = this.PROPS.getProperty(NODE_VALUE + endStr);
            if (ProperUtil.isEmpty(fileN) || ProperUtil.isEmpty(keyN)) {
                LogManager.error("file: " + fileN + ", key: " + keyN + ", some value is null.");
                throw new IOException();
            }
            if (fileN.endsWith(".xml") && ProperUtil.isEmpty(node)) {
                LogManager.error("xml must config the key: NodeValue" + endStr);
                throw new IOException();
            }
            if (this.PROPS.containsKey(KEY_VALUE + endStr)) {
                String keyV = this.PROPS.getProperty(KEY_VALUE + endStr);
                fileUtil.setKeyValue(keyV);
            }
            fileUtil.setFileName(fileN);
            fileUtil.setKeyName(keyN);
            fileUtil.setNodeValue(node);
            this.utilList.add(fileUtil);
        }
    }

    public Properties getKmcConfFile(String kmcConf) {
        Properties tempProperties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(kmcConf));){
            tempProperties.load(bufferedReader);
        }
        catch (FileNotFoundException e) {
            LogManager.error("load default properties file not found:" + LogManager.getErrorMessage(e));
        }
        catch (IOException e) {
            LogManager.error("load default properties file error:" + LogManager.getErrorMessage(e));
        }
        return tempProperties;
    }

    public List<EncryptFile> getUtilList() {
        return this.utilList;
    }

    public Properties getProps() {
        return this.PROPS;
    }
}

