/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.dao;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.dao.CommonDaoImpl;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.QueryCondition;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

public class ResourceDaoImpl
extends CommonDaoImpl
implements IResourceDao {
    private static final Log LOGGER = LogFactory.getInstance(ResourceDaoImpl.class);
    private IMessageCenter messageCenter = null;
    private TransactionTemplate transactionTemplate;

    private void makeUpdateMsg(ManagedObject mo, boolean isOffLineStatusChange, boolean isOnLineStatusChange) {
        if (mo.getIsTopMo().booleanValue()) {
            if (isOffLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                map.put(-1L, 0);
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will send COMMAND_RES_ONLINE message, mo id is : %s.", mo.getMoId()), 1L);
                MessageUnit mmu = new MessageUnit();
                mmu.setCmdcode(110L);
                mmu.setObj(map);
                mmu.setMt(MessageTopic.COMMAND);
                mmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmu);
            } else if (isOnLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will send COMMAND_RES_LEAVE message, mo id is : %s.", mo.getMoId()), 1L);
                MessageUnit mmmu = new MessageUnit();
                mmmu.setCmdcode(109L);
                mmmu.setObj(map);
                mmmu.setMt(MessageTopic.COMMAND);
                mmmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmmu);
            }
        }
    }

    @Override
    public void updateMoWithoutMsg(ManagedObject mo) {
        LOGGER.debug((Object)"will update mo without msg, mo is : ", 1L);
        ManagedObject oldMo = this.getMoByUuid(mo.getUuid(), null);
        if (oldMo != null) {
            this.evict(oldMo);
        }
        boolean isOffLineStatusChange = false;
        boolean isOnLineStatusChange = false;
        if (oldMo != null) {
            if (this.checkMoType(mo.getType())) {
                mo.setName(oldMo.getName());
                mo.setDevAlias(oldMo.getDevAlias());
            }
            Integer oldStatus = oldMo.getStatus();
            Integer newStatus = mo.getStatus();
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "OldStatus is : %s, newStatus is : %s.", oldStatus, newStatus), 1L);
            if (this.checkOffline(oldStatus, newStatus)) {
                isOffLineStatusChange = true;
            } else if (this.checkOnline(oldStatus, newStatus)) {
                isOnLineStatusChange = true;
            }
        }
        super.getHibernateTemplate().update((Object)mo);
        this.makeUpdateMsg(mo, isOffLineStatusChange, isOnLineStatusChange);
    }

    private boolean checkOffline(Integer oldStatus, Integer newStatus) {
        if (oldStatus != null && oldStatus == -1 && newStatus != null && newStatus != -1) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "CheckOffline:oldStatus is %s, newStatus is %s.", oldStatus, newStatus));
            return true;
        }
        return false;
    }

    private boolean checkOnline(Integer oldStatus, Integer newStatus) {
        if (oldStatus != null && oldStatus != -1 && newStatus != null && newStatus == -1) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "CheckOnline:oldStatus is %s, newStatus is %s.", oldStatus, newStatus));
            return true;
        }
        return false;
    }

    private void makeUpdateMsg(ManagedObject mo, Map<Long, ManagedObject> messageMap, boolean isOffLineStatusChange, boolean isOnLineStatusChange, ManagedObject oldMo) {
        if (mo.getIsTopMo().booleanValue()) {
            LOGGER.debug((Object)"will send COMMAND_RES_UPDATE msg, msg body is : ", 1L);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(107L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
            if (isOffLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                map.put(-1L, 0);
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will send COMMAND_RES_ONLINE message, mo id is : %s.", mo.getMoId()), 1L);
                MessageUnit mmu = new MessageUnit();
                mmu.setCmdcode(110L);
                mmu.setObj(map);
                mmu.setMt(MessageTopic.COMMAND);
                mmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmu);
            } else if (isOnLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will send COMMAND_RES_LEAVE message, mo id is : %s.", mo.getMoId()), 1L);
                MessageUnit mmmu = new MessageUnit();
                mmmu.setCmdcode(109L);
                mmmu.setObj(map);
                mmmu.setMt(MessageTopic.COMMAND);
                mmmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmmu);
            }
        } else if (!mo.equals((Object)oldMo)) {
            LOGGER.debug((Object)"will send COMMAND_RES_UPDATE_SUB_MO msg, msg body is : ", 1L);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(108L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
    }

    @Override
    public void updateMo(ManagedObject mo) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will update mo, mo uuid is : %s.", mo.getUuid()), 1L);
        ManagedObject oldMo = this.getMoByUuid(mo.getUuid(), null);
        if (oldMo != null) {
            this.evict(oldMo);
        }
        boolean isOffLineStatusChange = false;
        boolean isOnLineStatusChange = false;
        if (oldMo != null) {
            if (this.checkMoType(mo.getType())) {
                mo.setName(oldMo.getName());
                mo.setDevAlias(oldMo.getDevAlias());
            }
            Integer oldStatus = oldMo.getStatus();
            Integer newStatus = mo.getStatus();
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "OldStatus is : %s, newStatus is : %s.", oldStatus, newStatus), 1L);
            if (this.checkOffline(oldStatus, newStatus)) {
                isOffLineStatusChange = true;
            } else if (this.checkOnline(oldStatus, newStatus)) {
                isOnLineStatusChange = true;
            }
        }
        super.getHibernateTemplate().update((Object)mo);
        HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
        messageMap.put(mo.getMoId(), mo);
        this.makeUpdateMsg(mo, messageMap, isOffLineStatusChange, isOnLineStatusChange, oldMo);
    }

    public boolean checkMoType(String moType) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com.huawei.ism.array.sdk.model.StorageArray");
        typeList.add("com.huawei.ism.array.sdk.model.XveStorage");
        typeList.add("com.huawei.ism.array.sdk.model.HvsStorage");
        typeList.add("com.huawei.ism.unistor.sdk.model.NasStorage");
        typeList.add("com.huawei.ism.vis.sdk.model.VisStorage");
        typeList.add("com.huawei.ism.vtl.sdk.model.VtlStorage");
        typeList.add("com.huawei.ism.ubase.sdk.uds.model.UdsStorage");
        typeList.add("com.huawei.ism.base.sdk.model.StorageUnit");
        typeList.add("com.huawei.ism.array.sdk.model.ArrayUnit");
        typeList.add("com.huawei.ism.array.sdk.model.HvsUnit");
        typeList.add("com.huawei.ism.array.sdk.model.XveUnit");
        typeList.add("com.huawei.ism.unistor.sdk.model.NasUnit");
        typeList.add("com.huawei.ism.vis.sdk.model.VisUnit");
        typeList.add("com.huawei.ism.base.sdk.model.Switch.FcSwitch");
        typeList.add("com.huawei.ism.base.sdk.model.Switch.IpSwitch");
        typeList.add("com.huawei.ism.host.sdk.model.Host");
        typeList.add("com.huawei.ism.virtual.sdk.model.VirtualHost");
        typeList.add("com.huawei.ism.virtual.sdk.model.VirtualizationServer");
        typeList.add("com.huawei.ism.css.sdk.model.CssDomain");
        typeList.add("com.huawei.ism.cse.sdk.model.CSESystem");
        typeList.add("com.huawei.ism.network.sdk.model.FcSwitch");
        typeList.add("com.huawei.ism.network.sdk.model.IpSwitch");
        typeList.add("com.huawei.ism.host.sdk.model.VirtualHost");
        typeList.add("com.huawei.ism.host.sdk.model.VirtualizationServer");
        return null != moType && typeList.contains(moType);
    }

    @Override
    public void updateMo(List<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            this.updateMo(mo);
        }
    }

    @Override
    public void updateMoWithoutMsg(List<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            this.updateMoWithoutMsg(mo);
        }
    }

    @Override
    public ManagedObject getMoByIdAndType(Class<? extends ManagedObject> moClass, long id, Boolean managed) {
        LOGGER.debug((Object)"GetMoByIdAndType:moClass is %s,id is %s,managed is %s.", new Object[]{moClass, id, managed});
        HibernateTemplate tmp = super.getHibernateTemplate();
        HibernateCallbackID callback = new HibernateCallbackID(id, managed, moClass);
        Object obj = tmp.execute((HibernateCallback)callback);
        return (ManagedObject)obj;
    }

    @Override
    public List<ManagedObject> getChildMo(long parentId, Boolean managed) {
        if (null == managed) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetChildMo:parentId is %s,managed is null", parentId));
        } else {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetChildMo:parentId is %s,managed is %s.", parentId, managed));
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(ManagedObject.class);
        criteria.add((Criterion)Restrictions.eq((String)"parentMo.moId", (Object)parentId));
        if (managed != null) {
            criteria.add((Criterion)Restrictions.eq((String)"managed", (Object)managed));
        }
        return super.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public Long addMoWithoutMsg(ManagedObject mo) {
        LOGGER.debug((Object)"will add mo without msg");
        return (Long)super.getHibernateTemplate().save((Object)mo);
    }

    @Override
    public Long addMo(final ManagedObject mo) {
        LOGGER.debug((Object)"will add mo");
        Long moId = (Long)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    return ResourceDaoImpl.this.save(mo);
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("save mo error, mo is : " + mo + ", Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                    throw new LegoUncheckedException("save mo error: " + ExceptionUtil.getErrorMessage((Throwable)e));
                }
            }
        });
        HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
        messageMap.put(mo.getMoId(), mo);
        if (mo.getIsTopMo().booleanValue()) {
            LOGGER.debug((Object)"will send COMMAND_RES_ADD msg", 1L);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(103L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
        return moId;
    }

    @Override
    public List<? extends ManagedObject> getMoByType(Class<?> clazz, Boolean managed) {
        DetachedCriteria criteria = DetachedCriteria.forClass(clazz);
        if (managed != null) {
            LOGGER.debug((Object)"GetMoByType:class is %s,managed is %s.", new Object[]{clazz, managed});
            criteria.add((Criterion)Restrictions.eq((String)"managed", (Object)managed));
        } else {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetMoByType:class is %s,managed is null", clazz));
        }
        return super.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public ManagedObject getMoByUuid(String uuid, Boolean managed) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetMoByUuid:uuid is %s,managed is %s.", uuid, managed));
        HibernateTemplate obj = super.getHibernateTemplate();
        MyHibernateCallback callBask = new MyHibernateCallback(uuid);
        Object tmp = obj.execute((HibernateCallback)callBask);
        return (ManagedObject)tmp;
    }

    @Override
    public void deleteMo(final Long moId) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "First step to delete mo, mo id is : %s.", moId), 1L);
        ArrayList<ManagedObject> allMo = new ArrayList<ManagedObject>();
        this.getAllSubMo(moId, allMo);
        final ManagedObject tMo = this.getMoByIdAndType(ManagedObject.class, moId, null);
        if (tMo == null) {
            LOGGER.warn((Object)("can not getMoByIdAndType in deleteMo, moid is : " + moId + ", type is : ManagedObject"), 1L);
            return;
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    ResourceDaoImpl.this.delete(tMo);
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete mo successful, moId is :%s.", moId), 1L);
                    return null;
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("delete mo error, moId is : " + moId + ", exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                    throw new LegoUncheckedException("delete mo error: " + ExceptionUtil.getErrorMessage((Throwable)e));
                }
            }
        });
        if (tMo.getIsTopMo().booleanValue()) {
            HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
            messageMap.put(tMo.getMoId(), tMo);
            LOGGER.debug((Object)"will send COMMAND_RES_DEL msg, msg body is : ", 1L);
            MessageUnit mu = this.getMessageUnit(messageMap);
            this.messageCenter.sendMessage(mu);
        }
        allMo.add(tMo);
        AsynchronousMsgSender asynchronousMsgSender = new AsynchronousMsgSender(allMo);
        ExecutionService.submitTask(asynchronousMsgSender);
        HashMap<String, Long> messageMap = new HashMap<String, Long>();
        for (ManagedObject mo : allMo) {
            messageMap.put(mo.getUuid(), mo.getMoId());
        }
        LOGGER.debug((Object)"will send COMMAND_RES_DEL_FOR_PERF msg, messageMap is : ", 1L);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(111L);
        mu.setObj(messageMap);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(mu);
    }

    private MessageUnit getMessageUnit(HashMap<Long, ManagedObject> messageMap) {
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(105L);
        mu.setObj(messageMap);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        return mu;
    }

    @Override
    public void deleteMoWithoutMsg(final Long moId) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "First step to delete mo without msg, mo id is : %s.", moId), 1L);
        ArrayList<ManagedObject> allMo = new ArrayList<ManagedObject>();
        this.getAllSubMo(moId, allMo);
        final ManagedObject tMo = this.getMoByIdAndType(ManagedObject.class, moId, null);
        if (tMo == null) {
            LOGGER.warn((Object)("can not getMoByIdAndType in deleteMoWithoutMsg, moid is : " + moId + ", type is : ManagedObject"), 1L);
            return;
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    ResourceDaoImpl.this.delete(tMo);
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "Delete mo without msg successful, moId is : %s.", moId), 1L);
                    return null;
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("delete mo error, moId is : " + moId + ", exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                    throw new LegoUncheckedException("delete mo error: " + ExceptionUtil.getErrorMessage((Throwable)e));
                }
            }
        });
        allMo.add(tMo);
        HashMap<String, Long> messageMap = new HashMap<String, Long>();
        for (ManagedObject mo : allMo) {
            messageMap.put(mo.getUuid(), mo.getMoId());
        }
        LOGGER.debug((Object)"will send COMMAND_RES_DEL_FOR_PERF msg, messageMap is : ", 1L);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(111L);
        mu.setObj(messageMap);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(mu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Paging queryRes(Class<T> resType, List<QueryCondition> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Session session = this.getSessionFactory().openSession();
        try {
            List<T> list;
            Criteria criteria = session.createCriteria(resType);
            Criteria criteriaTotal = session.createCriteria(resType);
            if (firstRowIndex >= 0) {
                criteria.setFirstResult(firstRowIndex);
            }
            if (totalRow >= 0) {
                criteria.setMaxResults(totalRow);
            }
            if (orderByAscend) {
                criteria.addOrder(Order.asc((String)orderByField));
            } else {
                criteria.addOrder(Order.desc((String)orderByField));
            }
            int size = 0;
            if (condition == null) {
                list = criteria.list();
                size = criteriaTotal.list().size();
            } else {
                list = ResourceDaoImpl.getPerfs(condition, criteria);
                size = ResourceDaoImpl.getPerfs(condition, criteriaTotal).size();
            }
            Paging paging = new Paging();
            paging.setiCount(size);
            paging.setData(list);
            Paging paging2 = paging;
            return paging2;
        }
        catch (Exception e) {
            LOGGER.error((Object)("queryFaults exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return new Paging();
    }

    public static String convertString(String sourceStr) {
        return ConverterUtil.convertString(sourceStr, true);
    }

    @Override
    public ManagedObject getMoByIp(String ip, Boolean managed) {
        HibernateTemplate obj = super.getHibernateTemplate();
        MyHibernateCallbackIP callback = new MyHibernateCallbackIP(ip);
        return (ManagedObject)obj.execute((HibernateCallback)callback);
    }

    private static <T> List<T> getPerfs(List<QueryCondition> conditions, Criteria criteria) {
        for (QueryCondition con : conditions) {
            if (con.getType().equals("el")) {
                criteria.add((Criterion)Restrictions.eq((String)con.getKey(), (Object)con.getValue()));
                continue;
            }
            if (con.getType().equals("like")) {
                String queryStr = ResourceDaoImpl.convertString(con.getValue().toString());
                criteria.add((Criterion)Restrictions.like((String)con.getKey(), (Object)queryStr));
                continue;
            }
            if (!con.getType().equals("in")) continue;
            criteria.add(Restrictions.in((String)con.getKey(), (Collection)((Set)con.getValue())));
        }
        return criteria.list();
    }

    private void setQueryAndCountQuery(Map<Integer, String> param, Date beginTimeTemp, Date endTimeTemp, Query query, Query countQuery) {
        if (param != null) {
            Set<Map.Entry<Integer, String>> entrys = param.entrySet();
            for (Map.Entry<Integer, String> entry : entrys) {
                query.setString(entry.getKey().intValue(), entry.getValue());
                countQuery.setString(entry.getKey().intValue(), entry.getValue());
            }
        }
        if (!VerifyUtil.isEmpty((Object)beginTimeTemp)) {
            query.setTimestamp("beginTime", beginTimeTemp);
            countQuery.setTimestamp("beginTime", beginTimeTemp);
        }
        if (!VerifyUtil.isEmpty((Object)endTimeTemp)) {
            query.setTimestamp("endTime", endTimeTemp);
            countQuery.setTimestamp("endTime", endTimeTemp);
        }
    }

    private void processResultAdmin(boolean isAdmin, int firstRowIndex, int totalRow, Query query) {
        if (isAdmin) {
            query.setFirstResult(firstRowIndex);
            query.setMaxResults(totalRow);
        }
    }

    private String getOrderField(String orderByField) {
        if ("discoveredTimeStr".equals(orderByField)) {
            orderByField = "discoveredTime";
        }
        return orderByField;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    private String getOrder(boolean orderByAscend) {
        String result = " desc";
        if (orderByAscend) {
            result = " asc";
        }
        return result;
    }

    private Map<String, Object> processQueryCondition(Map<String, Object> conditionMap, StringBuilder hql) throws ParseException {
        String name = (String)conditionMap.get("name");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.hasText((String)name)) {
            name = ConverterUtil.convertString(name.trim(), true);
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Converted result name is : %s.", name), 1L);
            hql.append(" and lower(mo.name) like lower(?").append(") ");
            param.put(param.size(), name);
        }
        String ip = (String)conditionMap.get("ip");
        this.processIP(ip, hql, param);
        String beginTime = (String)conditionMap.get("beginTime");
        String endTime = (String)conditionMap.get("endTime");
        beginTime = this.processTime(beginTime);
        endTime = this.processTime(endTime);
        beginTime = StringUtils.replace((String)beginTime.trim(), (String)"'", (String)"''");
        endTime = StringUtils.replace((String)endTime.trim(), (String)"'", (String)"''");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!VerifyUtil.isEmpty((String)beginTime)) {
            Date beginTimeTemp = dateFormat.parse(beginTime);
            hql.append(" and mo.discoveredTime >=:beginTime ");
            result.put("beginTime", beginTimeTemp);
        }
        if (!VerifyUtil.isEmpty((String)endTime)) {
            Date endTimeTemp = dateFormat.parse(endTime);
            endTimeTemp = this.addOneSecond(endTimeTemp);
            hql.append(" and mo.discoveredTime <:endTime ");
            result.put("endTime", endTimeTemp);
        }
        result.put("param", param);
        return result;
    }

    private void processIP(String ip, StringBuilder hql, Map<Integer, String> param) {
        if (StringUtils.hasText((String)ip)) {
            ip = StringUtils.replace((String)ip.trim(), (String)"'", (String)"''");
            hql.append(" and mo.ipAddress = ? ");
            param.put(param.size(), ip);
        }
    }

    private boolean checkTimeNotNull(String beginTime, String endTime) {
        return !beginTime.equals("") && !endTime.equals("");
    }

    private String processTime(String time) {
        if (time == null) {
            time = "";
        }
        return time;
    }

    private Date addOneSecond(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(14, 1000);
        return calendar.getTime();
    }

    @Override
    public void getAllSubMo(Long moId, List<ManagedObject> resultMoList) {
        List<ManagedObject> childMo = this.getChildMo(moId, null);
        if (childMo != null && !childMo.isEmpty()) {
            resultMoList.addAll(childMo);
            for (ManagedObject mo : childMo) {
                this.getAllSubMo(mo.getMoId(), resultMoList);
            }
        }
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    @Override
    public void evict(ManagedObject mo) {
        String uuid = null == mo ? null : mo.getUuid();
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Evict:ManagedObject is %s.", uuid));
        super.getHibernateTemplate().evict((Object)mo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getAllMoId() {
        String hql = "select moId from TopoObject";
        ArrayList<Long> moIdList = new ArrayList();
        Session session = null;
        try {
            session = super.getSessionFactory().getCurrentSession();
            moIdList = session.createQuery(hql).list();
            if (null == moIdList) {
                moIdList = new ArrayList();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("getAllMoId exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return moIdList;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public List<ManagedObject> getAllTopMO() {
        List<Object> moList = new ArrayList<ManagedObject>();
        try {
            DetachedCriteria topMOCriteria = DetachedCriteria.forClass(ManagedObject.class);
            topMOCriteria.add((Criterion)Restrictions.eq((String)"isTopMo", (Object)Boolean.TRUE));
            moList = super.getHibernateTemplate().findByCriteria(topMOCriteria);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Exception occurs when query top-mo from DB.", 1L);
            LOGGER.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return moList;
    }

    @Override
    public String getMoMainTypeByMoId(Long moId) {
        String mainTypeOfMo = "";
        try {
            DetachedCriteria topMOCriteria = DetachedCriteria.forClass(TopoObject.class);
            topMOCriteria.add((Criterion)Restrictions.eq((String)"moId", (Object)moId));
            List topoMoList = super.getHibernateTemplate().findByCriteria(topMOCriteria);
            TopoObject topoMo = (TopoObject)topoMoList.get(0);
            mainTypeOfMo = topoMo.getMainType();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Exception occurs when query main-type of mo from DB.", 1L);
            LOGGER.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return mainTypeOfMo;
    }

    @Override
    public void clear() {
        super.getHibernateTemplate().clear();
    }

    private class AsynchronousMsgSender
    implements Runnable {
        private List<ManagedObject> allMo = null;

        public AsynchronousMsgSender(List<ManagedObject> allMo) {
            this.allMo = allMo;
        }

        @Override
        public void run() {
            HashMap<Long, ManagedObject> messageMapCommon = new HashMap<Long, ManagedObject>();
            for (ManagedObject mo : this.allMo) {
                messageMapCommon.put(mo.getMoId(), mo);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(106L);
                mu.setObj(messageMapCommon);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                ResourceDaoImpl.this.messageCenter.sendMessage(mu);
                LOGGER.info((Object)"has sent COMMAND_RES_DEL_SUB_MO msg ", 1L);
                messageMapCommon.clear();
            }
        }
    }

    static class MyHibernateCallbackIP
    implements HibernateCallback {
        private String ip;

        public MyHibernateCallbackIP(String ip) {
            this.ip = ip;
        }

        public Object doInHibernate(Session session) {
            return session.createCriteria(TopoObject.class).add((Criterion)Restrictions.eq((String)"ipAddress", (Object)this.ip)).uniqueResult();
        }
    }

    static class MyHibernateCallback
    implements HibernateCallback {
        private String uuid;

        public MyHibernateCallback(String uuid) {
            this.uuid = uuid;
        }

        public Object doInHibernate(Session session) {
            Criteria criteria = session.createCriteria(ManagedObject.class);
            criteria.add((Criterion)Restrictions.eq((String)"uuid", (Object)this.uuid));
            return criteria.uniqueResult();
        }
    }

    static class HibernateCallbackID
    implements HibernateCallback {
        private long id;
        private Boolean managed;
        private Class<? extends ManagedObject> moClass;

        public HibernateCallbackID(long id, Boolean managed, Class<? extends ManagedObject> moClass) {
            this.id = id;
            this.managed = managed;
            this.moClass = moClass;
        }

        public Object doInHibernate(Session session) {
            Criteria criteria = session.createCriteria(this.moClass);
            criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)this.id));
            if (this.managed != null) {
                criteria.add((Criterion)Restrictions.eq((String)"managed", (Object)this.managed));
            }
            return criteria.uniqueResult();
        }
    }
}

