/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.security;

import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class Security
implements ISecurity {
    private static final Log LOGGER = LogFactory.getInstance(Security.class);
    private static final String USER_LOCK = "USER_LOCK";
    private static final String USER_LOGIN_FAIL = "USER_LOGIN_FAIL";
    private static final int MIN_SESSION_TIMEOUT = 1;
    private static final int DEFALT_SESSION_TIMEOUT = 30;
    private static final int MIN_LOCK_TIME = 1;
    private static final int DEFALT_LOCK_TIME = 3;
    private ICommonDao commonDao;
    private IUserLoginLocalCache cacheService;
    private SystemInitializeUser systemInitUser;

    @Override
    public void initSysLoginPolicy() {
        UserSecPolicyInfo secInfo;
        UserLoginPolicyInfo info = this.getLoginPolicy();
        if (null == info) {
            UserLoginPolicyInfo defaultLoginPolicy = this.systemInitUser.getDefaultLoginPolicy();
            this.commonDao.save(defaultLoginPolicy);
        }
        if (null == (secInfo = this.getUserSecPolicy())) {
            UserSecPolicyInfo defaultSecPolicy = this.systemInitUser.getDefaultSecPolicy();
            this.commonDao.save(defaultSecPolicy);
        }
    }

    @Override
    public void lockUser(UserInfo userInfo) {
        if (null != userInfo) {
            this.lockUser(userInfo.getId());
        }
    }

    @Override
    public void lockUser(long userId) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where id = ?";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, String.valueOf(userId));
            List<?> result = this.commonDao.findByHql(hql, param);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null != userInfo) {
                if (userInfo.isLock()) {
                    throw new LegoCheckedException(294L);
                }
            } else {
                throw new LegoCheckedException(201L);
            }
            userInfo.setLock(Boolean.TRUE.booleanValue());
            this.commonDao.update(userInfo);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void lockUser(String userName) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where userName = ?";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, userName);
            List<?> result = this.commonDao.findByHql(hql, param);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null == userInfo) {
                throw new LegoCheckedException(201L);
            }
            userInfo.setLock(Boolean.TRUE.booleanValue());
            this.commonDao.update(userInfo);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void unLockUser(UserInfo userInfo) {
        if (null != userInfo) {
            this.unLockUser(userInfo.getId());
        }
    }

    @Override
    public void unLockUser(long userId) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where id = ?";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, String.valueOf(userId));
            List<?> result = this.commonDao.findByHql(hql, param);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null == userInfo) {
                throw new LegoCheckedException(201L);
            }
            String userName = userInfo.getUserName();
            String userLockKey = USER_LOCK + userName;
            if (this.checkUserUnlock(userInfo, userLockKey)) {
                throw new LegoCheckedException(295L);
            }
            userInfo.setLock(Boolean.FALSE.booleanValue());
            this.commonDao.update(userInfo);
            this.removeCacheKey(userName, userLockKey);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    private void removeCacheKey(String userName, String userLockKey) {
        String loginFailKey = USER_LOGIN_FAIL + userName;
        if (null == this.cacheService) {
            return;
        }
        if (this.cacheService.containsKey(userLockKey)) {
            this.cacheService.remove(userLockKey);
        }
        if (this.cacheService.containsKey(loginFailKey)) {
            this.cacheService.remove(loginFailKey);
        }
    }

    private boolean checkUserUnlock(UserInfo userInfo, String userLockKey) {
        return !userInfo.isLock() && (this.cacheService == null || !this.cacheService.containsKey(userLockKey));
    }

    public void addUserAcl(Set<UserAclInfo> userAclInfoSet) {
        if (null != userAclInfoSet && !userAclInfoSet.isEmpty()) {
            for (UserAclInfo temp : userAclInfoSet) {
                this.commonDao.save(temp);
            }
        }
    }

    public void delUserAllAcl(long userId) {
        String hql = "delete from UserAclInfo where userId = ?";
        Object[] param = new Object[]{userId};
        this.commonDao.updateByHql(hql, param);
    }

    public void delUserAllAcl(Long[] userIds) {
        Long[] longArray = userIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long i2 = longArray[i];
            this.delUserAllAcl(i2);
        }
    }

    public void updataUserAcl(Set<UserAclInfo> userAclInfoSet, long userId) {
        this.delUserAllAcl(userId);
        this.commonDao.saveAll(userAclInfoSet);
    }

    public Set<UserAclInfo> getUserAclByUserId(long userId) {
        String hql = "from UserInfo where id = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(userId));
        List<?> list = this.commonDao.findByHql(hql, param);
        return ((UserInfo)list.get(0)).getUserAcls();
    }

    @Override
    public boolean checkIP(String loginip, Set<UserAclInfo> aclSet) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Enter checkIP.%s.", loginip));
        boolean checkLoginIP = false;
        if (null != aclSet && !aclSet.isEmpty()) {
            for (UserAclInfo temp : aclSet) {
                String endIp;
                String startIp = temp.getStartIp();
                if (!this.checkLoginIp(startIp, endIp = temp.getEndIp(), loginip)) continue;
                checkLoginIP = true;
                break;
            }
        }
        return checkLoginIP;
    }

    @Override
    public boolean checkIP(String loginip, long userId) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Enter checkIP.%s.", loginip));
        boolean checkLoginIP = false;
        Set<UserAclInfo> list = this.getUserAclByUserId(userId);
        if (null != list && !list.isEmpty()) {
            for (UserAclInfo temp : list) {
                String endIp;
                String startIp = temp.getStartIp();
                if (!this.checkLoginIp(startIp, endIp = temp.getEndIp(), loginip)) continue;
                checkLoginIP = true;
                break;
            }
        }
        if (!checkLoginIP) {
            throw new LegoCheckedException(265L);
        }
        return checkLoginIP;
    }

    private boolean checkLoginIp(String startIp, String endIp, String loginIp) {
        BigInteger lEndIp;
        BigInteger lStartIp;
        if (!(startIp.contains(".") || endIp.contains(".") || startIp.contains(":") || endIp.contains(":"))) {
            if (!loginIp.contains(".")) {
                return false;
            }
            lStartIp = new BigInteger(startIp);
            lEndIp = new BigInteger(endIp);
        } else {
            if (!AddressUtil.isSameVersion((String)startIp, (String)loginIp)) {
                return false;
            }
            lStartIp = AddressUtil.ipToInt((String)startIp);
            lEndIp = AddressUtil.ipToInt((String)endIp);
        }
        BigInteger lloginIp = AddressUtil.ipToInt((String)loginIp);
        if (null == lloginIp) {
            LOGGER.error((Object)"LoginIp not cast to BigInteger, loginIp:%s", new Object[]{loginIp});
            throw new LegoCheckedException(201L);
        }
        return lloginIp.compareTo(lStartIp) >= 0 && lloginIp.compareTo(lEndIp) <= 0;
    }

    @Override
    public UserLoginPolicyInfo getLoginPolicy() {
        UserLoginPolicyInfo temp = null;
        try {
            String hql = "from UserLoginPolicyInfo";
            List<?> result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                temp = (UserLoginPolicyInfo)result.get(0);
            }
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return temp;
    }

    @Override
    public void updateLoginPolicy(UserLoginPolicyInfo policy) {
        if (null != policy) {
            if (policy.getSessionTimeOut() < 1) {
                policy.setSessionTimeOut(Integer.valueOf(30));
            }
            this.commonDao.update(policy);
        }
    }

    @Override
    public UserSecPolicyInfo getUserSecPolicy() {
        UserSecPolicyInfo temp = null;
        try {
            String hql = "from UserSecPolicyInfo";
            List<?> result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                temp = (UserSecPolicyInfo)result.get(0);
            }
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return temp;
    }

    @Override
    public void updateUserSecPolicy(UserSecPolicyInfo policy) {
        this.commonDao.update(policy);
    }

    @Override
    public boolean checkLockIP(String loginip) {
        return false;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setSystemInitUser(SystemInitializeUser systemInitUser) {
        this.systemInitUser = systemInitUser;
    }

    @Override
    public void unLockUserInCache(long userId) {
        UserInfo userInfos = null;
        try {
            String hql = "FROM UserInfo where id = ?";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, String.valueOf(userId));
            List<?> result = this.commonDao.findByHql(hql, param);
            if (!result.isEmpty()) {
                userInfos = (UserInfo)result.get(0);
            }
            if (null == userInfos) {
                throw new LegoCheckedException(201L);
            }
            String userName = userInfos.getUserName();
            String userLockKey = USER_LOCK + userName;
            this.removeCacheKey(userName, userLockKey);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"ERROR:", (Throwable)ex, 0L);
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }
}

