/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.core;

import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.consumer.SubscriberProxy;
import com.huawei.lego.comm.internal.jms.core.MsqQueueClient;
import com.huawei.lego.comm.internal.jms.messagecodebase.MessageCodeRegisterException;
import com.huawei.lego.comm.internal.jms.productor.TopicClient;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;

public final class MessageCenter
implements DisposableBean,
IMessageCenter {
    private static final Log LOGGER = LogFactory.getInstance(MessageCenter.class);
    private static MessageCenter mcinstance = null;
    private static Map<Long, String> messCodeRegister = new HashMap<Long, String>();
    private static boolean isSuccessful = false;
    private MessageTopic[] topics = new MessageTopic[]{MessageTopic.COMMAND, MessageTopic.CONFIG, MessageTopic.DATA};
    private Map<MessageTopic, MsqQueueClient> clients = Collections.synchronizedMap(new HashMap());
    private Map<MessageTopic, SubscriberProxy> proxys = Collections.synchronizedMap(new HashMap());

    private MessageCenter() {
        this.initProxys();
    }

    private static void setSuccessful(boolean isSuccess) {
        isSuccessful = isSuccess;
    }

    private void initProxys() {
        for (int i = 0; i < this.topics.length; ++i) {
            TopicClient client = new TopicClient();
            client.setName(this.topics[i].name());
            this.clients.put(this.topics[i], client);
            SubscriberProxy proxy = new SubscriberProxy();
            this.proxys.put(this.topics[i], proxy);
        }
    }

    public static synchronized MessageCenter getInstance() {
        if (null == mcinstance) {
            mcinstance = new MessageCenter();
        }
        return mcinstance;
    }

    public void registerMessageCode(long messcode, String productName) {
        messCodeRegister.put(messcode, productName);
    }

    public void initializeMessageCenter() {
        String addr = LegoProperties.getProperty((String)"jms.server", (String)"tcp://127.0.0.1:61616");
        String url = "failover:(" + addr + ")?initialReconnectDelay=100&maxReconnectAttempts=5";
        for (int i = 0; i < this.topics.length; ++i) {
            MsqQueueClient client = this.clients.get((Object)this.topics[i]);
            client.connect(url);
            try {
                SubscriberProxy proxy = this.proxys.get((Object)this.topics[i]);
                client.setListener(proxy);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Set Listener Error! " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                throw new LegoJMSInitializeException("Set Listener Error: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
        MessageCenter.setSuccessful(true);
        LOGGER.info((Object)"the MessageCenter's initializing is OK!!", 1L);
    }

    public void destroy() {
        if (null != this.clients && !this.clients.isEmpty()) {
            for (MsqQueueClient client : this.clients.values()) {
                client.disconnect();
            }
        }
    }

    @Override
    public void addSubscriberTo(MessageTaskManager subscriber) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, ">>>>>>>MessageTaskManager:--%s.", subscriber.getClass().getName()), 1L);
        for (MessageRegister mr : subscriber.getTypes()) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, ">>>>>>>MessageTopic is : --%s.", new Object[]{mr.getMessageTopic()}), 1L);
            SubscriberProxy proxy = this.proxys.get((Object)mr.getMessageTopic());
            proxy.addSubscriber(mr, subscriber);
        }
    }

    public void delSubscriberTo(List<String> ss) {
        for (SubscriberProxy proxy : this.proxys.values()) {
            proxy.delSubscriber(ss);
        }
    }

    private String checkSendMessage(MessageUnit mu) {
        Long messagecode = NumberUtil.convertToLong((Object)mu.getCmdcode());
        String productName = messCodeRegister.get(messagecode);
        if (!isSuccessful || null == productName) {
            throw new MessageCodeRegisterException("the messageCode is not legal OR MessageCenter's initializing is not over!!");
        }
        return productName;
    }

    @Override
    public void sendMessage(MessageUnit detail) {
        if (null == detail) {
            LOGGER.error((Object)"when sending message,--send's detail is null!", 1L);
            return;
        }
        String messagecodeclassname = this.checkSendMessage(detail);
        MsqQueueClient client = this.clients.get((Object)detail.getMt());
        client.sendObj(detail);
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Sending message is over!the sendApp's name is : %s | the Command code is : %s the RegisterClassName with the messagecode is :--%s.", detail.getSourceAppName(), detail.getCmdcode(), messagecodeclassname), 1L);
    }
}

