/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.base.util.KeyStoreLoader;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.nio.file.Paths;
import java.security.KeyStore;

public final class SecurityCertificateManager {
    private static final Log LOGGER = LogFactory.getInstance(SecurityCertificateManager.class);
    private static final String KEY_STORE = "keyStore";

    private SecurityCertificateManager() {
    }

    public static KeyStore getDefaultKeyStoreFromCache(String keyStoreFile) {
        return KeyStoreLoader.getKeyStore(keyStoreFile, () -> new KeyStoreLoader(KeyStore.getDefaultType(), Paths.get(keyStoreFile, new String[0]), SecurityCertificateManager::getKeyStorePassword));
    }

    public static KeyStore getDefaultKeyStore(String keyStoreFile, long expectedKeystoreFileModifyTime) {
        if (KeyStoreLoader.getKeystoreFileModifyTime() == expectedKeystoreFileModifyTime) {
            return SecurityCertificateManager.getDefaultKeyStoreFromCache(keyStoreFile);
        }
        LOGGER.info((Object)"KeystoreFileModifyTime not match, create new KeyStore.");
        KeyStoreLoader keyStoreLoader = new KeyStoreLoader(KeyStore.getDefaultType(), Paths.get(keyStoreFile, new String[0]), SecurityCertificateManager::getKeyStorePassword);
        return keyStoreLoader.get().map(FutureResult::rethrow).map(FutureResult::getData).orElseThrow(() -> new LegoCheckedException("Get key store failed.").log(LOGGER));
    }

    public static String getKeyStorePassword() {
        return WccEncryptor.decrypt((String)LegoConfig.getInstance().getKeyValue(KEY_STORE));
    }
}

