/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.confmgr.parser;

import com.huawei.lego.core.base.confmgr.EntryProcessor;
import com.huawei.lego.core.base.service.IParser;
import com.huawei.lego.core.base.service.IProcessEntry;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class XmlConfigParser
implements IParser {
    private static final Log LOGGER = LogFactory.getInstance(XmlConfigParser.class);
    private List<URL> extensions;
    private IProcessEntry processEntry;
    private EntryProcessor processor;

    public XmlConfigParser(List<URL> extensions, EntryProcessor processor, IProcessEntry processEntry) {
        this.extensions = extensions;
        this.processEntry = processEntry;
        this.processor = processor;
    }

    @Override
    public void parse(String type) {
        ArrayList bContext = new ArrayList();
        HashMap context = new HashMap();
        if (this.extensions.isEmpty()) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Extensions is empty,type:%s.", type));
        }
        for (URL url : this.extensions) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("bundle.indentifier", "lego-base");
            hashMap.put("bundle.url", url);
            bContext.add(hashMap);
        }
        if (bContext.isEmpty()) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "BContext is empty,type:%s.", type));
        }
        SAXReader reader = new SAXReader();
        for (Map map : bContext) {
            try {
                CommonUtil.setSecurityFeatures((SAXReader)reader);
                Document document = reader.read((URL)map.get("bundle.url"));
                Element root = document.getRootElement();
                root.addAttribute("bundle", (String)map.get("bundle.indentifier"));
                this.processor.setContext(type, context);
                this.processor.setElement(type, root);
                this.processor.addEntry(type, this.processEntry);
            }
            catch (DocumentException | SAXException e1) {
                LOGGER.error((Object)e1, 1L);
            }
        }
    }
}

