/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.service;

import com.huawei.lego.core.base.persistance.ISessionProvider;
import com.huawei.lego.core.base.persistance.service.DynamicConfiguration;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.event.spi.LoadEventListener;

public class DynamicSessionFactoryService
implements ISessionProvider {
    private static Map<String, DynamicConfiguration> configurations = new ConcurrentHashMap<String, DynamicConfiguration>();
    private static final String KEY_STATISTICS_ENABLED = "hibernate.statistics.enabled";
    private static final boolean DEFAULT_STATISTICS_ENABLED = false;
    private Interceptor interceptor;
    private List<LoadEventListener> listeners;

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public List<LoadEventListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<LoadEventListener> listeners) {
        this.listeners = listeners;
    }

    private DynamicConfiguration getConfiguration(String key) {
        DynamicConfiguration configuration = configurations.get(key);
        if (null == configuration) {
            configuration = new DynamicConfiguration(LegoConfig.getInstance().getBoolean(KEY_STATISTICS_ENABLED, Boolean.valueOf(false)));
        }
        return configuration;
    }

    public Map<String, DynamicConfiguration> getAllConfigurations() {
        return configurations;
    }

    public void addURL(String key, InputStream is) {
        DynamicConfiguration configuration = this.getConfiguration(key);
        configuration.addStream(is);
        configurations.put(key, configuration);
    }

    public void addCfg(String key, URL url) {
        DynamicConfiguration configuration = this.getConfiguration(key);
        configuration.addConfig(url);
        configurations.put(key, configuration);
    }

    public void addClass(String key, Class cl) {
        DynamicConfiguration configuration = this.getConfiguration(key);
        configuration.addClass(cl);
        configurations.put(key, configuration);
    }

    public void addHBM(String key, URL url) {
        DynamicConfiguration configuration = this.getConfiguration(key);
        configuration.addHbm(url);
        configurations.put(key, configuration);
    }

    public void buildSessionFactory(String key) {
        DynamicConfiguration configuration = this.getConfiguration(key);
        configuration.createNewSessionFactory();
        configurations.put(key, configuration);
    }

    @Override
    public SessionFactory getSessionFactory(String key) {
        DynamicConfiguration configuration = configurations.get(key);
        if (null != configuration) {
            SessionFactory sessionFactory = null;
            try {
                sessionFactory = configuration.getSessionFactory();
                if (sessionFactory == null) {
                    throw new LegoUncheckedException("Session factory build failed!!!!");
                }
                sessionFactory.getStatistics().setStatisticsEnabled(LegoConfig.getInstance().getBoolean(KEY_STATISTICS_ENABLED, Boolean.valueOf(false)).booleanValue());
            }
            catch (Exception e) {
                LogFactory.getInstance(DynamicSessionFactoryService.class);
            }
            return sessionFactory;
        }
        return null;
    }
}

