/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain;

import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.core.domain.ContainerInitializer;
import com.huawei.lego.core.domain.DomainContainer;
import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.sdk.base.IContextInjector;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Application;
import com.huawei.lego.core.sdk.base.model.AppPriority;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.model.ServiceType;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.domain.IInitializer;
import com.huawei.lego.core.sdk.domain.IManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Application(name="DomainApplicaton", desc="this is the core application of lego system", priority=AppPriority.IMPORTANT)
public class DomainApplicaton
extends AbsApplication {
    private static IMessageCenter imc = null;
    private static final Log LOGGER = LogFactory.getInstance(DomainApplicaton.class);
    private IContextInjector injector;
    private IInitializer initializer;
    private Map<String, ProductContext> pContext = new HashMap<String, ProductContext>();

    public static IMessageCenter getImc() {
        return imc;
    }

    private static void setMessageCenter(IMessageCenter msgCenter) {
        imc = msgCenter;
    }

    public void setImc(IMessageCenter imcParam) {
        DomainApplicaton.setMessageCenter(imcParam);
    }

    public void addProductContext(String pID, ProductContext pContextParam) {
        this.pContext.put(pID, pContextParam);
    }

    public void setProductContext(Map<String, ProductContext> context) {
        this.pContext = context;
    }

    public void setInjector(IContextInjector injector) {
        this.injector = injector;
    }

    public void setInitializer(IInitializer initializer) {
        this.initializer = initializer;
    }

    public void registerService(IService service) {
        if (service instanceof DomainContainer) {
            ((DomainContainer)service).setProductContext(this.pContext);
        }
    }

    public void start(List<ICallback> callback) {
        Map context = this.injector.getContext("com.huawei.lego.core.domain");
        if (context != null && !context.isEmpty()) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, ">>>>>>>>>>>>>>>>>>context is : %s.", context), 1L);
            if (this.initializer instanceof ContainerInitializer) {
                ((ContainerInitializer)this.initializer).setApplication(this);
            }
            this.initializer.initialize(context.values());
        } else {
            LOGGER.info((Object)">>>>>>>>>>>>>>>>>>context is null or empty", 1L);
        }
        this.exportMOManager(this.pContext);
        if (null != callback) {
            super.start(callback);
        }
    }

    public IDomainContainer getDomainContainer() {
        IDomainContainer result = null;
        if (!this.getServices().isEmpty()) {
            for (IService service : this.getServices()) {
                if (!(service instanceof IDomainContainer)) continue;
                result = (IDomainContainer)service;
            }
        }
        return result;
    }

    public void exportMOManager(Map pMapping) {
        if (pMapping.isEmpty()) {
            LOGGER.error((Object)"Mo manager mapping is empty,can not export any mo manager service!");
            return;
        }
        try {
            Set pEntries = pMapping.entrySet();
            for (Map.Entry pEntry : pEntries) {
                String exportStr = ((String)pEntry.getKey()).concat("-");
                Set<Map.Entry<String, ModelServiceMapping>> mEntries = ((ProductContext)pEntry.getValue()).getpModelMappings().entrySet();
                for (Map.Entry<String, ModelServiceMapping> mEntry : mEntries) {
                    exportStr = exportStr.concat(mEntry.getKey());
                    this.exportManager(exportStr, mEntry);
                }
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e, 1L);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e, 1L);
        }
    }

    private void exportManager(String exportStr, Map.Entry<String, ModelServiceMapping> mEntry) throws InstantiationException, IllegalAccessException {
        Class clazz = mEntry.getValue().getModelCtx().getMoManager();
        if (clazz != null) {
            Object instance = clazz.newInstance();
            Class<?>[] interfaces = clazz.getInterfaces();
            ServiceInfo infor = new ServiceInfo();
            infor.setApp(this.getAppinfo());
            infor.setType(ServiceType.MO_MANAGER);
            infor.setInterfaceName(interfaces[0].getName());
            infor.setName(exportStr);
            infor.setService((Object)((IManager)instance));
            this.getAppinfo().addService(infor);
            ServiceContext.getInstance().register(this.getAppinfo());
        } else {
            LOGGER.info((Object)"++++++++++++++this is no manager define in model!", 1L);
        }
    }

    public void stop(List<ICallback> callback) {
        super.stop(callback);
    }
}

