/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.domain.context.ModelContext;
import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SynchronizeManager {
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeManager.class);
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_12000 = 12000;
    private static final int VALUE_10 = 10;
    private static final int VALUE_60 = 60;
    private Map<String, XmlSynchronizeContext> mappings;
    private XmlSynchronizeContext xmlSynchronizeContext;
    private ModelXMLHandler xmlHandler;
    private IMessageCenter messageCenter;

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public Map<String, XmlSynchronizeContext> getMappings() {
        return this.mappings;
    }

    public boolean initializer(IDomainContainer container) {
        this.xmlHandler = new ModelXMLHandler();
        this.mappings = new HashMap<String, XmlSynchronizeContext>();
        return this.initializerFromDomain(container);
    }

    private boolean initializerFromDomain(IDomainContainer container) {
        Map productMapping = container.getProductMappings();
        for (Map.Entry entry : productMapping.entrySet()) {
            String productId = (String)entry.getKey();
            ProductContext productContext = (ProductContext)entry.getValue();
            LOGGER.info((Object)"ProductId is : %s", new Object[]{productId});
            LOGGER.info((Object)"ProductContext is : %s", new Object[]{productContext});
            Map<String, ModelServiceMapping> modelServices = productContext.getpModelMappings();
            if (modelServices != null && !modelServices.isEmpty()) {
                LOGGER.info((Object)"ModelServices is : %s", new Object[]{modelServices});
                this.dealIndexForModelServices(modelServices, productId, productContext);
                continue;
            }
            LOGGER.info((Object)"ModelServices is : null or empty.");
        }
        return true;
    }

    private void dealIndexForModelServices(Map<String, ModelServiceMapping> modelServices, String productId, ProductContext productContext) {
        for (Map.Entry<String, ModelServiceMapping> modelServiceEntry : modelServices.entrySet()) {
            ModelContext modelCtx;
            ModelServiceMapping modelService = modelServiceEntry.getValue();
            if (modelService == null || (modelCtx = modelService.getModelCtx()) == null) continue;
            String index = modelCtx.getIndex();
            this.dealIndex(index, modelCtx, productId, productContext);
        }
    }

    private void dealIndex(String index, ModelContext modelCtx, String productId, ProductContext productContext) {
        if ("1".equals(index)) {
            this.xmlSynchronizeContext = new XmlSynchronizeContext();
            this.xmlSynchronizeContext.setProductId(productId);
            this.xmlSynchronizeContext.setModelId(modelCtx.getId());
            this.xmlSynchronizeContext.setType(modelCtx.getMoType());
            this.xmlSynchronizeContext.setSubType(modelCtx.getSubType());
            this.xmlSynchronizeContext.setMoClass(modelCtx.getMoClass());
            this.xmlSynchronizeContext.setTopMo(true);
            this.xmlSynchronizeContext.setReferredOid(modelCtx.getReferredOid());
            this.xmlSynchronizeContext.setReferingOid(modelCtx.getReferingOid());
            this.xmlSynchronizeContext.setIsPolling("true".equalsIgnoreCase(modelCtx.getIsPolling()));
            String topMoClazzName = this.xmlSynchronizeContext.getMoClass().getName();
            boolean isPolling = this.xmlSynchronizeContext.isPolling();
            this.extracted(modelCtx);
            Map sysOidXmlSynchronizeContextMap = this.xmlSynchronizeContext.getSysOidXmlSynchronizeContextMap();
            if (sysOidXmlSynchronizeContextMap != null) {
                LOGGER.info((Object)"SysOidXmlSynchronizeContextMap is : %s.", new Object[]{sysOidXmlSynchronizeContextMap});
                this.mappings.putAll(sysOidXmlSynchronizeContextMap);
            } else {
                LOGGER.info((Object)"SysOidXmlSynchronizeContextMap is : null");
            }
            List<ModelContext> subModels = modelCtx.getSubModel();
            if (!subModels.isEmpty()) {
                XmlSynchronizeContext parent = this.xmlSynchronizeContext;
                for (ModelContext subModel : subModels) {
                    this.addModelChild(productId, subModel, parent);
                }
            }
            if (isPolling) {
                this.devicePolling(productContext.getPollingInterval(), topMoClazzName, productId);
            }
        }
    }

    private void extracted(ModelContext modelCtx) {
        try {
            URL url;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null && (url = modelCtx.getDefinition().startsWith("/") ? cl.getResource(modelCtx.getDefinition().substring(1)) : cl.getResource(modelCtx.getDefinition())) != null) {
                this.xmlHandler.parser(url.openStream());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Read model definition error!", (Throwable)e);
        }
    }

    private void devicePolling(String pollingInterval, String topMoClazzName, String productId) {
        LOGGER.info((Object)"PollingInterval is : %s,productId is :%s.", new Object[]{pollingInterval, productId});
        if (StringUtils.hasText((String)pollingInterval)) {
            long interval = -1L;
            try {
                interval = Long.parseLong(pollingInterval);
                if (interval <= 0L) {
                    throw new NumberFormatException();
                }
                interval *= 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Exception when parse pollingInterval, pollingInterval is :%s,%s. ", new Object[]{pollingInterval, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            if (interval != -1L) {
                DevicePollingThread devicePollingThread = new DevicePollingThread(interval, topMoClazzName);
                devicePollingThread.setThreadName("DevicePollingThread_" + productId);
                ExecutionService.submitTask(devicePollingThread);
            }
        }
    }

    private void addModelChild(String productId, ModelContext modelCtx, XmlSynchronizeContext parent) {
        XmlSynchronizeContext child = new XmlSynchronizeContext();
        child.setProductId(productId);
        child.setModelId(modelCtx.getId());
        child.setType(modelCtx.getMoType());
        child.setSubType(modelCtx.getSubType());
        child.setMoClass(modelCtx.getMoClass());
        child.setReferredOid(modelCtx.getReferredOid());
        child.setReferingOid(modelCtx.getReferingOid());
        child.setIsPolling("true".equalsIgnoreCase(modelCtx.getIsPolling()));
        try {
            URL url;
            this.xmlSynchronizeContext = child;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null && (url = cl.getResource(modelCtx.getDefinition())) != null) {
                this.xmlHandler.parser(url.openStream());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Read model definition error, %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        List<ModelContext> subModels = modelCtx.getSubModel();
        if (!subModels.isEmpty()) {
            for (ModelContext subModel : subModels) {
                this.addModelChild(productId, subModel, child);
            }
        }
        parent.addChild(child);
    }

    class ModelXMLHandler
    extends DefaultHandler {
        ModelXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("model".equals(qName)) {
                SynchronizeManager.this.xmlSynchronizeContext.setSysOids(attributes.getValue("sysoid"));
            } else if ("fields".equals(qName)) {
                SynchronizeManager.this.xmlSynchronizeContext.setSynchronizer(attributes.getValue("handler"));
            } else if ("attribute".equals(qName)) {
                HashMap<String, XmlSynchronizeContext> sysOidXmlSynchronizeContextMap = SynchronizeManager.this.xmlSynchronizeContext.getSysOidXmlSynchronizeContextMap();
                if (sysOidXmlSynchronizeContextMap == null) {
                    sysOidXmlSynchronizeContextMap = new HashMap<String, XmlSynchronizeContext>();
                }
                this.startElementAttribute(attributes, sysOidXmlSynchronizeContextMap);
            } else {
                LOGGER.error((Object)"Not supported.");
            }
        }

        private void startElementAttribute(Attributes attributes, Map<String, XmlSynchronizeContext> sysOidXmlSynchronizeContextMap) {
            SynchronizeManager.this.xmlSynchronizeContext.setSysOidXmlSynchronizeContextMap(sysOidXmlSynchronizeContextMap);
            String sysoid = attributes.getValue("sysoid");
            if (sysoid != null && !"".equals(sysoid.trim())) {
                sysOidXmlSynchronizeContextMap.put(sysoid.trim(), SynchronizeManager.this.xmlSynchronizeContext);
            }
        }

        public void parser(InputStream is) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            try {
                CommonUtil.setSecurityFeatures((SAXParserFactory)factory);
                SAXParser parser = factory.newSAXParser();
                parser.parse(is, (DefaultHandler)this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.error((Object)"Parse failed!", (Throwable)e, 1L);
            }
        }
    }

    class DevicePollingThread
    extends CommonThread {
        private long pollingInterval;
        private IResourceService resourceService;
        private IDiscoveryService discoveryService;
        private String topMoClazzName;

        public DevicePollingThread(long pollingInterval, String topMoClazzName) {
            this.pollingInterval = pollingInterval;
            this.topMoClazzName = topMoClazzName;
        }

        @Override
        public void execute() {
            CommonUtil.sleep((long)600000L);
            boolean shouldContinue = true;
            while (shouldContinue) {
                shouldContinue = this.dealMoList();
            }
        }

        private boolean dealMoList() {
            try {
                CommonUtil.sleep((long)this.pollingInterval);
                ServiceContext context = ServiceContext.getInstance();
                if (this.resourceService == null) {
                    this.resourceService = (IResourceService)context.lookup("ResourceApplication/ResourceServiceImpl");
                }
                if (this.resourceService == null) {
                    LOGGER.error((Object)"ResourceService is : null");
                    return false;
                }
                if (this.discoveryService == null) {
                    this.discoveryService = (IDiscoveryService)context.lookup("discover/DiscoveryServiceImpl");
                }
                if (this.discoveryService == null) {
                    LOGGER.error((Object)"DiscoveryService is : null");
                    return false;
                }
                List moList = this.resourceService.getMoByType(this.topMoClazzName);
                if (moList == null) {
                    return true;
                }
                this.dealMoList(moList);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception when polling device:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            return true;
        }

        private void dealMoList(List<ManagedObject> moList) {
            for (ManagedObject mo : moList) {
                if (!(mo instanceof Node)) continue;
                Node node = (Node)mo;
                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                messageBody.put("snmpDiscoveredNode", node);
                messageBody.put("isDevicePolling", "true");
                LOGGER.info((Object)"MessageBody from timely");
                if (this.dealTmpMo(mo, messageBody)) continue;
                CommonUtil.sleep((long)12000L);
            }
        }

        private boolean dealTmpMo(ManagedObject mo, Map<String, Object> messageBody) {
            boolean isContinue = false;
            if (this.discoveryService.isDeviceCanRefresh(mo.getMoId())) {
                ManagedObject tempMo = this.resourceService.getMoByUuid(mo.getUuid(), null);
                if (tempMo != null) {
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(101L);
                    mu.setObj(messageBody);
                    mu.setMt(MessageTopic.COMMAND);
                    mu.setSourceAppName(this.getClass().getName());
                    SynchronizeManager.this.messageCenter.sendMessage(mu);
                } else {
                    LOGGER.info((Object)"The device does not exist, uuid is : %s, moid is :%s", new Object[]{mo.getUuid(), mo.getMoId()});
                    isContinue = true;
                }
            } else {
                LOGGER.info((Object)"The device is deleting, uuid is : %s, moid is : %s", new Object[]{mo.getUuid(), mo.getMoId()});
                isContinue = true;
            }
            return isContinue;
        }
    }
}

