/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.syslog.service;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.sdk.service.SerialNumberService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SerialNumberContainer {
    private static final Log logger = LogFactory.getInstance(SerialNumberContainer.class);
    private static List<SerialNumberService> serialNumberServiceList = new ArrayList<SerialNumberService>();

    public static void dealWithSerialNumber(OptLogMo optLogMo) {
        if (null == serialNumberServiceList || serialNumberServiceList.isEmpty()) {
            return;
        }
        try {
            for (SerialNumberService service : serialNumberServiceList) {
                service.setSerialNumber(optLogMo);
            }
        }
        catch (Exception t) {
            logger.error((Object)("product throw exception.Deal with optLogMo error" + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
        }
    }

    public void onBind(SerialNumberService service, Map<String, String> properties) {
        if (null != service) {
            serialNumberServiceList.add(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(SerialNumberService service, Map<String, String> properties) {
        if (null != service) {
            serialNumberServiceList.remove(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<SerialNumberService> getSerialNumberServiceList() {
        return serialNumberServiceList;
    }

    public static void setSerialNumberServiceList(List<SerialNumberService> serialNumberServiceList) {
        SerialNumberContainer.serialNumberServiceList = serialNumberServiceList;
    }
}

