/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.common;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.huawei.lego.core.system.sysmonitor.service.dbmoniservice.IDBMonitor;
import com.huawei.lego.core.system.sysmonitor.service.dealwithevent.IDealWithAlarm;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.HostServerMonitorImpl;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.IhostServerMonitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SysMonitorCache {
    private static final Log LOGGER = LogFactory.getInstance(SysMonitorCache.class);
    private static final int KEEP_POINT = 5;
    private static final int DEFULT_COUNT = 60;
    private List<Map<Long, HostServerMonitorInfo>> hostInfoList = new ArrayList<Map<Long, HostServerMonitorInfo>>();
    private List<Map<Long, List<DataBaseInfo>>> dataBaseList = new ArrayList<Map<Long, List<DataBaseInfo>>>();
    private IDBMonitor dbMonitor;
    private IhostServerMonitor hostServerMonitor = new HostServerMonitorImpl();
    private IDealWithAlarm dealWithAlarm;

    public void run(int count, boolean firstStart) {
        if (null == this.hostInfoList || null == this.dataBaseList) {
            LOGGER.error((Object)"SysMonitorCache  hostInfoList is null", 1L);
            return;
        }
        long currentTime = System.currentTimeMillis();
        HostServerMonitorInfo hostInfo = null;
        List<DataBaseInfo> dataBaseInfo = null;
        HashMap<Long, HostServerMonitorInfo> hostMap = new HashMap<Long, HostServerMonitorInfo>();
        HashMap<Long, List<DataBaseInfo>> dataBaseMap = null;
        if (60 == count || firstStart) {
            hostInfo = this.hostServerMonitor.getHostServerInfo(count, firstStart);
            try {
                dataBaseInfo = this.dbMonitor.getDbInfo();
                if (null != dataBaseInfo && !dataBaseInfo.isEmpty()) {
                    dataBaseMap = new HashMap<Long, List<DataBaseInfo>>();
                    dataBaseMap.put(currentTime, dataBaseInfo);
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
        } else if (!VerifyUtil.isEmpty(this.hostInfoList)) {
            Map<Long, HostServerMonitorInfo> lastHostInfo = this.hostInfoList.get(this.hostInfoList.size() - 1);
            Set<Map.Entry<Long, HostServerMonitorInfo>> enity = lastHostInfo.entrySet();
            for (Map.Entry<Long, HostServerMonitorInfo> temp : enity) {
                hostInfo = temp.getValue();
            }
            HostServerMonitorInfo temp = this.hostServerMonitor.getHostServerInfo(count, firstStart);
            ResourceUse memoryInfo = temp.getMemoryInfo();
            ResourceUse cpuInfo = temp.getCpuInfo();
            if (null != hostInfo) {
                hostInfo.setCpuInfo(cpuInfo);
                hostInfo.setMemoryInfo(memoryInfo);
            }
        }
        hostMap.put(currentTime, hostInfo);
        this.freshMonitor(this.hostInfoList, hostMap);
        this.freshMonitor(this.dataBaseList, dataBaseMap);
        this.dealWithAlarm.generateEvent(dataBaseInfo);
        this.dealWithAlarm.generateEvent(hostInfo);
    }

    private void freshMonitor(List list, Object obj) {
        if (null == obj) {
            return;
        }
        if (null != list && list.size() >= 5) {
            list.remove(0);
        }
        if (null != list) {
            list.add(obj);
        }
    }

    public List<Map<Long, HostServerMonitorInfo>> getHostInfoList() {
        return this.hostInfoList;
    }

    public void setHostInfoList(List<Map<Long, HostServerMonitorInfo>> hostInfoList) {
        this.hostInfoList = hostInfoList;
    }

    public List<Map<Long, List<DataBaseInfo>>> getDataBaseList() {
        return this.dataBaseList;
    }

    public void setDataBaseList(List<Map<Long, List<DataBaseInfo>>> dataBaseList) {
        this.dataBaseList = dataBaseList;
    }

    public void setDealWithAlarm(IDealWithAlarm dealWithAlarm) {
        this.dealWithAlarm = dealWithAlarm;
    }

    public void setDbMonitor(IDBMonitor dbMonitor) {
        this.dbMonitor = dbMonitor;
    }
}

