/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.dbmoniservice;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MathUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.huawei.lego.core.system.sysmonitor.service.dbmoniservice.IDbResourceDao;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

public class DbResourceDao
extends HibernateDaoSupportWrapper
implements IDbResourceDao {
    private static final Log LOGGER = LogFactory.getInstance(DbResourceDao.class);
    private static final int VALUE_3 = 3;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int VERSION_MAIN = 5;
    private static final int VERSION_SUB_MAIN = 1;
    private static final int VERSION_SUB = 25;
    private static String sqlversion = "";
    private String sqlTypeName = "";
    private boolean checkMysqlVersion = Boolean.FALSE;
    private boolean checkSustainDataFree = Boolean.FALSE;

    private static void setSQLVersion(String sqlVersionParam) {
        sqlversion = sqlVersionParam;
    }

    @Override
    public List<DataBaseInfo> getDbInfo() throws SQLException {
        ArrayList<DataBaseInfo> databaseList = null;
        if (null == this.sqlTypeName || this.sqlTypeName.equalsIgnoreCase("")) {
            this.getSqlType();
        }
        String sqlTyepe = this.sqlTypeName;
        String hsql = this.getSql(this.sqlTypeName);
        if ("".equals(hsql)) {
            return databaseList;
        }
        List<?> rs = null;
        try {
            rs = this.findBySql(hsql);
            if (null == rs) {
                return databaseList;
            }
            int rsindex = rs.size();
            databaseList = new ArrayList<DataBaseInfo>();
            for (int i = 0; i < rsindex; ++i) {
                Object[] objs = (Object[])rs.get(i);
                DataBaseInfo tempInfo = this.getDatabaseInfos(objs, sqlTyepe);
                if (null == tempInfo) continue;
                databaseList.add(tempInfo);
            }
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        catch (Exception e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return databaseList;
    }

    private String getSql(String sqlType) {
        String sql = "";
        if ("MySQL".equals(sqlType)) {
            sql = "select table_schema, sum(`DATA_LENGTH`),sum(`DATA_FREE`) from information_schema.`TABLES` group by table_schema";
        } else if ("Microsoft SQL Server".equals(sqlType)) {
            sql = "sp_helpdb";
        } else if ("ORACLE".equals(sqlType)) {
            sql = "";
        } else if ("GaussDB".equals(sqlType)) {
            sql = "select pg_database.datname, pg_database_size(pg_database.datname) AS size2,pg_tablespace_size(pg_database.dattablespace) AS size from pg_database";
        }
        LOGGER.debug((Object)"getSql:completed");
        return sql;
    }

    private DataBaseInfo getDatabaseInfos(Object[] objs, String sqlType) {
        DataBaseInfo tempInfo = null;
        if ("MySQL".equals(sqlType)) {
            tempInfo = this.getDatabaseInfo(objs);
            if (null != tempInfo) {
                tempInfo.setSqlTypeName("MySQL");
            }
        } else if ("GaussDB".equals(sqlType) && null != (tempInfo = this.getDatabaseInfo(objs))) {
            tempInfo.setSqlTypeName("GaussDB");
        }
        LOGGER.debug((Object)"getDatabaseInfos:completed");
        return tempInfo;
    }

    private DataBaseInfo getDatabaseInfo(Object[] objs) {
        DataBaseInfo dataBaseInfo = null;
        if (null == objs || objs.length < 3) {
            return new DataBaseInfo();
        }
        if ("MySQL".equals(this.sqlTypeName)) {
            dataBaseInfo = this.getMysqlDatabaseInfo(objs);
        } else if ("GaussDB".equals(this.sqlTypeName)) {
            dataBaseInfo = this.getGaussDatabaseInfo(objs);
        }
        return dataBaseInfo;
    }

    private DataBaseInfo getGaussDatabaseInfo(Object[] objs) {
        DataBaseInfo dataBaseInfo = null;
        String dbName = objs[0].toString();
        if (dbName.isEmpty() || dbName.equals("POSTGRES") || dbName.equals("TEMPLATE0") || dbName.equals("TEMPLATE1")) {
            LOGGER.debug((Object)"system database", 1L);
            return dataBaseInfo;
        }
        try {
            double dbCapacity = NumberUtil.convertToLong((Object)objs[1].toString()).longValue();
            double dbRemainCapacity = NumberUtil.convertToLong((Object)objs[2].toString()).longValue();
            double dbCapacityMb = dbCapacity / 1048576.0;
            dbCapacityMb = MathUtil.getDoubleValue((double)dbCapacityMb);
            double tempRemainCapMb = dbRemainCapacity / 1048576.0;
            double total = tempRemainCapMb = MathUtil.getDoubleValue((double)tempRemainCapMb);
            double percent = 0.0;
            if (dbCapacityMb > 0.0) {
                percent = MathUtil.getDoubleValue((double)(dbCapacityMb / total)) * 100.0;
            }
            dataBaseInfo = new DataBaseInfo();
            dataBaseInfo.setDataBaseName(dbName);
            dataBaseInfo.setTotal(total + " MB");
            dataBaseInfo.setUsed(dbCapacityMb + " MB");
            dataBaseInfo.setRemainCapacity(tempRemainCapMb + " MB");
            dataBaseInfo.setRemain(tempRemainCapMb + " MB");
            dataBaseInfo.setPercent(percent + "%");
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e, 1L);
        }
        return dataBaseInfo;
    }

    private DataBaseInfo getMysqlDatabaseInfo(Object[] objs) {
        DataBaseInfo dataBaseInfo = null;
        String dbName = objs[0].toString();
        if (dbName.isEmpty() || dbName.equals("information_schema") || dbName.equals("mysql") || dbName.equals("performance_schema")) {
            LOGGER.debug((Object)"system database", 1L);
            return dataBaseInfo;
        }
        try {
            double dbCapacity = NumberUtil.convertToLong((Object)objs[1].toString()).longValue();
            double dbRemainCapacity = NumberUtil.convertToLong((Object)objs[2].toString()).longValue();
            double dbCapacityMb = dbCapacity / 1048576.0;
            dbCapacityMb = MathUtil.getDoubleValue((double)dbCapacityMb);
            double tempRemainCapMb = dbRemainCapacity / 1048576.0;
            tempRemainCapMb = MathUtil.getDoubleValue((double)tempRemainCapMb);
            double total = dbCapacityMb + tempRemainCapMb;
            double percent = 0.0;
            if (dbCapacityMb > 0.0) {
                percent = MathUtil.getDoubleValue((double)(dbCapacityMb / total)) * 100.0;
            }
            dataBaseInfo = new DataBaseInfo();
            dataBaseInfo.setDataBaseName(dbName);
            dataBaseInfo.setTotal(total + " MB");
            dataBaseInfo.setUsed(dbCapacityMb + " MB");
            if (this.sustainDataFree()) {
                LOGGER.debug((Object)"current dataBase version is ", 1L);
                dataBaseInfo.setRemainCapacity(tempRemainCapMb + " MB");
                dataBaseInfo.setRemain(tempRemainCapMb + " MB");
                dataBaseInfo.setPercent(percent + "%");
            } else {
                dataBaseInfo.setRemainCapacity("N/A");
                dataBaseInfo.setRemain("N/A");
                dataBaseInfo.setPercent("N/A");
                dataBaseInfo.setVersion(this.getMySqlVersion());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e, 1L);
        }
        return dataBaseInfo;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public void setSqlTypeName(String sqlTypeName) {
        this.sqlTypeName = sqlTypeName;
    }

    private String getMySqlVersion() {
        String hsql;
        if ((sqlversion == null || sqlversion.equalsIgnoreCase("")) && !(hsql = "SELECT VERSION()").equals("")) {
            List<?> rs = null;
            try {
                rs = this.findBySql(hsql);
                this.getSqlVersion(rs);
            }
            catch (DataAccessException e) {
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
        }
        return sqlversion;
    }

    private void getSqlVersion(List<?> rs) {
        if (null != rs) {
            int rsindex = rs.size();
            for (int i = 0; i < rsindex; ++i) {
                DbResourceDao.setSQLVersion(rs.get(i).toString());
            }
        }
    }

    private boolean sustainDataFree() {
        boolean enable = false;
        String mysqlVersion = this.getMySqlVersion();
        if (!this.checkMysqlVersion) {
            this.checkMysqlVersion = Boolean.TRUE;
            if (null == mysqlVersion || mysqlVersion.equals("")) {
                return enable;
            }
            String[] version = mysqlVersion.split("-");
            String[] vers = version[0].split("\\.");
            int version1 = 0;
            int version2 = 0;
            int version3 = 0;
            if (vers.length == 3) {
                version1 = NumberUtil.convertToInteger((Object)vers[0]);
                version2 = NumberUtil.convertToInteger((Object)vers[1]);
                version3 = NumberUtil.convertToInteger((Object)vers[2]);
            } else if (vers.length == 2) {
                version1 = NumberUtil.convertToInteger((Object)vers[0]);
                version2 = NumberUtil.convertToInteger((Object)vers[1]);
            } else if (vers.length == 1) {
                version1 = NumberUtil.convertToInteger((Object)vers[0]);
            }
            if (version1 > 5) {
                enable = true;
            } else if (version1 == 5) {
                enable = this.getVersionEnable(version2, version3, enable);
            }
            this.checkSustainDataFree = enable;
        }
        return this.checkSustainDataFree;
    }

    private boolean getVersionEnable(int version2, int version3, boolean enable) {
        if (version2 > 1) {
            enable = true;
        } else if (version2 == 1 && version3 >= 25) {
            enable = true;
        }
        LOGGER.debug((Object)"getVersionEnable:completed");
        return enable;
    }

    private void getSqlType() {
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            session.doWork(connection -> {
                this.sqlTypeName = connection.getMetaData().getDatabaseProductName();
            });
        }
        catch (Exception e) {
            LOGGER.error((Object)("session is error" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    private List<?> findBySql(String sql) {
        LOGGER.debug((Object)"findBySql");
        return (List)super.getHibernateTemplate().execute(session -> session.createSQLQuery(sql).list());
    }

    @Override
    public ResourceUse queryResource(String tableSpacePath) {
        LOGGER.debug((Object)"queryResource");
        return null;
    }
}

