/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.define;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.define.FaultDefineCacher;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.util.FaultSdkUtil;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.ArrayList;
import java.util.List;

public class FaultDefineUtil {
    private static final Log logger = LogFactory.getInstance(FaultDefineUtil.class);
    private static List<String> legoAlarmIds = new ArrayList<String>();

    public static void appendDefineProps(String productName, String trapoid, Alarm alarm) {
        FaultDefine define = FaultDefineUtil.getLegoDefine(alarm, productName, trapoid);
        if (null == define) {
            throw new LegoCheckedException("get FaultDefine failed, moId: " + alarm.getMoId() + ", productName: " + productName + ", trapoid: " + trapoid + ", alarmId: " + alarm.getAlarmId());
        }
        FaultDefineUtil.appendDefineProps(alarm, define);
    }

    public static void appendDefineProps(Alarm alarm, FaultDefine define) {
        if (define == null) {
            return;
        }
        try {
            if (FaultEnum.AlarmSeverity.ILLEGAL.getValue() == alarm.getSeverity()) {
                alarm.setSeverity(define.getFaultLevel());
            }
            if (FaultEnum.AlarmType.ILLEGAL.getValue() == alarm.getAlarmType()) {
                alarm.setAlarmType(define.getFaultType());
            }
            alarm.setAlarmName(define.getFaultName());
            alarm.setDesc(define.getFaultDesc());
            alarm.setEffect(define.getSysEffect());
            alarm.setAdvice(define.getAdvice());
            alarm.setLocation(define.getLocation());
            alarm.setProductName(define.getProductName());
            if (null == alarm.getMoMainType()) {
                alarm.setMoMainType(define.getMoMainType());
            }
            if (null == alarm.getMoSubType()) {
                alarm.setMoSubType(define.getMoSubType());
            }
            alarm.setParams(FaultSdkUtil.convertParam((String[])alarm.getParamList()));
            if (FaultEnum.NonJointAlarmID.LARGELOGALARM.getValue().equals(alarm.getAlarmId())) {
                alarm.setEntity(alarm.getMoId() + alarm.getAlarmId());
            } else {
                alarm.setEntity(FaultUtil.getEntity(alarm.getMoId(), alarm.getAlarmId(), define.getKeyIndexs(), alarm.getParamList()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("append FaultDefine properties to Alarm failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public static void appendNorthDefine(Alarm alarmx, FaultDefine define) {
        try {
            if (FaultEnum.AlarmSeverity.ILLEGAL.getValue() == alarmx.getSeverity()) {
                alarmx.setSeverity(define.getFaultLevel());
            }
            if (FaultEnum.AlarmType.ILLEGAL.getValue() == alarmx.getAlarmType()) {
                alarmx.setAlarmType(define.getFaultType());
            }
            alarmx.setAlarmName(define.getFaultName());
            alarmx.setDesc(define.getFaultDesc());
            alarmx.setEffect(define.getSysEffect());
            alarmx.setAdvice(define.getAdvice());
            alarmx.setLocation(define.getLocation());
            alarmx.setProductName(define.getProductName());
            if (null == alarmx.getMoMainType()) {
                alarmx.setMoMainType(define.getMoMainType());
            }
            if (null == alarmx.getMoSubType()) {
                alarmx.setMoSubType(define.getMoSubType());
            }
            alarmx.setParams(FaultSdkUtil.convertParam((String[])alarmx.getParamList()));
        }
        catch (Exception e) {
            logger.error((Object)("append FaultDefine properties to Alarm failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public static void appendDefineProps(String productName, String trapoid, Event event) {
        FaultDefine define = FaultDefineUtil.getLegoDefine(event, productName, trapoid);
        if (null == define) {
            throw new LegoCheckedException("get FaultDefine failed, moId: " + event.getMoId() + ", productName: " + productName + ", trapoid: " + trapoid + ", eventId: " + event.getEventId());
        }
        FaultDefineUtil.appendDefineProps(event, define);
    }

    public static void appendDefineProps(Event event, FaultDefine define) {
        if (define == null) {
            return;
        }
        try {
            if (FaultEnum.AlarmType.ILLEGAL.getValue() == event.getEventType()) {
                event.setEventType(define.getFaultType());
            }
            event.setEventName(define.getFaultName());
            event.setDesc(define.getFaultDesc());
            event.setEffect(define.getSysEffect());
            event.setAdvice(define.getAdvice());
            event.setLocation(define.getLocation());
            event.setProductName(define.getProductName());
            if (null == event.getMoMainType()) {
                event.setMoMainType(define.getMoMainType());
            }
            if (null == event.getMoSubType()) {
                event.setMoSubType(define.getMoSubType());
            }
            event.setParams(FaultSdkUtil.convertParam((String[])event.getParamList()));
            event.setEntity(FaultUtil.getEntity(event.getMoId(), event.getEventId(), define.getKeyIndexs(), event.getParamList()));
        }
        catch (Exception e) {
            logger.error((Object)("convertWebNmsEvent in SnmpTrapFilter failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public static void appendDefineProps(Event event) {
        FaultDefine define = event.getFaultDefine();
        if (null == define) {
            define = FaultDefineCacher.getFaultDefine("", "", event.getEventId(), event.getMoMainType(), event.getMoSubType());
        }
        FaultDefineUtil.appendDefineProps(event, define);
    }

    public static FaultDefine getLegoDefine(Alarm alarm, String productName, String trapoid) {
        try {
            FaultDefine faultDefine = alarm.getFaultDefine();
            if (null == faultDefine) {
                faultDefine = FaultDefineCacher.getFaultDefine(productName, trapoid, alarm.getAlarmId(), alarm.getMoMainType(), alarm.getMoSubType());
            }
            if (legoAlarmIds.contains(alarm.getAlarmId())) {
                long startTime = System.currentTimeMillis();
                while (null == faultDefine) {
                    faultDefine = FaultDefineCacher.getFaultDefine(productName, trapoid, alarm.getAlarmId(), alarm.getMoMainType(), alarm.getMoSubType());
                    CommonUtil.sleep((long)100L);
                    if (System.currentTimeMillis() - startTime <= 100000L) continue;
                }
            }
            return faultDefine;
        }
        catch (Exception e) {
            throw ExceptionUtil.convertException((Throwable)e, (String)("get Poll FaultDefine failed, productName: " + productName + ", trapoid: " + trapoid + ", alarmId: " + alarm.getAlarmId()), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public static FaultDefine getLegoDefine(Event event, String productName, String trapoid) {
        try {
            FaultDefine faultDefine = event.getFaultDefine();
            if (null == faultDefine) {
                faultDefine = FaultDefineCacher.getFaultDefine(productName, trapoid, event.getEventId(), event.getMoMainType(), event.getMoSubType());
            }
            if (legoAlarmIds.contains(event.getEventId())) {
                long startTime = System.currentTimeMillis();
                while (null == faultDefine) {
                    faultDefine = FaultDefineCacher.getFaultDefine(productName, trapoid, event.getEventId(), event.getMoMainType(), event.getMoSubType());
                    CommonUtil.sleep((long)100L);
                    if (System.currentTimeMillis() - startTime <= 100000L) continue;
                }
            }
            return faultDefine;
        }
        catch (Exception e) {
            throw ExceptionUtil.convertException((Throwable)e, (String)("get Poll FaultDefine failed, productName: " + productName + ", trapoid: " + trapoid + ", alarmId: " + event.getEventId()), (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    static {
        legoAlarmIds.add("0x000803220001");
        legoAlarmIds.add("0x000803220002");
        legoAlarmIds.add("0x000803220003");
        legoAlarmIds.add("0x000803220004");
        legoAlarmIds.add("0x000803220005");
    }
}

