/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.sdk.service.IFaultBackupService;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class AlarmTransferLauncher
extends CommonThread
implements IFaultLauncher {
    private static final long VALUE_300000L = 300000L;
    private static final long VALUE_86400000L = 86400000L;
    private static final Log LOGGER = LogFactory.getInstance(AlarmTransferLauncher.class);
    private static boolean isStop = false;
    private static AlarmSynchronizer synchronizer = null;

    private static void setAlarmSynchronizer(AlarmSynchronizer alarmSynchronizer) {
        synchronizer = alarmSynchronizer;
    }

    private static void setAlarmTransferStopFlag(boolean stopFlag) {
        isStop = stopFlag;
    }

    private static boolean isAlarmTransferStopped() {
        return isStop;
    }

    @Override
    public void start() {
        LOGGER.info((Object)"[AlarmTransferLauncher] begin to start AlarmTransferLauncher.", 1L);
        AlarmTransferLauncher.setAlarmTransferStopFlag(false);
        this.setThreadName("TransferThread");
        ExecutionService.submitTask(this);
    }

    @Override
    public void stop() {
        AlarmTransferLauncher.setAlarmTransferStopFlag(true);
    }

    public static AlarmSynchronizer getSynchronizer() {
        return synchronizer;
    }

    public void setSynchronizer(AlarmSynchronizer synchronizer) {
        AlarmTransferLauncher.setAlarmSynchronizer(synchronizer);
    }

    @Override
    public void execute() {
        LOGGER.info((Object)"[AlarmTransferLauncher] Thread sleep 5 minutes", 1L);
        CommonUtil.sleep((long)300000L);
        while (!AlarmTransferLauncher.isAlarmTransferStopped()) {
            LOGGER.info((Object)"[AlarmTransferLauncher] Thread start to transfer", 1L);
            this.transferAlarm();
            CommonUtil.sleep((long)86400000L);
        }
    }

    public void transferAlarm() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String fileType = "csv";
        Date endTime = new Date();
        String lang = this.getLocale();
        String filePath = "datastorage/alarm";
        try {
            this.getService().transferAlarm(fileType, sdf.parse(sdf.format(endTime)).getTime(), lang, filePath, false);
        }
        catch (ParseException e) {
            LOGGER.debug((Object)e.getMessage(), 1L);
        }
    }

    private String getLocale() {
        Locale locale = Locale.getDefault();
        if (null == locale) {
            return "zh";
        }
        String context = locale.getLanguage();
        if (null == context || "".equals(context)) {
            return "zh";
        }
        return context;
    }

    private IFaultBackupService getService() {
        ServiceContext context = ServiceContext.getInstance();
        IFaultBackupService faultBackupService = (IFaultBackupService)context.lookup("fault/faultBackupService");
        return faultBackupService;
    }
}

