/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.define.FaultDefineUtil;
import com.huawei.lego.nem.fault.launcher.FaultLauncher;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.RestoreInfo;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.util.LinkedList;
import java.util.List;

public final class FaultMsgCenter {
    private static final Log LOGGER = LogFactory.getInstance(FaultMsgCenter.class);

    private FaultMsgCenter() {
    }

    public static boolean sendMessage(FaultMsgType msgType, LegoAlarm legoAlarm) {
        Alarm alarm = FaultUtil.legoAlarmToAlarm(legoAlarm);
        if (null == alarm) {
            return false;
        }
        if (FaultMsgType.MANUCLEAR_ALARM == msgType || FaultMsgType.CONFIRM_ALARM == msgType || FaultMsgType.UNCONFIRM_ALARM == msgType) {
            return true;
        }
        if (FaultMsgType.ALARM == msgType) {
            if (legoAlarm.getMoId() != 0L) {
                FaultDefineUtil.appendDefineProps("", "", alarm);
            } else {
                FaultDefineUtil.appendNorthDefine(alarm, alarm.getFaultDefine());
            }
            return FaultLauncher.getInstance().getFaultApi().processAlarm(alarm, FaultMsgType.ALARM);
        }
        LOGGER.error((Object)("recv an invalid MessageType in FaultMsgCenter: " + (Object)((Object)msgType)), 1L);
        return false;
    }

    public static boolean sendRestoreMessage(FaultMsgType msgType, LegoAlarm legoAlarm) {
        try {
            Alarm alarm = FaultUtil.legoAlarmToAlarm(legoAlarm);
            if (null == alarm) {
                return false;
            }
            RestoreInfo restoreInfo = FaultUtil.getRestoreInfo(alarm, "", "");
            Alarm restoredAlarm = FaultLauncher.getInstance().getFaultApi().processRestoreAlarm(restoreInfo, String.valueOf((Object)msgType), alarm);
            return null != restoredAlarm;
        }
        catch (Exception e) {
            LOGGER.error((Object)("sendRestoreMessage failed, msgType: " + (Object)((Object)msgType) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    public static void sendSyncAlarmMsg(String productName, String trapoid, List<Alarm> alarmList) {
        LinkedList<Alarm> restoreAlarms = new LinkedList<Alarm>();
        for (Alarm alarm : alarmList) {
            try {
                if (alarm.getClearStatus() == FaultEnum.ClearState.UNCLEARED.getValue()) continue;
                if (alarm.getClearStatus() == FaultEnum.ClearState.CLEARED.getValue()) {
                    restoreAlarms.add(alarm);
                    continue;
                }
                FaultDefineUtil.appendDefineProps(productName, trapoid, alarm);
                FaultLauncher.getInstance().getFaultApi().processAlarm(alarm, FaultMsgType.ALARM);
            }
            catch (Exception e) {
                LOGGER.error((Object)(new StringBuilder().append("sendSyncAlarmMsg failed, productName: ").append(productName).append(", trapoid: ").append(trapoid) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
        for (Alarm alarm : restoreAlarms) {
            try {
                RestoreInfo restoreInfo = FaultUtil.getRestoreInfo(alarm, productName, trapoid);
                FaultLauncher.getInstance().getFaultApi().processRestoreAlarm(restoreInfo, String.valueOf((Object)FaultMsgType.RESTORE_ALARM), alarm);
            }
            catch (Exception e) {
                LOGGER.error((Object)(new StringBuilder().append("sendSyncAlarmMsg failed, productName: ").append(productName).append(", trapoid: ").append(trapoid) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    public static void sendSyncEventMsg(String productName, String trapoid, List<Event> eventList) {
        for (Event event : eventList) {
            try {
                FaultDefineUtil.appendDefineProps(productName, trapoid, event);
                FaultLauncher.getInstance().getFaultApi().processEvent(event);
            }
            catch (Exception e) {
                LOGGER.error((Object)(new StringBuilder().append("sendSyncAlarmMsg failed, productName: ").append(productName).append(", trapoid: ").append(trapoid) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }
}

