/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sync;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.cbb.task.sdk.service.TaskCategory;
import com.huawei.lego.cbb.task.sdk.service.TaskExecuteType;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TimeSyncTaskJob {
    private static final String TASK_NAME = "Alarm Synchronze Task";
    private static final String TASK_TYPE = "alarmSyncTask";
    private static final Log LOGGER = LogFactory.getInstance(TimeSyncTaskJob.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    public Map<String, Object> queryTimingSet() {
        HashMap<String, Object> timingSet = new HashMap<String, Object>();
        try {
            Task task = this.queryTask();
            if (null == task) {
                timingSet.put("isEnabled", false);
                timingSet.put("excuteTime", "");
                timingSet.put("period", 0);
            } else {
                timingSet.put("isEnabled", TaskStatus.SUSPEND.getValue() != task.getTaskStatus().intValue());
                timingSet.put("excuteTime", DateFormatUtil.format((DateFormat)this.dateFormat, (Date)task.getBaseTime()));
                timingSet.put("period", task.getPeriod());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            timingSet.put("isEnabled", false);
            timingSet.put("period", 0);
            timingSet.put("excuteTime", "");
        }
        return timingSet;
    }

    public void modifyTimingSet(boolean isEnabled, String excuteTime, int periodType, int period) {
        try {
            ITaskService service = (ITaskService)ServiceContext.getInstance().lookup("task/task");
            Task task = this.queryTask();
            if (null == task) {
                task = this.produceTask(excuteTime, service, periodType, period);
            }
            long taskId = task.getTaskId();
            if (TaskStatus.SUSPEND.getValue() == task.getTaskStatus().intValue()) {
                service.resumeTask(taskId);
                task = service.readTask(taskId);
            }
            if (isEnabled) {
                Date baseTime = this.getBaseTime(excuteTime);
                task.setBaseTime(baseTime);
                task.setNextTime(null);
                task.setPeriod(Integer.valueOf(period));
                task.setPeriodType(Integer.valueOf(periodType));
            }
            task.setLastModifyTime(new Date());
            service.updateTask(task);
            if (!isEnabled) {
                service.suspendTask(taskId);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("modifyTimingSet failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public void executeTimingSync(ManagedObject legoMo) {
        LOGGER.info((Object)"start execute timing alarm synchronize.", 1L);
        IDeviceTypeMgr deviceTypeMgr = (IDeviceTypeMgr)ServiceContext.getInstance().lookup("ResourceApplication/deviceTypeMgr");
        if (null == deviceTypeMgr) {
            LOGGER.error((Object)"fetch IDeviceTypeMgr service failed, executeTimingSync will not execute.", 1L);
            return;
        }
        List tmpList = deviceTypeMgr.getAllDevice();
        for (TopoObject topoObj : tmpList) {
            String ipAddress;
            if (topoObj.getUuid().equals(legoMo.getUuid()) || null == (ipAddress = topoObj.getIpAddress())) continue;
            try {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Start execute timing alarm synchronize from topoObject, ip: %s, moId: %s, name: %s.", ipAddress, topoObj.getMoId(), topoObj.getName()), 1L);
                AlarmSyncLauncher.getSynchronizer().createSyncTask(topoObj.getMoId(), topoObj.getName(), ipAddress, FaultEnum.AlarmSyncType.TIMING_SYNC);
                SysOptLog oOptLog = new SysOptLog();
                Date date = new Date();
                oOptLog.setDate(date);
                oOptLog.setTarget(topoObj.getName());
                oOptLog.setLevel(SysoplogLevel.INFO.getValue());
                oOptLog.setModule("lego.dic.module.fault");
                oOptLog.setOperation("lego.lab.fault.log.alarmsync");
                oOptLog.setResult(1);
                oOptLog.setOperator("system");
                oOptLog.setTerminalIp("127.0.0.1");
            }
            catch (Exception e) {
                LOGGER.error((Object)("execute timing alarm synctask failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private Task queryTask() {
        try {
            List taskList;
            ITaskService service = (ITaskService)ServiceContext.getInstance().lookup("task/task");
            TaskType taskType = service.readTaskType(TASK_TYPE);
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("taskName", TASK_NAME);
            if (null != taskType) {
                condition.put("taskType", taskType.getTaskType());
            }
            if (null != (taskList = service.queryTasks(condition)) && !taskList.isEmpty()) {
                return (Task)taskList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("query alarm synchronize task error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return null;
    }

    private Date getBaseTime(String excuteTime) {
        String[] strs = excuteTime.split(":");
        if (strs.length < 3) {
            LOGGER.error((Object)("invalid excuteTime format: " + excuteTime + " expected 3 sub-string after split by ':'."), 1L);
            throw new IllegalArgumentException("invalid parameters");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, NumberUtil.convertToInteger((Object)strs[0]));
        calendar.set(12, NumberUtil.convertToInteger((Object)strs[1]));
        calendar.set(13, NumberUtil.convertToInteger((Object)strs[2]));
        if (calendar.getTime().before(new Date())) {
            calendar.set(5, calendar.get(5) + 1);
        }
        return calendar.getTime();
    }

    private Task produceTask(String excuteTime, ITaskService service, int periodType, int period) {
        try {
            Task task = new Task();
            task.setTaskName(TASK_NAME);
            task.setBaseTime(this.getBaseTime(excuteTime));
            task.setCreateTime(new Date());
            task.setExecuteType(Integer.valueOf(TaskExecuteType.PERIOD.getValue()));
            task.setPeriod(Integer.valueOf(period));
            task.setPeriodtimes(Integer.valueOf(-1));
            task.setPeriodType(Integer.valueOf(periodType));
            task.setLastModifyTime(new Date());
            task.setTaskType(service.readTaskType(TASK_TYPE));
            task.setCreateUser(Long.valueOf(1L));
            task.setTaskCategory(Integer.valueOf(TaskCategory.SYSTEM.getValue()));
            task.setTaskStatus(Integer.valueOf(TaskStatus.IDLE.getValue()));
            task.setBundleName("lego");
            task.setIsNotifyFail(Boolean.valueOf(false));
            task.setIsNotifySuccess(Boolean.valueOf(false));
            task.setIsSendMail(Boolean.valueOf(false));
            task.setIsSendNote(Boolean.valueOf(false));
            long taskId = service.addTask(task);
            task.setTaskId(Long.valueOf(taskId));
            return task;
        }
        catch (Exception e) {
            LOGGER.error((Object)("produceTask failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return null;
        }
    }
}

