/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.security;

import com.huawei.ism.drm.wcc.rest.security.AbstractX509TrustManager;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
extends AbstractX509TrustManager {
    private static final ILogger LOGGER = new CryptLogger();

    public SSLTrustManager(String ipAddress, boolean isForceCheckCert) throws AppException {
        super(SSLTrustManager.getKeyStoreFile(), ipAddress, SSLTrustManager.buildTrustManager(), isForceCheckCert);
    }

    public SSLTrustManager(String keystoreFile, String ipAddress, TrustManager trustManager) {
        super(keystoreFile, ipAddress, SSLTrustManager.castX509TrustManager(trustManager).orElse(null));
    }

    private static Optional<X509TrustManager> castX509TrustManager(TrustManager trustManager) {
        if (trustManager instanceof X509TrustManager) {
            return Optional.of((X509TrustManager)trustManager);
        }
        LOGGER.error("Failed to castX509TrustManager.");
        return Optional.empty();
    }

    public static X509TrustManager buildTrustManager() {
        TrustManager trustManager = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream inputStream = new FileInputStream(SSLTrustManager.getKeyStoreFile());){
                keyStore.load(inputStream, SSLTrustManager.getKeyStorePwd());
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            trustManager = trustManagerFactory.getTrustManagers()[0];
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Load keystore to trustManager failed. e: %s", e.getMessage()));
        }
        return SSLTrustManager.castX509TrustManager(trustManager).orElse(null);
    }

    private static char[] getKeyStorePwd() throws AppException {
        String pwd = SysPropertiesUtils.getPropertyValue("keyStore");
        return KmcInstance.decrypt(pwd).toCharArray();
    }

    private static String getKeyStoreFile() throws AppException {
        Optional<String> runtimePath = SysPropertiesUtils.getRuntimePath();
        if (runtimePath.isPresent()) {
            return runtimePath.get() + "/LegoRuntime/certs/bcm.keystore";
        }
        throw new AppException("Get runtime path failed.");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String authSwitch = SysPropertiesUtils.getPropertyValue("cert.auth.switch", Boolean.FALSE.toString());
        if (!this.isForceCheckCert() && !Boolean.parseBoolean(authSwitch)) {
            LOGGER.warn("Cert auth switch is disable, end execute SSLTrustManager checkServerTrusted.");
            return;
        }
        if (this.trustManager == null) {
            LOGGER.error(String.format("The trust manager is not initialized, ipAddress=%s.", this.ipAddress));
            throw new CertificateException("TrustManager not find.");
        }
        try {
            this.checkRevoked(chain);
            this.checkExpired(chain);
            this.checkExpiring(chain);
            this.checkTrusted(chain, authType);
        }
        catch (SSLHandshakeException e) {
            LOGGER.error("SSLTrustManager checkServerTrusted failed.");
            throw new CertificateException(e.getMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    protected void reloadTrustManager() {
        X509TrustManager manager = SSLTrustManager.buildTrustManager();
        this.trustManager = SSLTrustManager.castX509TrustManager(manager).orElse(null);
    }
}

