/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;

public class WccHelper {
    private static final String DOMAIN = "WCC_CRYPT_DEFAULT_DOMAIN";
    private static WccHelper instance = null;

    private WccHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WccHelper getInstance() throws IOException {
        String string = DOMAIN;
        synchronized (DOMAIN) {
            if (instance == null) {
                instance = new WccHelper();
                try {
                    instance.setWccConfig();
                }
                catch (Exception e) {
                    instance = null;
                    throw new IOException("setWccConfig exception", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void exportWccConfig(String file, String encryptPwd) {
        try {
            KmcInstance.getSoftInstance().exportMkFile(file, encryptPwd.getBytes(StandardCharsets.UTF_8));
            String hwFile = file.replace("wcc.conf", "wcc-hw.conf");
            KmcInstance.getHwInstance().exportMkFile(hwFile, encryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkFileComplete(String file, String oldHashCode) throws IOException {
        boolean isOk = false;
        File checkFile = new File(file);
        FileInputStream input = null;
        try {
            input = new FileInputStream(checkFile.getCanonicalPath());
            byte[] bytes = new byte[input.available()];
            input.read(bytes);
            String str = new String(bytes, Charset.defaultCharset());
            isOk = KmcInstance.hmacVerify(str, oldHashCode);
            this.closeStream(input);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeStream(input);
                throw throwable;
            }
        }
        return isOk;
    }

    private void setWccConfig() throws IOException {
        String currPath = new File("").getCanonicalPath();
        if (currPath == null || currPath.isEmpty()) {
            return;
        }
        String legoRuntime = "LegoRuntime" + File.separator + "conf" + File.separator + "wcc";
        String wccConfPath = currPath + File.separator + "conf" + File.separator + "wcc";
        wccConfPath = this.getWccConfPath(currPath, legoRuntime, wccConfPath);
        try {
            KmcInstance.initComponent(wccConfPath, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getWccConfPath(String currPath, String legoRuntime, String wccConfPath) {
        Path path;
        if (currPath.contains("Tomcat6") && currPath.endsWith("bin")) {
            wccConfPath = currPath.substring(0, currPath.length() - "Tomcat6/bin".length()) + legoRuntime;
        }
        if (currPath.endsWith("Tomcat6")) {
            wccConfPath = currPath.substring(0, currPath.length() - "Tomcat6".length()) + legoRuntime;
        }
        if ((path = Paths.get(currPath, new String[0])).endsWith("Runtime/bin")) {
            wccConfPath = currPath.substring(0, currPath.length() - "bin".length()) + legoRuntime;
        }
        return wccConfPath;
    }

    private void closeStream(FileInputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String decrypt(String txt) {
        if (txt == null || txt.isEmpty()) {
            return txt;
        }
        String decryptCtxt = null;
        try {
            decryptCtxt = KmcInstance.decrypt(txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptCtxt;
    }

    public String encrypt(String txt) {
        if (txt == null || txt.isEmpty()) {
            return txt;
        }
        String encryptCtxt = null;
        try {
            encryptCtxt = KmcInstance.encrypt(txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptCtxt;
    }
}

