/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.alarm;

import com.huawei.ism.drm.wcc.util.alarm.CertAuthFail;
import com.huawei.ism.drm.wcc.util.alarm.CertAuthSuccess;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.ILogger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class CertAlarmQueue {
    private static final ILogger LOGGER = new CryptLogger();
    private static final int LIST_SIZE = 10240;
    private static Set<CertAuthFail> failedCertMap = Collections.newSetFromMap(new ConcurrentHashMap());
    private static Map<String, Set<String>> revokedCertMap = new ConcurrentHashMap<String, Set<String>>();
    private static Set<String> unRevokedCertMap = Collections.newSetFromMap(new ConcurrentHashMap());
    private static BlockingQueue<CertAuthSuccess> succeededCertQueue = new ArrayBlockingQueue<CertAuthSuccess>(10240);
    private static Set<CertAuthSuccess> succeededCertSet = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Set<CertAuthFail> getFailedCertMap() {
        return failedCertMap;
    }

    public static Map<String, Set<String>> getRevokedCertMap() {
        return revokedCertMap;
    }

    public static Set<String> getUnRevokedCertMap() {
        return unRevokedCertMap;
    }

    public static CertAuthSuccess getSucceededCert() throws InterruptedException {
        CertAuthSuccess certAuthSuccess = succeededCertQueue.take();
        succeededCertSet.remove(certAuthSuccess);
        return certAuthSuccess;
    }

    public static void addFailForCertExpired(String ipAddress) {
        CertAuthFail certAuthFail = new CertAuthFail();
        certAuthFail.setIpAddress(ipAddress);
        certAuthFail.setCertAuthFailType(1);
        certAuthFail.setAlarmCreateTime(System.currentTimeMillis());
        CertAlarmQueue.addFailedCertToMap(certAuthFail);
    }

    public static void addFailForCertExpiring(String ipAddress, int expiringDays) {
        CertAuthFail certAuthFail = new CertAuthFail();
        certAuthFail.setIpAddress(ipAddress);
        certAuthFail.setCertAuthFailType(3);
        certAuthFail.setExpiringDays(expiringDays);
        certAuthFail.setAlarmCreateTime(System.currentTimeMillis());
        CertAlarmQueue.addFailedCertToMap(certAuthFail);
    }

    public static void addFailForCertNoTrust(String ipAddress) {
        CertAuthFail certAuthFail = new CertAuthFail();
        certAuthFail.setIpAddress(ipAddress);
        certAuthFail.setCertAuthFailType(2);
        certAuthFail.setAlarmCreateTime(System.currentTimeMillis());
        CertAlarmQueue.addFailedCertToMap(certAuthFail);
    }

    public static void addSuccessCert(String ipAddress) {
        CertAuthSuccess certAuthSuccess = new CertAuthSuccess(ipAddress, 1);
        CertAlarmQueue.addSuccessCert(certAuthSuccess);
    }

    public static void addSuccessCertForNotExpiring(String ipAddress) {
        CertAuthSuccess certAuthSuccess = new CertAuthSuccess(ipAddress, 2);
        CertAlarmQueue.addSuccessCert(certAuthSuccess);
    }

    public static void addRevokedCerts(Map<String, Set<String>> revokedCertsMap) {
        revokedCertMap.putAll(revokedCertsMap);
    }

    public static void addUnRevokedCerts(Set<String> unRevokedCerts) {
        unRevokedCertMap.addAll(unRevokedCerts);
    }

    public static void removeFailedCert(CertAuthSuccess certAuthSuccess) {
        String ipAddress = certAuthSuccess.getIpAddress();
        if (certAuthSuccess.getCertAuthSuccessType() == 1) {
            failedCertMap.removeIf(certAuthFail -> ipAddress.equalsIgnoreCase(certAuthFail.getIpAddress()) && certAuthFail.getCertAuthFailType() != 3);
        } else {
            failedCertMap.removeIf(certAuthFail -> ipAddress.equalsIgnoreCase(certAuthFail.getIpAddress()) && (certAuthFail.getCertAuthFailType() == 3 || certAuthFail.getCertAuthFailType() == 1));
        }
    }

    public static void removeUnRevokedCert(String ipAddress) {
        unRevokedCertMap.remove(ipAddress);
    }

    private static void addFailedCertToMap(CertAuthFail certAuthFail) {
        if (failedCertMap.size() >= 10240) {
            LOGGER.error("FailedCertMap exceed max.");
            return;
        }
        failedCertMap.add(certAuthFail);
    }

    private static void addSuccessCert(CertAuthSuccess certAuthSuccess) {
        if (!succeededCertSet.contains(certAuthSuccess)) {
            succeededCertQueue.add(certAuthSuccess);
            succeededCertSet.add(certAuthSuccess);
        }
    }
}

