/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.kms;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kms.IamAccessMgr;
import com.huawei.ism.drm.wcc.util.kms.KmsAccessMgr;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.JNIRefObj;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class HardwareCallback
extends IHardwareCallback {
    private static final ILogger LOGGER = new CryptLogger();
    private static final int KMS_BASE_CIPHER_TEXT_LEN = 124;
    private static final int KMS_CIPHER_BLOCK_LEN = 16;
    private static final float KMS_BASE64_RATIO_ONE = 3.0f;
    private static final float KMS_BASE64_RATION_TWO = 4.0f;
    private static String iamProjectId = "";

    public int hwInitKeyMgr() {
        Optional<String> token = IamAccessMgr.getToken();
        if (token.isPresent()) {
            this.authData = token.get().getBytes(StandardCharsets.UTF_8);
            LOGGER.info("Token init success.");
            return 0;
        }
        LOGGER.error("Token init failed.");
        return -1;
    }

    public JNIRefObj hwNewRootKey() throws Exception {
        LOGGER.info("Start create root key.");
        this.checkNeedReloadToken();
        String token = new String(this.authData, StandardCharsets.UTF_8);
        String projectId = this.getProjectId(token);
        int index = this.getMinIndex(this.rkHandle);
        String keyId = KmsAccessMgr.createRootKey(token, projectId);
        LOGGER.info("New root key success.");
        this.rkHandle.put(index, keyId.getBytes(StandardCharsets.UTF_8));
        JNIRefObj jniRefObj = new JNIRefObj();
        jniRefObj.intVal = index;
        jniRefObj.byteArr = keyId.getBytes(StandardCharsets.UTF_8);
        return jniRefObj;
    }

    public byte[] hwEncData(int index, byte[] extData, byte[] plainText) throws Exception {
        if (!this.rkHandle.containsKey(index)) {
            throw new AppException("Index fot key id not exist.");
        }
        this.checkNeedReloadToken();
        String token = new String(this.authData, StandardCharsets.UTF_8);
        String projectId = this.getProjectId(token);
        String keyId = new String((byte[])this.rkHandle.get(index), StandardCharsets.UTF_8);
        String cipherText = KmsAccessMgr.encrypt(token, projectId, keyId, Base64.getEncoder().encodeToString(plainText));
        return cipherText.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] hwDecData(int index, byte[] extData, byte[] cipherText) throws Exception {
        this.checkNeedReloadToken();
        String token = new String(this.authData, StandardCharsets.UTF_8);
        String projectId = this.getProjectId(token);
        String plainText = KmsAccessMgr.decrypt(token, projectId, new String(cipherText, StandardCharsets.UTF_8));
        return Base64.getDecoder().decode(plainText);
    }

    public int hwRemoveKey(int index) throws Exception {
        LOGGER.info("Start to remove root key.");
        if (!this.rkHandle.containsKey(index)) {
            LOGGER.error(String.format(Locale.ENGLISH, "No key id found for index:%d", index));
            return 0;
        }
        this.checkNeedReloadToken();
        String token = new String(this.authData, StandardCharsets.UTF_8);
        String projectId = this.getProjectId(token);
        String keyId = new String((byte[])this.rkHandle.get(index), StandardCharsets.UTF_8);
        KmsAccessMgr.deleteRootKey(token, keyId, projectId);
        this.rkHandle.remove(index);
        LOGGER.info("Remove root key success.");
        return 0;
    }

    public int hwLoadRootKey(byte[] persistenceData) throws Exception {
        int index = 0;
        for (Map.Entry entry : this.rkHandle.entrySet()) {
            Integer key = (Integer)entry.getKey();
            byte[] value = (byte[])entry.getValue();
            if (!Arrays.equals(persistenceData, value)) continue;
            index = key;
            break;
        }
        if (index != 0) {
            return index;
        }
        this.checkNeedReloadToken();
        String token = new String(this.authData, StandardCharsets.UTF_8);
        String projectId = this.getProjectId(token);
        KmsAccessMgr.checkKeyExist(token, projectId, new String(persistenceData, StandardCharsets.UTF_8));
        index = this.getMinIndex(this.rkHandle);
        this.rkHandle.put(index, persistenceData);
        return index;
    }

    public int hwUnLoadRootKey(int index) {
        this.rkHandle.remove(index);
        return 0;
    }

    public int hwUinitKeyMgr() {
        this.authData = null;
        return 0;
    }

    public byte[] hwGetEncExtraData() {
        return new byte[0];
    }

    public byte[] hwGetDecExtraData() {
        return new byte[0];
    }

    public int hwGetPersistentDataLen() {
        return 36;
    }

    public int hwGetCipherLen(int plainLen) {
        if (plainLen < 0) {
            LOGGER.error("Kmc get cipher length should not be less than zero.");
            return -1;
        }
        int realLen = (int)(124.0 + 16.0 * (Math.ceil((float)plainLen / 3.0f) / 4.0 + 1.0));
        return (int)Math.ceil((float)realLen / 3.0f * 4.0f);
    }

    private String getProjectId(String token) throws Exception {
        if ("".equals(iamProjectId)) {
            iamProjectId = IamAccessMgr.getProject(token);
        }
        return iamProjectId;
    }

    private void checkNeedReloadToken() {
        if (this.authData == null) {
            LOGGER.info("Token Reload.");
            this.hwInitKeyMgr();
        }
    }

    private int getMinIndex(Map<Integer, byte[]> rkHandle) {
        int index = 0;
        while (index++ < 20 && rkHandle.containsKey(index)) {
        }
        return index;
    }
}

