/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.kms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestAdapter;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kms.model.request.KmsDecryptRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.KmsDeleteRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.KmsDescribeRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.KmsEncryptRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.KmsRootKeyRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.ListKeyRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.SyncKeyRequest;
import com.huawei.ism.drm.wcc.util.kms.model.response.KeyListResponse;
import com.huawei.ism.drm.wcc.util.kms.model.response.KmsDecryptResponse;
import com.huawei.ism.drm.wcc.util.kms.model.response.KmsEncryptResponse;
import com.huawei.ism.drm.wcc.util.kms.model.response.KmsRootKeyResponse;
import com.huawei.ism.drm.wcc.util.kms.model.response.SyncRegionInfo;
import com.huawei.ism.drm.wcc.util.kms.model.response.SyncRegionInfoList;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class KmsAccessMgr {
    private static final ILogger LOGGER = new CryptLogger();
    public static final String KMS_DOMAIN = "kms-scc-apig." + SysPropertiesUtils.getRegionProperty("config.hcs.node.region") + "." + SysPropertiesUtils.getPropertyValue("config.hcs.domain");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String createRootKey(String token, String projectId) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        String url = "/v1.0/{project_id}/kms/create-key".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        KmsRootKeyRequest kms = KmsRootKeyRequest.builder().keyAlias("key_eReplication_" + UUID.randomUUID()).keySpec("SM4").build();
        ResponseResult response = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)kms));
        if (response.isSuccess()) {
            String res = RestAdapter.getResponseContent(response.getResponse().getEntity());
            KmsRootKeyResponse rootKey = (KmsRootKeyResponse)OBJECT_MAPPER.readValue(res, KmsRootKeyResponse.class);
            return rootKey.getKeyInfo().getKeyId();
        }
        LOGGER.error("Create root key from kms failed.");
        throw new AppException("Create root key from kms failed.");
    }

    public static void deleteRootKey(String token, String keyId, String projectId) throws AppException, JsonProcessingException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        KmsAccessMgr.paramNotNullCheck(keyId, "key id");
        String url = "/v1.0/{project_id}/kms/schedule-key-deletion".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        KmsDeleteRequest deleteRequest = KmsDeleteRequest.builder().keyId(keyId).pendingDays("7").build();
        ResponseResult response = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)deleteRequest));
        if (!response.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "Delete key to kms failed. keyId: %s", keyId));
            throw new AppException("Delete key to kms failed.");
        }
    }

    public static void checkKeyExist(String token, String projectId, String keyId) throws AppException, JsonProcessingException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        KmsAccessMgr.paramNotNullCheck(keyId, "key id");
        String url = "/v1.0/{project_id}/kms/describe-key".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        KmsDescribeRequest request = KmsDescribeRequest.builder().keyId(keyId).build();
        ResponseResult response = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)request));
        if (!response.isSuccess()) {
            LOGGER.error(String.format(Locale.ENGLISH, "Key id %s not exist in kms.", keyId));
            throw new AppException("Key id not exist in kms.");
        }
    }

    public static String encrypt(String token, String projectId, String keyId, String plainText) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        KmsAccessMgr.paramNotNullCheck(keyId, "key id");
        String url = "/v1.0/{project_id}/kms/encrypt-data".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        KmsEncryptRequest request = KmsEncryptRequest.builder().keyId(keyId).plaintText(plainText).build();
        ResponseResult responsePair = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)request));
        if (responsePair.isSuccess()) {
            String resContent = RestAdapter.getResponseContent(responsePair.getResponse().getEntity());
            KmsEncryptResponse response = (KmsEncryptResponse)OBJECT_MAPPER.readValue(resContent, KmsEncryptResponse.class);
            return response.getCipherText();
        }
        LOGGER.error("Encrypt text from kms failed.");
        throw new AppException("Encrypt text from kms failed.");
    }

    public static String decrypt(String token, String projectId, String cipherText) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        String url = "/v1.0/{project_id}/kms/decrypt-data".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        KmsDecryptRequest request = KmsDecryptRequest.builder().cipherText(cipherText).build();
        ResponseResult responsePair = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)request));
        if (responsePair.isSuccess()) {
            String resContent = RestAdapter.getResponseContent(responsePair.getResponse().getEntity());
            KmsDecryptResponse response = (KmsDecryptResponse)OBJECT_MAPPER.readValue(resContent, KmsDecryptResponse.class);
            return response.getPlainText();
        }
        LOGGER.error("Decrypt text from kms failed.");
        throw new AppException("Decrypt text from kms failed.");
    }

    private static void paramNotNullCheck(String token, String type) throws AppException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            LOGGER.error(String.format(Locale.ENGLISH, "Param %s empty.", type));
            throw new AppException("Param empty.");
        }
    }

    public static List<String> getRootKeys(String token, String projectId) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        String url = "/v1.0/{project_id}/kms/list-keys".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        ListKeyRequest listKeyRequest = ListKeyRequest.builder().keySpec("ALL").keyState("2").build();
        ResponseResult responsePair = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)listKeyRequest));
        if (responsePair.isSuccess()) {
            String resContent = RestAdapter.getResponseContent(responsePair.getResponse().getEntity());
            KeyListResponse response = (KeyListResponse)OBJECT_MAPPER.readValue(resContent, KeyListResponse.class);
            return response.getKeys();
        }
        LOGGER.error("Get key list from kms failed.");
        throw new AppException("Get key list from kms failed.");
    }

    public static void syncRootKey(String token, String projectId, String keyId, String regionId) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        KmsAccessMgr.paramNotNullCheck(keyId, "key id");
        String url = "/v1.0/{project_id}/kms/enable-key-synch".replace("{project_id}", projectId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        SyncKeyRequest syncKeyRequest = SyncKeyRequest.builder().syncRegions(Collections.singletonList(regionId)).keyId(keyId).build();
        ResponseResult responsePair = client.doPost(url, Collections.singletonMap("X-Auth-Token", token), OBJECT_MAPPER.writeValueAsString((Object)syncKeyRequest));
        if (responsePair.isSuccess()) {
            LOGGER.info(String.format(Locale.ENGLISH, "Sync key:%s to region:%s success.", keyId, regionId));
            return;
        }
        LOGGER.error(String.format(Locale.ENGLISH, "Sync key:%s to region:%s failed.", keyId, regionId));
        throw new AppException("Sync key from kms failed.");
    }

    public static List<String> getSyncRegions(String token, String projectId, String keyId) throws AppException, IOException {
        KmsAccessMgr.paramNotNullCheck(token, "token");
        KmsAccessMgr.paramNotNullCheck(projectId, "project id");
        KmsAccessMgr.paramNotNullCheck(keyId, "key id");
        String url = "/v1.0/{project_id}/kms/{key_id}/regions-synch".replace("{project_id}", projectId).replace("{key_id}", keyId);
        RestClient client = new RestClient(KMS_DOMAIN, "443");
        Map<String, String> header = Collections.singletonMap("X-Auth-Token", token);
        ResponseResult responsePair = client.doGet(url, header);
        if (responsePair.isSuccess()) {
            String resContent = RestAdapter.getResponseContent(responsePair.getResponse().getEntity());
            SyncRegionInfoList regionList = (SyncRegionInfoList)OBJECT_MAPPER.readValue(resContent, SyncRegionInfoList.class);
            return regionList.getSyncRegions().stream().filter(SyncRegionInfo::isChosen).map(SyncRegionInfo::getId).collect(Collectors.toList());
        }
        LOGGER.error(String.format(Locale.ENGLISH, "Get key:%s sync regions failed.", keyId));
        return Collections.emptyList();
    }
}

