/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.ILogger;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final ILogger LOG = new CryptLogger();
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
    private final String namePrefix;

    public DaemonThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.namePrefix + "-thread-" + THREAD_NUMBER.getAndIncrement());
        thread.setUncaughtExceptionHandler((thr, ex) -> LOG.error(String.format(Locale.ROOT, "Thread %s occur uncaughtException, msg:%s", thr.getName(), CryptLogger.getErrorMessage(ex))));
        thread.setDaemon(Boolean.TRUE);
        return thread;
    }
}

