/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.utils.SecureDirDetector;
import com.huawei.kmc.common.ILogger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    static ILogger LOGGER = new CryptLogger();

    public static boolean write(File targetFile, ByteBuffer contentBuffer) {
        if (targetFile == null || !targetFile.exists()) {
            LOGGER.error("file to write content to targetFile");
            return false;
        }
        if (contentBuffer == null) {
            LOGGER.error("can not write empty content to targetFile.");
            return false;
        }
        long fileLength = targetFile.length();
        try (RandomAccessFile raw = new RandomAccessFile(targetFile, "rws");){
            FileDescriptor fd = raw.getFD();
            raw.seek(fileLength);
            raw.write(contentBuffer.array());
            fd.sync();
        }
        catch (Exception e) {
            LOGGER.error("force writing script failed.");
            return false;
        }
        return true;
    }

    public static boolean checkFile(File targetFile) {
        if (targetFile == null) {
            LOGGER.error("targetFile check result is null.");
            return false;
        }
        if (!targetFile.exists()) {
            return false;
        }
        return targetFile.isFile();
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            LOGGER.info(descFileName + " is already exist.");
            return true;
        }
        if (descFileName.endsWith(File.separator)) {
            LOGGER.info("DescFileName is dir, can not create dir.");
            return false;
        }
        if (!file.getParentFile().exists()) {
            if (!file.getParentFile().mkdirs()) {
                LOGGER.info("create file's path failed.");
            }
            try {
                SecureDirDetector.alterPermission(file.getParentFile().getCanonicalPath(), true);
            }
            catch (IOException e) {
                LOGGER.error("change dir permission failed");
            }
        }
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            LOGGER.error("createNewFile failed");
            return false;
        }
        return true;
    }

    public static List<String> readLines(File file) {
        String text = FileUtils.readText(file, 0);
        ArrayList<String> lines = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String[] strs;
            for (String str : strs = text.split(System.getProperty("line.separator"))) {
                if (str == null || str.isEmpty()) continue;
                lines.add(str);
            }
        }
        return lines;
    }

    public static String readText(File file, int limit) {
        int length;
        if (!file.exists()) {
            return "";
        }
        long total = file.length();
        int size = (int)total;
        if (limit > 0 && file.length() > (long)limit) {
            LOGGER.error("Read file failed. Cause: Exceeded file size limit.");
            return "";
        }
        byte[] fileContent = new byte[size];
        try (FileInputStream in = new FileInputStream(file);){
            length = in.read(fileContent);
        }
        catch (IOException e) {
            LOGGER.error("Read file failed. fileName:" + file.getName() + "errorMsg: " + e.getMessage());
            return "";
        }
        if (length <= 0) {
            return "";
        }
        try {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(fileContent));
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            LOGGER.error("Decode failed, cause not utf-8 charset");
            return "";
        }
    }
}

