/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.utils.DaemonThreadFactory;
import com.huawei.kmc.common.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.util.CollectionUtils;

public class FileWatchService {
    static ILogger LOG = new CryptLogger();
    private static final Map<String, Set<String>> REGISTER_FOLDER_TO_FILENAMES_MAP = new HashMap<String, Set<String>>();
    private static final Map<String, Set<Runnable>> FILENAME_TO_UPDATE_RUNNABLE_MAP = new HashMap<String, Set<Runnable>>();
    private static final int POOL_SIZE = 20;
    private static final int MAX_POOL_SIZE = 40;
    private static final int WORK_QUEUE_SIZE = 100;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final String FILE_WATCH_POOL_NAME = "File-watch-pool";
    private static final String FILE_UPDATE_POOL_NAME = "File-update-pool";
    private static final ExecutorService FILE_WATCH_EXECUTOR_SERVICE = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("File-watch-pool"), new ExecutorAbortPolicy("File-watch-pool"));
    private static final ExecutorService FILE_UPDATE_EXECUTOR_SERVICE = new ThreadPoolExecutor(20, 40, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new DaemonThreadFactory("File-update-pool"), new ExecutorAbortPolicy("File-update-pool"));

    public static synchronized void registerTask(String folderPath, String fileName, Runnable updateRunnable) throws IOException {
        FileWatchService.registerTask(folderPath, fileName, Collections.singletonList(StandardWatchEventKinds.ENTRY_MODIFY), updateRunnable);
    }

    public static synchronized void registerTask(String folderPath, String fileName, List<WatchEvent.Kind<Path>> watchEvents, Runnable updateRunnable) throws IOException {
        if (folderPath == null || !new File(folderPath).exists()) {
            LOG.warn(String.format(Locale.ROOT, "Failed to registerTask, cause folderPath:%s not exists.", folderPath));
            return;
        }
        Set fileNamesSet = REGISTER_FOLDER_TO_FILENAMES_MAP.getOrDefault(folderPath, new HashSet());
        if (CollectionUtils.isEmpty((Collection)fileNamesSet)) {
            WatchService watchService = FileWatchService.generateWatchService(folderPath, watchEvents);
            FILE_WATCH_EXECUTOR_SERVICE.execute(() -> FileWatchService.listenTask(watchService, folderPath));
        }
        fileNamesSet.add(fileName);
        REGISTER_FOLDER_TO_FILENAMES_MAP.put(folderPath, fileNamesSet);
        Set runnableSet = FILENAME_TO_UPDATE_RUNNABLE_MAP.getOrDefault(fileName, new HashSet());
        runnableSet.add(updateRunnable);
        FILENAME_TO_UPDATE_RUNNABLE_MAP.put(fileName, runnableSet);
    }

    private static WatchService generateWatchService(String folderPath, List<WatchEvent.Kind<Path>> watchEvents) throws IOException {
        WatchService watchService;
        try {
            LOG.info(String.format(Locale.ROOT, "Start to generateWatchService, folderPath:%s", folderPath));
            watchService = FileSystems.getDefault().newWatchService();
            Path monitorPath = Paths.get(folderPath, new String[0]);
            monitorPath.register(watchService, watchEvents.toArray(new WatchEvent.Kind[0]));
        }
        catch (IOException e) {
            LOG.error("Failed to generateWatchService.");
            throw new IOException("Failed to generateWatchService.");
        }
        return watchService;
    }

    private static void listenTask(WatchService watchService, String folderPath) {
        try {
            WatchKey key;
            while ((key = watchService.take()) != null) {
                FileWatchService.handleWatchKey(key, folderPath);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to execute watchService, cause thread is interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWatchKey(WatchKey key, String folderPath) {
        try {
            for (WatchEvent<?> event : key.pollEvents()) {
                Object eventContext = event.context();
                if (!(eventContext instanceof Path)) {
                    LOG.warn("EventContext not instanceof path.");
                    continue;
                }
                Path changedPath = (Path)eventContext;
                ((Set)REGISTER_FOLDER_TO_FILENAMES_MAP.getOrDefault(folderPath, new HashSet())).stream().filter(fileName -> fileName.equalsIgnoreCase(changedPath.getFileName().toString())).forEach(fileName -> {
                    LOG.info(String.format(Locale.ROOT, "The file:%s changes are detected, start to update.", fileName));
                    FILENAME_TO_UPDATE_RUNNABLE_MAP.get(fileName).forEach(FILE_UPDATE_EXECUTOR_SERVICE::execute);
                });
            }
        }
        catch (Exception e) {
            LOG.error(String.format(Locale.ROOT, "HandleWatchKey failed, msg:%s", CryptLogger.getErrorMessage(e)));
        }
        finally {
            key.reset();
        }
    }

    private static class ExecutorAbortPolicy
    extends ThreadPoolExecutor.AbortPolicy {
        private final String poolName;

        public ExecutorAbortPolicy(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            LOG.error(String.format(Locale.ROOT, "Thread pool:%s threads limit exceeded.", this.poolName));
            super.rejectedExecution(runnable, executor);
        }
    }
}

