/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.connection;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class FusionStorageRestConnectionFactory {
    private static FusionStorageRestConnectionFactory instance = new FusionStorageRestConnectionFactory();
    private static final Log LOGGER = LogFactory.getInstance(FusionStorageRestConnectionFactory.class);

    private FusionStorageRestConnectionFactory() {
    }

    public static FusionStorageRestConnectionFactory getInstance() {
        return instance;
    }

    public FusionStorageRestConnection createConnection(NeMgrProtocolExtend neMgrProtocolExtend, Boolean autoLogin) {
        if (null == neMgrProtocolExtend) {
            LOGGER.error((Object)"neMgrProtocolExtend is null when create FusionStorage Rest Connection.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        String ipAddress = neMgrProtocolExtend.getNetworkIpAddress();
        String port = (String)neMgrProtocolExtend.getExtendParams().get("port");
        String userName = neMgrProtocolExtend.getNetworkUserName();
        String password = neMgrProtocolExtend.getNetworkPassword();
        return new FusionStorageRestConnection(ipAddress, (int)NumberUtil.parseInteger((Object)port), userName, password, autoLogin);
    }

    public FusionStorageRestConnection createConnection(String ipAddress, int port, String username, String password, boolean autoLogin) {
        return new FusionStorageRestConnection(ipAddress, port, username, password, autoLogin);
    }

    public FusionStorageRestConnection getConnection(String sn) {
        RestConnection connection = null;
        try {
            connection = RestConnectionManager.getInstance().getConnection(sn);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred when get FusionStorage Rest Connection.", (Throwable)e);
        }
        if (null != connection && connection instanceof FusionStorageRestConnection && connection.isValid()) {
            return (FusionStorageRestConnection)connection;
        }
        return this.createConnection(this.getNeMgrProtocolExtend(sn), true);
    }

    private NeMgrProtocolExtend getNeMgrProtocolExtend(String sn) {
        List storages = CommonDAOLocator.getBaseDao().find("from StorageNE where sn = ?", new Object[]{sn});
        if (storages == null || storages.isEmpty()) {
            throw new LegoCheckedException(2117645L);
        }
        StorageNE storage = (StorageNE)storages.get(0);
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend connections = service.findByMoId(storage.getMoId());
        if (connections == null) {
            throw new LegoCheckedException(2117645L);
        }
        return connections;
    }
}

