/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.discovery.process;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class FusionStorageSpecifyResourceInfoRetriver
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(FusionStorageSpecifyResourceInfoRetriver.class);

    public boolean process(AbstractContext context) {
        StorageNE storage = (StorageNE)context.getAttribute("StorageDevice", StorageNE.class);
        if (null == storage) {
            logger.error((Object)"storageDevice is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Integer resourceType = (Integer)context.getAttribute("refreshResourceType", Integer.class);
        if (null == resourceType || resourceType != 1) {
            logger.error((Object)"resourceType is null or not is one.");
            throw new LegoCheckedException(1073947393L);
        }
        String resourceID = (String)context.getAttribute("refreshResourceID", String.class);
        if (null == resourceID) {
            logger.error((Object)"resourceID is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)"begin to retrieve fusionstorage resource, sn:%s, resourceType=%s, resourceID=%s", new Object[]{storage.getSn(), resourceType, resourceID});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(storage.getSn());
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List fusionStorageUnitMos = storageService.queryChildMO(storage.getMoId());
        FusionStorageUnit fusionStorageUnit = null;
        if (fusionStorageUnitMos.size() >= 1) {
            for (ManagedObject mo : fusionStorageUnitMos) {
                if (!(mo instanceof FusionStorageUnit)) continue;
                fusionStorageUnit = (FusionStorageUnit)mo;
                break;
            }
        } else {
            logger.error((Object)"storageDevice do not have childMo storageunit.sn:%s, resourceType=%s, resourceID=%s", new Object[]{storage.getSn(), resourceType, resourceID});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(fusionStorageUnit)) {
            logger.error((Object)"fusionStorageUnit is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<StoragePool> pools = this.updateStoragePoolsMO(connection, fusionStorageUnit);
        if (VerifyUtil.isEmpty(pools)) {
            logger.error((Object)"pools is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("update storagepool finished, size:" + pools.size() + ", SN\uff1a" + fusionStorageUnit.getDevSn()));
        this.updateReplicationCGAndPairAndLunMO(storage, resourceID, fusionStorageUnit, pools);
        context.setAttribute("ArrayUnit", (Object)fusionStorageUnit);
        context.setAttribute("StorageArray", (Object)storage);
        logger.debug((Object)"retrieve fusionstorage specify resource finished, sn:%s, resourceType=%s, resourceID=%s", new Object[]{storage.getSn(), resourceType, resourceID});
        return true;
    }

    private List<StoragePool> updateStoragePoolsMO(FusionStorageRestConnection connection, FusionStorageUnit fusionStorageUnit) {
        logger.debug((Object)"query storagepool start. SN:%s", new Object[]{connection.getDeviceId()});
        String responseStr = connection.getForString("/storagePool", null);
        JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
        JSONArray jsonPoolArray = responseJson.getJSONArray("storagePools");
        if (null == jsonPoolArray) {
            logger.error((Object)"Query StoragePools return empty. devSn=%s,response=%s", new Object[]{connection.getDeviceId(), responseStr});
            throw new LegoCheckedException(2117645L);
        }
        List<StoragePool> pools = jsonPoolArray.filter(JSONObject.class).stream().map(pool -> FusionStorageRestTransition.transitionStoragePool(connection.getDeviceId(), pool)).collect(Collectors.toList());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (StoragePool rel : pools) {
            rel.setParentMo((ManagedObject)fusionStorageUnit);
            rel.setTopMoUuid(fusionStorageUnit.getTopMoUuid());
            moDao.saveOrUpdateMo((ManagedObject)rel);
        }
        return pools;
    }

    private void updateReplicationCGAndPairAndLunMO(StorageNE storage, String resourceID, FusionStorageUnit fusionStorageUnit, Collection<StoragePool> pools) {
        logger.debug((Object)"start update replicationCGAndPairAndLun. SN:%s, replicationCG ID=%s", new Object[]{storage.getSn(), resourceID});
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        ReplicationGroup replicationGroups = proxy.getReplicationGroup(storage.getSn(), resourceID);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        replicationGroups.setParentMo((ManagedObject)fusionStorageUnit);
        replicationGroups.setTopMoUuid(fusionStorageUnit.getTopMoUuid());
        moDao.saveOrUpdateMo((ManagedObject)replicationGroups);
        List replicationPairList = proxy.queryReplicationPairByCgId(storage.getSn(), resourceID);
        ArrayList<String> lunIds = new ArrayList<String>();
        for (ReplicationPair tempReplicationPair : replicationPairList) {
            lunIds.add(tempReplicationPair.getIsPrimary() != false ? tempReplicationPair.getSrcLunId() : tempReplicationPair.getTgtLunId());
            tempReplicationPair.setParentMo((ManagedObject)fusionStorageUnit);
            tempReplicationPair.setTopMoUuid(fusionStorageUnit.getTopMoUuid());
            moDao.saveOrUpdateMo((ManagedObject)tempReplicationPair);
            logger.debug((Object)"update pair of ReplicationGroup. SN:%s, replication ID=%s", new Object[]{storage.getSn(), tempReplicationPair.getReplicationId()});
        }
        StorageLunManagerProxy proxyStorageLun = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxyStorageLun.getStorageLunMgrByDevId(storage.getSn());
        List luns = manager.queryLuns(storage.getSn(), lunIds);
        for (Lun lun : luns) {
            for (StoragePool tempStoragePool : pools) {
                if (lun.getStoragePoolId() == null || !lun.getStoragePoolId().equals(tempStoragePool.getPoolId())) continue;
                lun.setParentMo((ManagedObject)tempStoragePool);
                lun.setTopMoUuid(tempStoragePool.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)lun);
                logger.debug((Object)"start update lun of replication. SN:%s, LUN ID=%s", new Object[]{storage.getSn(), lun.getLunId()});
            }
        }
        logger.debug((Object)"end update replicationCGAndPairAndLun. SN:%s, replicationCG ID=%s", new Object[]{storage.getSn(), resourceID});
    }

    public void postProcess(AbstractContext context) {
        logger.info((Object)"nothing need to process in this phase.");
    }

    public void clean(AbstractContext context) {
        logger.info((Object)"nothing need to clean.");
    }
}

