/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Optional;

public final class FusionStorageVolumeUtil {
    public static final String LUN_TYPE = "lunType";
    public static final String FUSION_STORAGE_VULUME_TYPE = "FSB_Volume_Type";

    private FusionStorageVolumeUtil() {
    }

    public static JSONObject getDescription(Lun lun) {
        String description = lun.getDescription();
        return JSONObject.fromObject((Object)description);
    }

    public static boolean checkVolume(JSONObject description) {
        String type = description.getString(LUN_TYPE);
        return "FSB_Volume".equals(type);
    }

    public static boolean isSCSIVolume(JSONObject description) {
        return FusionStorageVolumeUtil.volumeType(description).map(type -> type == 0).get();
    }

    public static boolean isISCSIVolume(JSONObject description) {
        return FusionStorageVolumeUtil.volumeType(description).map(type -> type == 1).get();
    }

    public static Optional<Integer> volumeType(JSONObject description) {
        if (!FusionStorageVolumeUtil.checkVolume(description)) {
            return Optional.of(-1);
        }
        return Optional.of(description.getInt(FUSION_STORAGE_VULUME_TYPE));
    }
}

