/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.application.manager.proxy;

import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import java.util.HashMap;
import java.util.Map;

public final class ApplicationAdapterProxy {
    private static ApplicationAdapterProxy instance = null;
    private static Map<Integer, IApplicationManager> appManagerMapping = null;

    private ApplicationAdapterProxy() {
        ApplicationAdapterProxy.setAppManagerMapping(new HashMap<Integer, IApplicationManager>());
    }

    public static synchronized ApplicationAdapterProxy getInstance() {
        if (null == instance) {
            instance = new ApplicationAdapterProxy();
        }
        return instance;
    }

    public void onBind(IApplicationManager appManager, Map properties) {
        appManagerMapping.put(appManager.getAppType(), appManager);
    }

    public void onUnbind(IApplicationManager appManager, Map properties) {
        appManagerMapping.remove(appManager.getAppType());
    }

    public IApplicationManager getAppManager(int appType) {
        return appManagerMapping.get(appType);
    }

    private static void setAppManagerMapping(Map<Integer, IApplicationManager> appManagerMapping) {
        ApplicationAdapterProxy.appManagerMapping = appManagerMapping;
    }
}

