/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.job.airgapjob;

import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

class DisableTask
implements Runnable {
    private static final Log logger = LogFactory.getInstance(DisableTask.class);
    private final AirGapLinkProcessor processor;

    private DisableTask(AirGapLinkProcessor processor) {
        this.processor = processor;
    }

    public static DisableTask getInstance(AirGapLinkProcessor processor) {
        return new DisableTask(processor);
    }

    @Override
    public void run() {
        try {
            this.processor.cleanOperateLog();
            logger.debug((Object)"Begin to get disable port list");
            List<StorageLinkPort> linkPortList = this.processor.getNeedToDisableLinkPorts();
            if (CollectionUtils.isEmpty(linkPortList)) {
                logger.debug((Object)"linkPortList is null, return.");
                return;
            }
            Set<String> maintainPortIds = AirGapLinkPortUtil.getSwitchMaintainPortIds();
            List<StorageLinkPort> waitDisablePorts = linkPortList.stream().filter(linkPort -> !maintainPortIds.contains(linkPort.getPortId())).collect(Collectors.toList());
            this.processor.doDisablePort(waitDisablePorts);
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred when handle the disable port and logs.: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

