/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.protection.framework.engine.job.ProtectionQuartzTriggerListener;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.task.sdk.model.BaseTask;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.task.sdk.model.ITask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class TaskManagerImpl
implements ITaskManager {
    private static Log logger = LogFactory.getInstance(TaskManagerImpl.class);
    private static final String PROTECTGROUPNAME = "ProtectGroupQuartzScheduler";
    private static final String DEFAULT_PROPERTIES = "protectgroup_quartz.properties";
    private Properties props = new Properties();
    private Scheduler quartzScheduler;
    private Map<String, Class<? extends Job>> jobClassMap = new HashMap<String, Class<? extends Job>>();

    public void start() {
        this.startQuartz();
    }

    private void startQuartz() {
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory();
            if (sf.getScheduler(PROTECTGROUPNAME) != null) {
                this.quartzScheduler = sf.getScheduler(PROTECTGROUPNAME);
            } else {
                this.readProperties();
                sf.initialize(this.props);
                this.quartzScheduler = sf.getScheduler();
            }
            this.quartzScheduler.getListenerManager().addTriggerListener((TriggerListener)new ProtectionQuartzTriggerListener());
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"load quartz file failed", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    @Override
    public <T extends ITask> void recoveryExistTasks(List<T> tasks) {
        for (ITask task : tasks) {
            if (1 != task.getStatus()) continue;
            this.schedule(task);
        }
    }

    private boolean isTriggerRunning(String triggerName) {
        boolean isRunning = false;
        List currentJobs = null;
        try {
            currentJobs = this.quartzScheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            logger.error((Object)"get currently executing jobs failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != currentJobs) {
            for (JobExecutionContext jobCtx : currentJobs) {
                Trigger trigger = jobCtx.getTrigger();
                if (!triggerName.equals(trigger.getKey().getName())) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    private boolean isGroupRunning(String groupName) {
        boolean isRunning = false;
        List currentJobs = null;
        try {
            currentJobs = this.quartzScheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            logger.error((Object)"get currently executing jobs failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != currentJobs) {
            for (JobExecutionContext jobCtx : currentJobs) {
                String tmpGroupName = jobCtx.getJobDetail().getKey().getGroup();
                if (!tmpGroupName.equals(groupName)) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    private String getJobName(ITask task) {
        return "JOB_" + task.getTaskId() + task.getJobClassName();
    }

    private String getJobGroupName(ITask task) {
        return "JOB_GROUP_" + task.getTaskGroup();
    }

    private String getTriggerName(ITask task) {
        return "TRIGGER_" + task.getTaskId();
    }

    private String getTriggerGroupName(ITask task) {
        return "TRIGGER_GROUP_" + task.getTaskGroup();
    }

    private String getManualJobName(ITask task) {
        return "MANUAL_JOB_" + task.getJobClassName();
    }

    private Class<? extends Job> getJobClass(String jobClassName) {
        if (null == jobClassName || jobClassName.trim().isEmpty()) {
            return null;
        }
        Class<Object> jobClass = this.jobClassMap.get(jobClassName);
        if (null == jobClass) {
            try {
                ClassLoader clsLoader = this.getClass().getClassLoader();
                if (null == clsLoader) {
                    logger.error((Object)"get job class failed", 90160758784001L);
                    throw new LegoCheckedException(-1L);
                }
                jobClass = clsLoader.loadClass(jobClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("get job class failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        return jobClass;
    }

    private long calculateInterval(ISchedule schedule) {
        long interval;
        logger.debug((Object)("schedule.getPeriodType:" + schedule.getPeriodType()));
        switch (schedule.getPeriodType()) {
            case 0: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 60L;
                break;
            }
            case 1: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 60L * 60L;
                break;
            }
            case 2: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 24L * 60L * 60L;
                break;
            }
            case 6: {
                interval = 0L;
                break;
            }
            default: {
                logger.error((Object)("invalid schedule period type, period type=" + schedule.getPeriodType()), 90160758784001L);
                throw new LegoCheckedException(-1L);
            }
        }
        return interval;
    }

    private AbstractTrigger createSimpleTrigger(ITask task) {
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        ISchedule schedule = task.getSchedule();
        Calendar validateDateStartCalendar = this.getValidateDateStartTime(schedule);
        Date startTime = validateDateStartCalendar.getTime();
        String endTimeStr = schedule.getEndTime();
        SimpleTriggerImpl quartzSimpleTrigger = new SimpleTriggerImpl(triggerName, triggerGroupName, jobName, jobGroupName, startTime, endTimeStr == null ? null : new Date(NumberUtil.convertToLong((Object)endTimeStr)), schedule.getRepeatTimes(), this.calculateInterval(schedule));
        return quartzSimpleTrigger;
    }

    private Calendar getValidateDateStartTime(ISchedule schedule) {
        String startTime = schedule.getStartTime();
        if (VerifyUtil.isEmpty((String)startTime)) {
            String errMsg = "startTime is empty! schedule Id : " + schedule.getScheduleId();
            logger.error((Object)errMsg, 90160758784001L);
            throw new LegoCheckedException(-1L, null, errMsg);
        }
        int periodType = schedule.getPeriodType();
        if (periodType == 6) {
            Calendar validateStartCalendar = Calendar.getInstance();
            validateStartCalendar.setTime(new Date(NumberUtil.convertToLong((Object)startTime)));
            return validateStartCalendar;
        }
        if (periodType == 2) {
            Calendar validateStartCalendar = Calendar.getInstance();
            validateStartCalendar.setTime(new Date(NumberUtil.convertToLong((Object)startTime)));
            validateStartCalendar.set(11, NumberUtil.convertToInteger((Object)schedule.getHours(), (int)0));
            validateStartCalendar.set(12, NumberUtil.convertToInteger((Object)schedule.getMinutes(), (int)0));
            validateStartCalendar.set(13, 0);
            return validateStartCalendar;
        }
        Calendar validateStartCalendar = Calendar.getInstance();
        Date now = new Date();
        if (!ProtectionJobUtil.getInstance().isTimeInRange(schedule, now)) {
            Date validateStartTime = ProtectionJobUtil.getInstance().getNextExeTimeWhenOutOfTimeRange(schedule, now);
            validateStartCalendar.setTime(validateStartTime);
            return validateStartCalendar;
        }
        Date startDate = new Date(NumberUtil.convertToLong((Object)startTime));
        if (!VerifyUtil.isEmpty((Collection)schedule.getScheduleRanges()) && startDate.before(now)) {
            Date validateStartTime = ProtectionJobUtil.getInstance().getStartTimeInRangeTime(schedule, now);
            validateStartCalendar.setTime(validateStartTime);
            return validateStartCalendar;
        }
        validateStartCalendar.setTime(startDate);
        return validateStartCalendar;
    }

    private String getCronExpression(ISchedule schedule) {
        StringBuffer strBuf = new StringBuffer();
        this.constructCronHourMinSeconds(strBuf, schedule);
        switch (schedule.getPeriodType()) {
            case 3: {
                strBuf.append("? * ");
                strBuf.append(schedule.getDaysOfWeek());
                break;
            }
            case 4: {
                strBuf.append(schedule.getDaysOfMonth());
                strBuf.append(" * ?");
                break;
            }
            case 2: {
                strBuf.append("* * ?");
                break;
            }
            default: {
                logger.error((Object)("invalid schedule period type, period type=" + schedule.getPeriodType()), 90160758784001L);
                throw new LegoCheckedException(-1L);
            }
        }
        return strBuf.toString();
    }

    private void constructCronHourMinSeconds(StringBuffer strBuf, ISchedule schedule) {
        String hours = schedule.getHours();
        String minutes = schedule.getMinutes();
        String seconds = schedule.getSeconds();
        logger.debug((Object)("hours:" + hours + ", minutes:" + minutes + ", seconds:" + seconds));
        this.linkTimeStr(strBuf, seconds);
        this.linkTimeStr(strBuf, minutes);
        this.linkTimeStr(strBuf, hours);
    }

    private void linkTimeStr(StringBuffer strBuf, String time) {
        if (VerifyUtil.isEmpty((String)time)) {
            strBuf.append('0');
        } else {
            strBuf.append(time);
        }
        strBuf.append(' ');
    }

    private AbstractTrigger createCronTrigger(ITask task) {
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        ISchedule schedule = task.getSchedule();
        Date validateDateStartTime = this.getValidateDateStartTimeForCronTrigger(schedule);
        String endTimeStr = schedule.getEndTime();
        CronTriggerImpl quartzCronTrigger = null;
        try {
            quartzCronTrigger = new CronTriggerImpl(triggerName, triggerGroupName, jobName, jobGroupName, validateDateStartTime, endTimeStr == null ? null : new Date(NumberUtil.convertToLong((Object)endTimeStr)), this.getCronExpression(schedule));
        }
        catch (ParseException e) {
            logger.error((Object)"parse crontab expression failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return quartzCronTrigger;
    }

    private Date getValidateDateStartTimeForCronTrigger(ISchedule schedule) {
        String startTimeStr = schedule.getStartTime();
        if (VerifyUtil.isEmpty((String)startTimeStr)) {
            String errorMsg = "startTimeStr is empty!schedule Id : " + schedule.getScheduleId();
            logger.error((Object)errorMsg, 90160758784001L);
            throw new LegoCheckedException(-1L, null, errorMsg);
        }
        Date startDate = new Date(NumberUtil.convertToLong((Object)startTimeStr));
        return startDate;
    }

    private AbstractTrigger createTrigger(ITask task) {
        AbstractTrigger quartzTrigger;
        ISchedule schedule = task.getSchedule();
        if (0 == schedule.getPeriodType() || 1 == schedule.getPeriodType() || 6 == schedule.getPeriodType()) {
            quartzTrigger = this.createSimpleTrigger(task);
        } else if (2 == schedule.getPeriodType()) {
            quartzTrigger = this.createDayTrigger(task);
        } else if (3 == schedule.getPeriodType() || 4 == schedule.getPeriodType()) {
            quartzTrigger = this.createCronTrigger(task);
        } else {
            logger.error((Object)("invalid schedule period type, period type=" + task.getSchedule().getPeriodType()), 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        try {
            this.quartzScheduler.getListenerManager().addTriggerListener((TriggerListener)new ProtectionQuartzTriggerListener());
        }
        catch (SchedulerException e) {
            logger.error((Object)"quartzScheduler get listener manager got error!", (Throwable)e);
        }
        return quartzTrigger;
    }

    private AbstractTrigger createDayTrigger(ITask task) {
        ISchedule schedule = task.getSchedule();
        int periodInterval = schedule.getPeriodInterval();
        if (periodInterval == 1) {
            return this.createCronTrigger(task);
        }
        if (periodInterval > 1) {
            return this.createSimpleTrigger(task);
        }
        String message = "createDayTrigger failed! schedule ID:" + task.getSchedule().getScheduleId();
        logger.error((Object)message, 90160758784001L);
        throw new LegoCheckedException(-1L, null, message);
    }

    @Override
    public synchronized void schedule(ITask task) {
        this.checkParam(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("TASK", (Object)task);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        try {
            String triggerGroupName;
            String triggerName;
            TriggerKey triggerKey;
            AbstractTrigger trigger;
            JobDetail quartzJobDetail = this.quartzScheduler.getJobDetail(jobKey);
            if (null == quartzJobDetail) {
                Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
                quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
                ((JobDetailImpl)quartzJobDetail).setDurability(true);
                logger.debug((Object)("create new jobdetail, job class name=" + jobName), 90160758784001L);
                this.quartzScheduler.addJob(quartzJobDetail, true);
            }
            if (!(trigger = this.createTrigger(task)).equals((Object)this.quartzScheduler.getTrigger(triggerKey = new TriggerKey(triggerName = this.getTriggerName(task), triggerGroupName = this.getTriggerGroupName(task))))) {
                trigger.setJobDataMap(jobDataMap);
                this.quartzScheduler.scheduleJob((Trigger)trigger);
                logger.debug((Object)("add new cron trigger, trigger name=" + trigger.getKey().getName()), 90160758784001L);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"schedule job failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void unschedule(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        logger.debug((Object)("unschedule task, trigger name=" + triggerName + " ,trigger group name=" + triggerGroupName), 90160758784001L);
        try {
            this.quartzScheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"unschedule job failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void pause(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            this.quartzScheduler.pauseTrigger(triggerKey);
            if (this.isTriggerRunning(triggerName)) {
                logger.error((Object)("trigger is running, can't pause it. trigger name=" + triggerName + " , trigger group name" + triggerGroupName), 90160758784001L);
                this.quartzScheduler.resumeTrigger(triggerKey);
                throw new LegoCheckedException(-1L);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"pause trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void pauseGroup(String groupName) {
        this.checkParam(groupName);
        try {
            this.quartzScheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)groupName));
            if (this.isGroupRunning(groupName)) {
                logger.error((Object)("some jobs are running, can't pause the job group. job group name=" + groupName), 90160758784001L);
                this.quartzScheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
                throw new LegoCheckedException(-1L);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"pause job group failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resume(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            JobDataMap quartzJobDataMap = trigger.getJobDataMap();
            BaseTask bufferedTask = (BaseTask)quartzJobDataMap.get((Object)"TASK");
            bufferedTask.setNextExecTime(task.getNextExecTime());
            this.quartzScheduler.resumeTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"resume trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resumeGroup(String groupName) {
        this.checkParam(groupName);
        try {
            this.quartzScheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
        }
        catch (SchedulerException e) {
            logger.error((Object)"resume job group failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void runAtOnce(ITask task) {
        block5: {
            this.checkParam(task);
            String triggerName = this.getTriggerName(task);
            String triggerGroupName = this.getTriggerGroupName(task);
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            String jobName = this.getManualJobName(task);
            String jobGroupName = this.getJobGroupName(task);
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
            JobDetailImpl quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
            quartzJobDetail.setDurability(true);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("TASK", (Object)task);
            try {
                SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(triggerName, triggerGroupName);
                simpleTrigger.setJobDataMap(jobDataMap);
                JobDetail job = this.quartzScheduler.getJobDetail(jobKey);
                if (null == job) {
                    logger.info((Object)("First schedule job:" + jobGroupName), 90160758786988L);
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    break block5;
                }
                Trigger.TriggerState state = this.quartzScheduler.getTriggerState(triggerKey);
                if (state == null) {
                    logger.error((Object)"schedule get trigger state is null !");
                    throw new LegoCheckedException(1073947393L);
                }
                String stateName = state.name();
                if (Trigger.TriggerState.PAUSED.name().equals(stateName) || Trigger.TriggerState.COMPLETE.name().equals(stateName) || Trigger.TriggerState.ERROR.name().equals(stateName) || Trigger.TriggerState.BLOCKED.name().equals(stateName) || Trigger.TriggerState.NONE.name().equals(stateName)) {
                    logger.info((Object)("Reschedule job is:" + jobGroupName + " QuartzScheduler state is:" + state.name()), 90160758786988L);
                    this.quartzScheduler.deleteJob(jobKey);
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    state = this.quartzScheduler.getTriggerState(triggerKey);
                    logger.info((Object)("Rescheduled job is:" + jobGroupName + " QuartzScheduler state is:" + state.name()), 90160758786988L);
                    break block5;
                }
                logger.error((Object)("QuartzScheduler state is:" + state), 90160758786989L);
                throw new LegoCheckedException(1073948200L);
            }
            catch (SchedulerException e) {
                logger.error((Object)"schedule volatile trigger failed", (Throwable)e, 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isExistTrigger(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            return !VerifyUtil.isEmpty((Object)trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"get trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void updateTrigger(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("TASK", (Object)task);
        AbstractTrigger newTrigger = this.createTrigger(task);
        newTrigger.setJobDataMap(jobDataMap);
        try {
            Trigger t = this.quartzScheduler.getTrigger(triggerKey);
            if (null == t) {
                logger.debug((Object)"updateTrigger the Trigger is null, recreate.", 90160758784001L);
                String jobName = this.getJobName(task);
                String jobGroupName = this.getJobGroupName(task);
                JobKey jobKey = new JobKey(jobName, jobGroupName);
                JobDetail quartzJobDetail = this.quartzScheduler.getJobDetail(jobKey);
                if (null == quartzJobDetail) {
                    Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
                    quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
                    ((JobDetailImpl)quartzJobDetail).setDurability(true);
                    logger.debug((Object)("updateTrigger create new jobdetail, job class name=" + jobName), 90160758784001L);
                    this.quartzScheduler.addJob(quartzJobDetail, true);
                }
                this.quartzScheduler.scheduleJob((Trigger)newTrigger);
            } else {
                this.quartzScheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"update trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public String getGroupName(String protectPolicyId) {
        if (null == protectPolicyId) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return "JOB_GROUP_" + protectPolicyId;
    }

    @Override
    public Date getNextExecTime(ITask task, boolean isNewTrigger) {
        this.checkParam(task);
        Date nextExecTime = null;
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        Date curr = new Date();
        if (!ProtectionJobUtil.getInstance().isTimeInRange(task.getSchedule(), curr)) {
            return ProtectionJobUtil.getInstance().getNextExeTimeWhenOutOfTimeRange(task.getSchedule(), curr);
        }
        if (isNewTrigger) {
            AbstractTrigger trigger = this.createTrigger(task);
            nextExecTime = trigger.getFireTimeAfter(curr);
        } else {
            Trigger trigger;
            try {
                trigger = this.quartzScheduler.getTrigger(triggerKey);
            }
            catch (SchedulerException e) {
                logger.error((Object)"get trigger failed", (Throwable)e, 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            if (null != trigger) {
                nextExecTime = trigger.getFireTimeAfter(curr);
            }
        }
        return nextExecTime;
    }

    private void checkParam(Object param) {
        if (null == param) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = AdapterUtils.getClassLoader(this.getClass());
            if (null == classLoader) {
                logger.error((Object)"read default.properties fail.", 90160758784001L);
                return;
            }
            Enumeration<URL> enums = classLoader.getResources(DEFAULT_PROPERTIES);
            while (null != enums && enums.hasMoreElements()) {
                URL url = enums.nextElement();
                inputStream = url.openStream();
            }
            if (null != inputStream) {
                this.props.load(inputStream);
            }
        }
        catch (Exception e) {
            logger.error((Object)"read default.properties fail.", 90160758784001L);
        }
        finally {
            this.closeInputStream(inputStream);
        }
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    @Override
    public Scheduler getquartzScheduler() {
        return this.quartzScheduler;
    }

    @Override
    public void deleteJob(ITask task) {
        this.checkParam(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        logger.debug((Object)("delete job, trigger name=" + jobName + " ,trigger group name=" + jobGroupName), 90160758784001L);
        try {
            this.quartzScheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"delete job failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resetNextExecuteTime(ITask task, Date startTime) {
        ISchedule schedule = task.getSchedule();
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            ProtectionJobUtil.getInstance().resetNextExecuteTime(schedule, startTime, this.quartzScheduler, trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"resetNextExecuteTime trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }
}

