/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class PropsUtil {
    private static final Log logger = LogFactory.getInstance(PropsUtil.class);

    public static void insertOrUpdateProp(PropModel propModel, String id, String name, String value) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel)) || VerifyUtil.isEmpty((String)id) || VerifyUtil.isEmpty((String)name) || VerifyUtil.isEmpty((String)value)) {
            logger.error((Object)"parameter is empty. propModel=%s,id=%s,name=%s", new Object[]{propModel, id, name});
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        HibernateUtil.execute(() -> {
            NativeQuery nativeQuery = session.createSQLQuery(String.format(Locale.ENGLISH, "select PROPVALUE from %s where %s =:ID and PROPNAME =:PROPNAME", propModel.getTable(), propModel.getIdColumn()));
            nativeQuery.setParameter("ID", (Object)id);
            nativeQuery.setParameter("PROPNAME", (Object)name);
            List valueList = nativeQuery.list();
            nativeQuery = CollectionUtils.isEmpty((Collection)valueList) ? session.createSQLQuery(String.format(Locale.ENGLISH, "INSERT INTO %s(%s,PROPNAME, PROPVALUE) VALUES (:ID,:PROPNAME,:PROPVALUE)", propModel.getTable(), propModel.getIdColumn())) : session.createSQLQuery(String.format(Locale.ENGLISH, "UPDATE %s SET PROPVALUE = :PROPVALUE where %s = :ID and PROPNAME = :PROPNAME", propModel.getTable(), propModel.getIdColumn()));
            nativeQuery.setParameter("ID", (Object)id);
            nativeQuery.setParameter("PROPNAME", (Object)name);
            nativeQuery.setParameter("PROPVALUE", (Object)value);
            nativeQuery.executeUpdate();
        }, session);
    }

    public static void deleteProp(PropModel propModel, String id, String name) {
        if (VerifyUtil.isEmpty((Object)((Object)propModel)) || VerifyUtil.isEmpty((String)id) || VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)"parameter is empty. propModel=%s,id=%s,name=%s", new Object[]{propModel, id, name});
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        HibernateUtil.execute(() -> {
            NativeQuery nativeQuery = session.createSQLQuery(String.format(Locale.ENGLISH, "DELETE FROM %s WHERE %s = :ID and PROPNAME = :PROPNAME", propModel.getTable(), propModel.getIdColumn()));
            nativeQuery.setParameter("ID", (Object)id);
            nativeQuery.setParameter("PROPNAME", (Object)name);
            nativeQuery.executeUpdate();
        }, session);
    }

    public static enum PropModel {
        RECOVERYPLAN("ti_rp_globalsettings", "PLANID"),
        PROTECTGROUP("ti_protectgroup_prop", "PGID"),
        PROTECTOBJECT("ti_po_prop", "POID");

        private String table;
        private String idColumn;

        private PropModel(String table, String idColumn) {
            this.table = table;
            this.idColumn = idColumn;
        }

        public String getTable() {
            return this.table;
        }

        public String getIdColumn() {
            return this.idColumn;
        }
    }
}

