/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public final class ResourceUtil
implements InitializingBean {
    private static Log logger = LogFactory.getInstance(ResourceUtil.class);
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static Properties props = new Properties();
    private static ResourceUtil instance;

    public static synchronized ResourceUtil getInstance() {
        if (null == instance) {
            instance = new ResourceUtil();
        }
        return instance;
    }

    public static String getValue(String key) {
        return ResourceUtil.getValue(key, null);
    }

    public static String getValue(String key, String defaultValue) {
        String value = defaultValue;
        if (props != null) {
            value = props.getProperty(key, defaultValue);
        }
        return value;
    }

    public void afterPropertiesSet() {
        ResourceUtil.setProps(this.readProperties(DEFAULT_PROPERTIES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String propFile) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String jarfileName = AdapterUtils.getClassJarPath(ResourceUtil.class);
            if (null == jarfileName) {
                logger.error((Object)"read default.properties jarfileName null.", 90160758784001L);
            } else {
                URL url = AdapterUtils.getUrlResourceFromJar((ClassLoader)ResourceUtil.class.getClassLoader(), (String)jarfileName, (String)propFile);
                if (null != url) {
                    inputStream = url.openStream();
                    properties.load(inputStream);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"read default.properties fail.", 90160758784001L);
        }
        finally {
            this.closeInputStream(inputStream);
        }
        return properties;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private static void setProps(Properties props) {
        ResourceUtil.props = props;
    }
}

