/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.xml;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XmlParser {
    private static final Log logger = LogFactory.getInstance(XmlParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document init(URL processFileUrl) {
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = processFileUrl.openStream();
            document = this.init(inputStream);
        }
        catch (Exception e) {
            logger.error((Object)("Reading template file failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            this.closeInputStream(inputStream);
        }
        return document;
    }

    public Document init(InputStream inputStream) {
        try {
            return CommonUtil.newSecureSAXReader().read(inputStream);
        }
        catch (Exception e) {
            logger.error((Object)("Initializing document failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public Document init(File xmlFile) {
        try {
            return CommonUtil.newSecureSAXReader().read(xmlFile);
        }
        catch (Exception e) {
            logger.error((Object)("Initializing document failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public Document init(String xmlText) {
        Document document = null;
        try {
            SAXReader reader = CommonUtil.newSecureSAXReader();
            String encoding = this.getEncoding(xmlText);
            InputSource source = new InputSource(new StringReader(xmlText));
            source.setEncoding(encoding);
            document = reader.read(source);
            if (document.getXMLEncoding() == null) {
                document.setXMLEncoding(encoding);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Initializing document failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return document;
    }

    private String getEncoding(String text) {
        String startTag;
        String result = null;
        String xml = text.trim();
        if (xml.startsWith(startTag = "<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(startTag.length(), end);
            result = this.findEncoding(sub);
        }
        return result;
    }

    private String findEncoding(String sub) {
        String result = null;
        StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!Objects.equals("encoding", token)) continue;
            if (!tokens.hasMoreTokens()) break;
            result = tokens.nextToken();
            break;
        }
        return result;
    }

    public String getAttribute(Element element, String attrName) {
        Attribute attribute = element.attribute(attrName);
        if (null == attribute) {
            return "";
        }
        return attribute.getValue();
    }

    public Element getRootElement(Document document) {
        if (null == document) {
            return null;
        }
        return document.getRootElement();
    }

    public String getText(Element parent, String xPath) {
        List<Node> nodes = this.getNodes(parent, xPath);
        String text = null;
        if (null != nodes && !nodes.isEmpty()) {
            text = nodes.get(0).getText();
        }
        return text;
    }

    public List<Node> getNodes(Element parent, String xPath) {
        return CommonUtil.getNodes((Element)parent, (String)xPath);
    }

    private void closeInputStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }
}

