/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.cbb.util.UrlUtil;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum CertUriResolver {
    SERVER("Server"){

        @Override
        public CertificateSummary resolve(String uri) {
            return this.resolve(uri, new String[0]);
        }
    }
    ,
    DEPEND("Depend"){

        @Override
        public CertificateSummary resolve(String uri) {
            return this.resolve(uri, "service:dependServiceName", "cert:dependCertName", "format:dependCertFormat", "use:dependType");
        }
    };

    private String name;

    private CertUriResolver(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static CertUriResolver get(String name) {
        for (CertUriResolver type : CertUriResolver.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static List<CertificateSummary> resolve(List<String> items) {
        return items.stream().map(CertUriResolver::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static CertificateSummary parse(String uri) {
        return Optional.ofNullable(UrlUtil.parse((String)uri)).map(url -> CertUriResolver.get(url.getProtocol())).map(resolver -> resolver.resolve(uri)).orElse(null);
    }

    public abstract CertificateSummary resolve(String var1);

    protected CertificateSummary resolve(String uri, String ... aliases) {
        HashMap data;
        Log logger = LogFactory.getInstance(CertUriResolver.class);
        URL url = UrlUtil.parse((String)uri);
        if (url == null || !this.name.equalsIgnoreCase(url.getProtocol())) {
            logger.error((Object)"certificate url is null.");
            return null;
        }
        if (url.getPath() == null) {
            logger.error((Object)"certificate path is null.");
            return null;
        }
        String certName = url.getPath().replaceAll("^/", "").replaceAll("/", "-");
        String[] certNameStr = certName.split("-");
        if (certNameStr.length != 2) {
            logger.error((Object)"the format of certificate name is incorrect.");
            return null;
        }
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        String[] items = userInfo.split(":");
        if (items.length != 2) {
            return null;
        }
        String use = items[0];
        String category = items[1];
        String type = url.getProtocol();
        String certFormat = url.getHost();
        try {
            data = new HashMap(Optional.ofNullable(UrlUtil.query((String)url.getQuery(), (char[])new char[]{'-'})).orElse(Collections.emptyMap()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("resolve cert info, catch UnsupportedEncodingException: " + e.toString()));
            return null;
        }
        for (String alias : aliases) {
            int index = alias.indexOf(58);
            String k = alias.substring(0, index);
            String v = alias.substring(index + 1);
            data.put(v, data.remove(k));
        }
        int keySize = url.getPort() >= 0 ? url.getPort() : 2048;
        CertificateSummary summary = (CertificateSummary)JSONObject.toBean((JSONObject)JSONObject.fromObject(data), CertificateSummary.class);
        summary.setType(type);
        summary.setUse(use);
        summary.setCertName(certName);
        summary.setCertFormat(certFormat);
        summary.setDescription(CertUriResolver.getDescriptionFromConfig(certNameStr[1]));
        summary.setKeySize(keySize);
        summary.setCategory(category);
        logger.info((Object)"resolve summary succeed.");
        return summary;
    }

    private static String getDescriptionFromConfig(String item) {
        String zh = LegoConfig.getInstance().getKeyValue("cert." + item + ".description.zh", "");
        String en = LegoConfig.getInstance().getKeyValue("cert." + item + ".description.en", "");
        Log logger = LogFactory.getInstance(CertUriResolver.class);
        logger.info((Object)("certificate description: " + item));
        if (VerifyUtil.isEmpty((String)zh) || VerifyUtil.isEmpty((String)en)) {
            logger.error((Object)("certificate description is empty, zh: " + zh + ", en: " + en));
            return "";
        }
        return zh + "##" + en;
    }
}

