/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.component;

import com.huawei.ism.drm.cert.CertUriResolver;
import com.huawei.ism.drm.cert.component.AbstractCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.IComplexCertificateService;
import com.huawei.ism.drm.cert.task.CertificateNotifyTask;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class ComplexCertificateService
extends AbstractCertificateService
implements IComplexCertificateService {
    private CertificateSummary summary;

    public ComplexCertificateService(String certificate) {
        this.summary = CertUriResolver.parse(certificate);
    }

    public void initialize(List<CertificateSummary> summaries) {
        this.summary.getChildren().addAll(summaries);
    }

    public void initialize() {
        this.getSystemCertificateService().getCertificateHandler(this.summary).fulfil(this.summary);
    }

    public List<CertificateSummary> getCertificateSummaries() {
        return Collections.singletonList(this.summary);
    }

    public CertificateOperateStatus submitCertificateUpdateTask(BlockingQueue queue, CertificateSummary certificateSummary, CertificateUpdateParam param, boolean independent, boolean onlyRegisterable) {
        if (param.getCert() == null) {
            return CertificateOperateStatus.failed((String)"value of field 'cert' is not provided");
        }
        JSONObject json = JSONObject.fromObject((Object)param);
        for (CertificateSummary child : certificateSummary.getChildren()) {
            CertificateUpdateParam childCertificateUpdateParam = (CertificateUpdateParam)JSONObject.toBean((JSONObject)json, CertificateUpdateParam.class);
            childCertificateUpdateParam.getCert().setCertName(child.getCertName());
            CertificateOperateStatus status = child.submitCertificateUpdateTask(queue, childCertificateUpdateParam, false, false);
            if (!status.failure()) continue;
            queue.add(new CertificateNotifyTask(this.getSystemCertificateService(), param.getCert().getCertName(), param.getTaskId()));
            return status;
        }
        queue.add(new CertificateNotifyTask(this.getSystemCertificateService(), param.getCert().getCertName(), param.getTaskId()));
        return CertificateOperateStatus.success();
    }
}

