/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.component;

import com.huawei.ism.drm.cert.CertUriResolver;
import com.huawei.ism.drm.cert.NodeAgentCommand;
import com.huawei.ism.drm.cert.component.AbstractCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.ICertificateHandler;
import com.huawei.ism.drm.cert.sdk.service.IComponentCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.INodeAgentCommand;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.cert.task.CertificateUpdateTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public abstract class ComponentCertificateService
extends AbstractCertificateService
implements IComponentCertificateService {
    private static final Log logger = LogFactory.getInstance(ComponentCertificateService.class);
    private List<CertificateSummary> certificateSummaries;
    private NodeAgentCommand certificateReplaceCommand;
    private NodeAgentCommand certificateRollbackCommand;

    public ComponentCertificateService(List<String> certs, String operateCommand, String rollbackCommand) {
        this.certificateSummaries = CertUriResolver.resolve(certs);
        this.certificateReplaceCommand = NodeAgentCommand.create(operateCommand, 1073949714L);
        this.certificateRollbackCommand = NodeAgentCommand.create(rollbackCommand, 1073949717L);
    }

    public List<CertificateSummary> getCertificateSummaries() {
        return this.certificateSummaries;
    }

    @Override
    public void setNodeAgentLocalService(NodeAgentLocalService.Iface nodeAgentLocalService) {
        super.setNodeAgentLocalService(nodeAgentLocalService);
        this.certificateReplaceCommand.setNodeAgentLocalService(nodeAgentLocalService);
        this.certificateRollbackCommand.setNodeAgentLocalService(nodeAgentLocalService);
    }

    protected CommandReaction<Map<Node, Response>> executeCommand(INodeAgentCommand command, List<Node> nodes, Parameter ... params) {
        logger.info((Object)"execute command.");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(Optional.ofNullable(params).map(Arrays::asList).orElseGet(Collections::emptyList));
        parameters.add(0, this.getBuiltinParam());
        return command.execute(nodes, parameters.toArray(new Parameter[0]));
    }

    private Parameter getBuiltinParam() {
        return new Parameter(this.getBuiltinOptions(), this.getBuiltinParams());
    }

    protected Map<String, String> getBuiltinOptions() {
        return Collections.emptyMap();
    }

    protected List<String> getBuiltinParams() {
        return Collections.emptyList();
    }

    public CommandReaction<Map<Node, Response>> operateCertificate(List<Node> nodes, Parameter ... params) {
        logger.info((Object)"opera cert.");
        return this.executeCommand(this.certificateReplaceCommand, nodes, params);
    }

    public CommandReaction<Map<Node, Response>> rollbackCertificate(List<Node> nodes, Parameter ... params) {
        logger.info((Object)"rollback cert.");
        return this.executeCommand(this.certificateRollbackCommand, nodes, params);
    }

    public CertificateOperateStatus submitCertificateUpdateTask(BlockingQueue queue, CertificateSummary summary, CertificateUpdateParam param, boolean independent, boolean onlyRegisterable) {
        String certName = param.getCert().getCertName();
        ICertificateHandler handler = this.getSystemCertificateService().getCertificateHandler(summary, onlyRegisterable);
        if (handler == null) {
            return CertificateOperateStatus.errorParam((String)("Not supported cert name: " + certName));
        }
        String cause = handler.validate(param);
        if (cause != null) {
            return CertificateOperateStatus.errorParam((String)cause);
        }
        logger.info((Object)("add update cert task for " + certName));
        CertificateUpdateTask task = new CertificateUpdateTask(this.getSystemCertificateService(), handler, param, independent);
        if (!queue.add(task)) {
            return CertificateOperateStatus.failed((String)("Fail to submit update task for cert " + task.getCertName()));
        }
        return CertificateOperateStatus.success();
    }
}

