/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.CertificateResolver;
import com.huawei.ism.drm.cert.handler.CertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;

public abstract class ServerCertificateHandler
extends CertificateHandler {
    protected static final String PASSWORD = "password";
    private static final Log logger = LogFactory.getInstance(ServerCertificateHandler.class);
    private String format;
    private CertificateResolver certificateResolver = new CertificateResolver();

    public ServerCertificateHandler(String format) {
        super("server");
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public CertificateResolver getCertificateResolver() {
        return this.certificateResolver;
    }

    public void setCertificateResolver(CertificateResolver certificateResolver) {
        this.certificateResolver = certificateResolver;
    }

    private static String getCertificateDescription(String component) {
        String zh = LegoConfig.getInstance().getKeyValue("cert." + component + ".description.zh");
        String en = LegoConfig.getInstance().getKeyValue("cert." + component + ".description.en");
        return zh + "##" + en;
    }

    @Override
    public boolean suitable(CertificateSummary certificate) {
        logger.info((Object)(certificate.getCertName() + " suitable: " + certificate.getCertFormat() + ", format: " + this.format));
        return super.suitable(certificate) && this.format.equalsIgnoreCase(certificate.getCertFormat());
    }

    public boolean fulfil(CertificateSummary summary) {
        if (!this.suitable(summary)) {
            logger.debug((Object)("Not support to fulfil summary: " + (String)Optional.ofNullable(summary).map(CertificateSummary::getCertName).orElse(null)));
            return false;
        }
        String component = summary.getComponentName();
        logger.info((Object)"fulfil certificate for certificate %s, component name is %s", new Object[]{summary.getCertName(), component});
        X509Certificate certificate = this.certificateResolver.resolveX509Certificate(component);
        if (certificate == null) {
            logger.info((Object)"fulfil certificate failed.");
            return false;
        }
        summary.setSubjectName(certificate.getSubjectX500Principal().getName());
        summary.setNotAfter(this.format(certificate.getNotAfter()));
        summary.setNotBefore(this.format(certificate.getNotBefore()));
        logger.info((Object)"fulfil certificate succeed.");
        return true;
    }

    private String format(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    @Override
    protected String validateCert(CertificateUpdateParam param) {
        return Optional.ofNullable(super.validateCert(param)).orElseGet(() -> this.validateCert(param.getCert()));
    }

    private String validateCert(CertificateContent cert) {
        if (VerifyUtil.isEmpty((String)cert.getPriKeyPwd())) {
            return "value of field 'cert.priKeyPwd' is not provided";
        }
        return null;
    }

    protected static String validateCertPriKey(CertificateContent cert) {
        if (VerifyUtil.isEmpty((String)cert.getPriKey())) {
            return "value of field 'cert.priKey' is not provided";
        }
        return null;
    }
}

