/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.cert.component.DependedCertificateService;
import com.huawei.ism.drm.cert.sdk.model.RevokedCertificate;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RevokCertificateTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(RevokCertificateTask.class);
    private RevokedCertificate revokedCertificate;
    private DependedCertificateService dependedCertificateService;
    private NodeAgentLocalService.Iface nodeAgentLocalService;

    public RevokCertificateTask(RevokedCertificate revokedCertificate, DependedCertificateService dependedCertificateService, NodeAgentLocalService.Iface nodeAgentLocalService) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)revokedCertificate.getSerialNumber(), (String)"ism.drm.cert.revoke", (String)"System", (String)"", null), true);
        this.revokedCertificate = revokedCertificate;
        this.dependedCertificateService = dependedCertificateService;
        this.nodeAgentLocalService = nodeAgentLocalService;
    }

    protected void doWork() throws LegoCheckedException {
        try {
            List nodeList = this.nodeAgentLocalService.getNodeList();
            HashMap<String, Set> resultMap = new HashMap<String, Set>();
            resultMap.put("successAlias", this.revokedCertificate.getAliasSet());
            Parameter param = new Parameter(new HashMap());
            param.getOpts().put("resultMap", JSONObject.fromObject(resultMap).toString());
            logger.info((Object)"start delete cert:%s", new Object[]{this.revokedCertificate.toString()});
            CommandReaction<Map<Node, Response>> commandReaction = this.dependedCertificateService.rollbackCertificate(nodeList, param);
            if (!commandReaction.success()) {
                logger.error((Object)"revoke cert:%s failed!", new Object[]{this.revokedCertificate.toString()});
                throw new LegoCheckedException(1073949721L, new String[]{this.revokedCertificate.getSerialNumber(), this.revokedCertificate.getCommonName(), String.valueOf(this.revokedCertificate.getAliasSet())});
            }
            logger.info((Object)"revoke cert:%s sucess!", new Object[]{this.revokedCertificate.toString()});
            this.getBackTask().setTaskDetail(String.valueOf(1073949722L));
            this.getBackTask().setTaskDetailParas(new String[]{this.revokedCertificate.getSerialNumber(), this.revokedCertificate.getCommonName(), String.valueOf(this.revokedCertificate.getAliasSet())});
        }
        catch (Exception e) {
            logger.error((Object)"revoke cert:%s error!", (Throwable)e, new Object[]{this.revokedCertificate.toString()});
            throw new LegoCheckedException(1073949721L, new String[]{this.revokedCertificate.getSerialNumber(), this.revokedCertificate.getCommonName(), String.valueOf(this.revokedCertificate.getAliasSet())});
        }
    }
}

