/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.service.impl.RecoveryManager;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.LocalRecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.MountReplicaBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Map;

@Service(Name="com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager", Desc="", Interface=ILocalRecoveryManager.class)
public class LocalRecoveryManager
extends RecoveryManager
implements ILocalRecoveryManager {
    private static final Log logger = LogFactory.getInstance(LocalRecoveryManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRollBackSnapshot(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            RecoveryPlan recoveryPlan = this.checkAndGetRecoveryPlan(recoveryPlanId, recoveryContext, operator);
            IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
            if (null == provider) {
                logger.debug((Object)"provider is null");
                return;
            }
            String executeTypeStr = recoveryContext.get("message_event_excute_type");
            DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E executeTypeE = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)Integer.parseInt(executeTypeStr));
            Map settings = provider.checkRecoveryContext(recoveryPlanId, executeTypeE, recoveryContext, operator);
            ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
            if (null != protectGroup && 11 == protectGroup.getPoType()) {
                settings.put("EXEC_LOCAL_SCRIPT_WHEN_LUN", "true");
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)executeTypeE.getValue()));
            settings.put("REPLICA_ID", recoveryContext.get("REPLICA_ID"));
            settings.put("ROLLBACK_RATE", recoveryContext.get("ROLLBACK_RATE"));
            if (executeTypeE == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.VM_ROLLBACK) {
                settings.put("selectedVmMoIdList", recoveryContext.get("selectedVmMoIdList"));
            }
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            RecoveryServiceUtil.checkRollBackOperationPrivilege(recoveryPlan);
            LocalRecoveryBackTask recoveryBackTask = new LocalRecoveryBackTask();
            this.submitRecoveryBackTask(recoveryBackTask, recoveryPlan, executeTypeE, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void startMountSnapshot(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Snapshot");
        LocalRecoveryBackTask task = new LocalRecoveryBackTask();
        this.mountOrTestReplica(task, recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
    }

    public void startUmountSnapshot(String recoveryPlanId, User operator) {
        LocalRecoveryBackTask task = new LocalRecoveryBackTask();
        this.internalUmountReplica(task, recoveryPlanId, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
    }

    public void mountReplica(String planId, Map<String, String> mountParameters, User operator) {
        this.prepareSuffixType(planId, mountParameters, "Replica");
        MountReplicaBackTask task = new MountReplicaBackTask();
        this.mountOrTestReplica(task, planId, mountParameters, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA);
    }

    public void umountReplica(String planId, User operator) {
        MountReplicaBackTask recoveryBackTask = new MountReplicaBackTask();
        this.internalUmountReplica(recoveryBackTask, planId, operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUmountReplica(IRecoveryBackTask recoveryBackTask, String recoveryPlanId, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E opType) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, operator);
            RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
            if (null == recoveryPlan) {
                throw new LegoCheckedException(201L);
            }
            this.checkIfProtectObjectExisted(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)opType.getValue()));
            this.submitRecoveryBackTask(recoveryBackTask, recoveryPlan, opType, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mountOrTestReplica(IRecoveryBackTask task, String planId, Map<String, String> mountParameters, User operator, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E opType) {
        this.checkRecoveryPlanExecuting(planId);
        try {
            IRecoveryProcessProvider provider;
            this.tryLockRecoveryPlan(planId);
            RecoveryPlan recoveryPlan = this.checkAndGetRecoveryPlan(planId, mountParameters, operator);
            HashSet recoverySettings = recoveryPlan.getRecoverySettings();
            if (null == recoverySettings) {
                recoverySettings = new HashSet();
                recoveryPlan.setRecoverySettings(recoverySettings);
            }
            if (null == (provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan))) {
                return;
            }
            Map settings = provider.checkRecoveryContext(planId, opType, mountParameters, operator);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RECOVERY_PLAN_STATUS_E)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE)DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)opType.getValue()));
            settings.put("REPLICA_ID", mountParameters.get("REPLICA_ID"));
            settings.put("volumeType", mountParameters.get("volumeType"));
            recoveryPlan.getGlobalSettings().put("PG_DISASTER_HOST", VerifyUtil.isEmpty((String)mountParameters.get("PG_DISASTER_HOST")) ? "" : mountParameters.get("PG_DISASTER_HOST"));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
            String replicaId = mountParameters.get("REPLICA_ID");
            ProtectGroupReplica replica = service.queryProtectGroupReplicaById(replicaId);
            ILicenseControl licenseController = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseController.checkEnablePgCount(replica.getPg());
            this.submitRecoveryBackTask(task, recoveryPlan, opType, operator, mountParameters);
        }
        finally {
            this.unLockRecoveryPlan(planId);
        }
    }

    private RecoveryPlan checkAndGetRecoveryPlan(String planId, Map<String, String> mountParameters, User operator) {
        this.checkParameters(planId, operator);
        this.checkReplicaParameter(mountParameters);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, true, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    private void checkReplicaParameter(Map<String, String> parameter) {
        if (VerifyUtil.isEmpty(parameter)) {
            logger.error((Object)"Invalid parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkReplicaId(parameter.get("REPLICA_ID"));
    }

    private void checkReplicaId(String replicaId) {
        if (VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"Invalid parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private synchronized void submitRecoveryBackTask(IRecoveryBackTask recoveryBackTask, RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E recoveryPlanExecuteType, User operator, Map<String, String> recoveryContext) {
        this.getRecoveryPlanService().checkBackendRecoveryTaskCount();
        Map<String, Object> initialContextData = this.getInitialContextData(recoveryPlan, null);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        RecoveryProcessDefinition rpDefinition = this.getRecoveryProcessDef(recoveryPlan, recoveryPlanExecuteType);
        initialContextData.put("RecoveryProcessDefinition", rpDefinition);
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(recoveryPlan);
        recoveryBackTask.setRecoveryPlanExecuteType(recoveryPlanExecuteType);
        recoveryBackTask.setOperator(operator);
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, recoveryPlanExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate((IProcessor)recoveryTemplate);
        Map<String, Object> preProcessResults = RecoveryPreProcessorManager.getInstance().process(recoveryPlan, recoveryPlanExecuteType);
        recoveryBackTask.setPreProcessResults(preProcessResults);
        this.updateRecoveryTaskCallback(recoveryPlan, recoveryPlanExecuteType, recoveryBackTask);
        RecoveryBackTaskExecutor.submitRecoveryBackTask(recoveryBackTask);
    }

    private void updateRecoveryTaskCallback(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E recoveryPlanExecuteType, IRecoveryBackTask recoveryBackTask) {
        RecoveryBackTask tmpRecoveryBackTask = (RecoveryBackTask)recoveryBackTask;
        if (VerifyUtil.isEmpty((Object)tmpRecoveryBackTask.getCallBaskTask())) {
            DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(recoveryPlan);
            IRecoveryProcessProvider recoveryProcessProvider = RecoveryProcessorMgr.getInstance().getRecoveryProcessProvider(appType.name());
            ICallBackExcuteRecoveryTask callBackTask = recoveryProcessProvider.getRecoveryCallbackTask(recoveryPlanExecuteType);
            tmpRecoveryBackTask.setCallBaskTask(callBackTask);
            logger.info((Object)"update callback task of recovery task: appName=%s", new Object[]{appType.name()});
        }
    }
}

