/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.service.impl.AbstractRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryProcessorDetailComparator;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public abstract class RecoveryPlanQueryServiceImpl
extends AbstractRecoveryPlanService {
    private static Log logger = LogFactory.getInstance(RecoveryPlanQueryServiceImpl.class);
    private static final String QUERY_PLAN_SQL = "select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME from ti_recoveryplan rp ";
    private static final List<String> RECOVERYPLAN_COLUME = new ArrayList<String>();

    public Map<String, Object> getDrillingStatisticsInfo(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.queryRecoveryPlanWithoutAssociatedData(recoveryPlanId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        long lastReprotectEndTime = this.filterLastReprotectEndTime(recoveryPlanId);
        int successCount = 0;
        int failCount = 0;
        List<RecoveryLog> drillingHistLogs = this.getHistoryLogsByPlanId(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING, null, null, null);
        if (!VerifyUtil.isEmpty(drillingHistLogs)) {
            for (RecoveryLog drillingLog : drillingHistLogs) {
                long startTime = Long.parseLong(drillingLog.getStartTime());
                if (lastReprotectEndTime >= startTime) continue;
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == drillingLog.getLogStatus()) {
                    ++successCount;
                    continue;
                }
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() != drillingLog.getLogStatus() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() != drillingLog.getLogStatus()) continue;
                ++failCount;
            }
        }
        HashMap<String, Object> statisticsInfo = new HashMap<String, Object>();
        statisticsInfo.put("failCount", failCount);
        statisticsInfo.put("successCount", successCount);
        statisticsInfo.put("totalCount", failCount + successCount);
        return statisticsInfo;
    }

    public List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByPlanId(String recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E executeType) {
        if (null == recoveryPlanId || null == executeType) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(recoveryPlanId, false);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcessorDetailsByExecType(recoveryPlan, executeType);
    }

    public List<RecoveryLog> getHistoryReocveryLogsByPlanId(String recoveryPlanId) {
        if (null == recoveryPlanId) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(recoveryPlanId);
        if (!isExisted) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        return this.getHistoryLogsByPlanId(recoveryPlanId, null, null, null, null);
    }

    public List<RecoveryLog> getHistoryRecoveryLogsByPlanIdAndTypeAndResult(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, String recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E status, String proSiteId, String recoverySiteId) {
        if (null == recoveryPlanId) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getHistoryLogsByPlanId(recoveryPlanId, type, status, proSiteId, recoverySiteId);
    }

    public List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByLogId(String recoveryPlanId, String recoveryLogId) {
        if (null == recoveryLogId) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(recoveryPlanId, false);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. logId:" + recoveryLogId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcessorDetailsByLogId(recoveryPlan, recoveryLogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan queryRecoveryPlan(String planId, boolean isQueryPo) {
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery("select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME from ti_recoveryplan rp  where rp.planid=:planId");
            query.setString("planId", planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlan = this.constructRecoveryPlans(results).get(0);
                Map<String, String> globalSettings = this.getRecoveryGlobalSettings(planId);
                recoveryPlan.setGlobalSettings(globalSettings);
                Set<RecoverySetting> recoverySettings = this.getRecoverySettingsBy(planId);
                recoveryPlan.setRecoverySettings(recoverySettings);
                for (RecoverySetting setting : recoverySettings) {
                    setting.setRecoveryPlan(recoveryPlan);
                }
                Set<ProtectGroup> protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPo);
                recoveryPlan.setProtectGroups(protectGroups);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery plan failed. Id:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page pageQueryRecoveryLog(int pageNum, int pageSize, Long userId) {
        List<Object> recoveryLogs = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select rl.LOGID, rl.LOGSTATUS, rl.LOGTYPE, rl.LOGNAME, rl.OPERATOR, rl.STARTTIME, rl.ENDTIME, rl.ISSYNCHRONIZED, rl.PRODUCTIONSITEID, rl.RECOVERYSITEID, rl.PLANID from TI_RECOVERYPLAN rp inner join TI_RECOVERYLOG rl on rl.PLANID=rp.PLANID  where rp.PLANSTATUS<>:rpStatus and rl.STARTTIME=(select MAX(STARTTIME) from TI_RECOVERYLOG  where PLANID=rp.PLANID) order by rl.STARTTIME desc ";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setInteger("rpStatus", DrmEnumDefine.RECOVERY_PLAN_STATUS_E.INVALID.getValue());
            List list = query.list();
            if (!VerifyUtil.isEmpty((Collection)list)) {
                recoveryLogs = this.constructRecoveryLogs(list);
            }
        }
        catch (Exception e) {
            logger.error((Object)("pageQueryRecoveryLog failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        ArrayList filterLogs = new ArrayList();
        filterLogs.addAll(recoveryLogs);
        if (!VerifyUtil.isEmpty(recoveryLogs)) {
            for (RecoveryLog recoveryLog : recoveryLogs) {
                try {
                    ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).checkUserGrantedObject(userId, recoveryLog.getPlanId());
                }
                catch (Exception e) {
                    filterLogs.remove(recoveryLog);
                }
            }
        }
        return Page.createPage((int)pageNum, (int)pageSize, filterLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryPlan> queryRecoveryPlans(long userId, boolean isQueryPo) {
        List<Object> recoveryPlans = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery(QUERY_PLAN_SQL);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlans = this.constructRecoveryPlans(results);
                for (RecoveryPlan recoveryPlan : recoveryPlans) {
                    Map<String, String> globalSettings = this.getRecoveryGlobalSettings(recoveryPlan.getPlanId());
                    recoveryPlan.setGlobalSettings(globalSettings);
                    Set<RecoverySetting> recoverySettings = this.getRecoverySettingsBy(recoveryPlan.getPlanId());
                    recoveryPlan.setRecoverySettings(recoverySettings);
                    for (RecoverySetting setting : recoverySettings) {
                        setting.setRecoveryPlan(recoveryPlan);
                    }
                    Set<ProtectGroup> protectGroups = this.getProtectGroupsByPlanId(recoveryPlan.getPlanId(), session, isQueryPo);
                    recoveryPlan.setProtectGroups(protectGroups);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery plans failed. Id:" + userId + ",isQueryPo:" + isQueryPo + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        if (!VerifyUtil.isEmpty(recoveryPlans)) {
            recoveryPlans = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userId), recoveryPlans);
        }
        return recoveryPlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<RecoverySetting> getRecoverySettingsBy(String planId) {
        Set<RecoverySetting> settings = new HashSet<RecoverySetting>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select settingid, planid, disastersiteid, ownerid, name, value from ti_recoverysetting where planid=:planid";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("planid", planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                settings = this.constructRecoverySettings(results);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting recovery settings failed. Id:" + planId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getRecoveryGlobalSettings(String planId) {
        Map<String, String> settings = new HashMap<String, String>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select planid, propname, propvalue from ti_rp_globalsettings where planid=:planid";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("planid", planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                settings = this.constructRecoveryGlobalSettings(results);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting recovery global settings failed. Id:" + planId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan queryRecoveryPlanWithoutAssociatedData(String planId) {
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery("select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME from ti_recoveryplan rp  where rp.planid=:planId");
            query.setString("planId", planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlan = this.constructRecoveryPlans(results).get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery plan failed. Id:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    public String getLatestRecoveryLogIdBy(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        String queryHQL = "select rl.LOGID from ti_recoverylog rl where rl.PLANID = ? order by rl.STARTTIME desc";
        List recoveryLogs = this.getBaseDao().executeNativeSql(queryHQL, new Object[]{recoveryPlanId});
        String logId = "";
        if (null != recoveryLogs && !recoveryLogs.isEmpty()) {
            logId = (String)recoveryLogs.get(0);
        } else {
            logger.error((Object)("The logId is null: " + recoveryPlanId));
        }
        return logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryPlan> getRecoveryPlans(String orderBy, boolean isAsc, Map<String, Object> extFilterMap) {
        List<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            StringBuilder strSQLBuilder = new StringBuilder();
            strSQLBuilder.append(QUERY_PLAN_SQL);
            List<QueryCondition> conditions = this.getRecoveryPlanCondition(extFilterMap);
            if (!VerifyUtil.isEmpty(extFilterMap)) {
                strSQLBuilder.append("where ");
                strSQLBuilder.append(this.constructRpPageQuerySQL(conditions));
            }
            if ("name".equalsIgnoreCase(orderBy)) {
                strSQLBuilder.append(" order by planname ");
            } else if ("planstatus".equalsIgnoreCase(orderBy)) {
                strSQLBuilder.append(" order by planstatus ");
            }
            strSQLBuilder.append(isAsc ? "asc" : "desc");
            NativeQuery query = session.createSQLQuery(strSQLBuilder.toString());
            this.setQuery(conditions, (Query)query);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlans = this.constructRecoveryPlans(results);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plans failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ProtectGroup> getProtectGroupsByPlanId(String planId, boolean isQueryPos) {
        HashSet<ProtectGroup> protectGroups = new HashSet();
        Session session = null;
        try {
            session = this.getHibernateSession();
            protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPos);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getProtectGroupsByPlanId failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return protectGroups;
    }

    protected List<ProtectGroup> constructProtectGroups(List<?> result) {
        ArrayList<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 14 != (values = (Object[])object).length) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(CommUtil.convertToString((Object)values[1]));
            protectGroup.setProductSiteId(CommUtil.convertToString((Object)values[2]));
            protectGroup.setProductSiteName(CommUtil.convertToString((Object)values[3]));
            protectGroup.setName(CommUtil.convertToString((Object)values[4]));
            protectGroup.setPoType(CommUtil.convertToInteger((Object)values[5]).intValue());
            protectGroup.setPoProviderSN(CommUtil.convertToString((Object)values[13]));
            PolicyTemplate template = new PolicyTemplate();
            Integer templateType = CommUtil.convertToInteger((Object)values[6]);
            Integer templateSubType = CommUtil.convertToInteger((Object)values[7]);
            template.setType(templateType.intValue());
            template.setSubType((0 >= templateSubType ? templateType : templateSubType).intValue());
            template.setUuid(String.valueOf(values[10]));
            template.setName(String.valueOf(values[11]));
            template.setDescription(String.valueOf(values[12]));
            protectGroup.setTemplate(template);
            protectGroup.setPrimary(CommUtil.convertToBoolean((Object)values[8]).booleanValue());
            protectGroup.setStatus(NumberUtil.convertToInteger((Object)String.valueOf(values[9])).intValue());
            protectGroups.add(protectGroup);
        }
        return protectGroups;
    }

    protected List<RecoveryPlan> constructRecoveryPlans(List<?> result) {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 11 != (values = (Object[])object).length) continue;
            RecoveryPlan recoveryPlan = new RecoveryPlan();
            recoveryPlan.setPlanId(CommUtil.convertToString((Object)values[0]));
            recoveryPlan.setUuid(CommUtil.convertToString((Object)values[1]));
            recoveryPlan.setName(CommUtil.convertToString((Object)values[2]));
            recoveryPlan.setDescription(CommUtil.convertToString((Object)values[3]));
            recoveryPlan.setPlanStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            recoveryPlan.setPlanProgress(CommUtil.convertToInteger((Object)values[5]).intValue());
            recoveryPlan.setPlanType(CommUtil.convertToInteger((Object)values[6]).intValue());
            recoveryPlan.setLastTestStatus(CommUtil.convertToInteger((Object)values[7]).intValue());
            recoveryPlan.setProcessStatus(CommUtil.convertToInteger((Object)values[8]).intValue());
            recoveryPlan.setUse(CommUtil.convertToInteger((Object)values[9]));
            recoveryPlan.setCreateTime(CommUtil.convertToLong((Object)values[10]));
            recoveryPlans.add(recoveryPlan);
        }
        return recoveryPlans;
    }

    protected Set<RecoverySetting> constructRecoverySettings(List<?> result) {
        HashSet<RecoverySetting> recoverySettings = new HashSet<RecoverySetting>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 6 != (values = (Object[])object).length) continue;
            RecoverySetting recoverySetting = new RecoverySetting();
            recoverySetting.setSettingId(CommUtil.convertToString((Object)values[0]));
            recoverySetting.setPlanId(CommUtil.convertToString((Object)values[1]));
            recoverySetting.setDisasterSiteId(CommUtil.convertToString((Object)values[2]));
            recoverySetting.setOwnerId(CommUtil.convertToString((Object)values[3]));
            recoverySetting.setName(CommUtil.convertToString((Object)values[4]));
            recoverySetting.setValue(CommUtil.convertToString((Object)values[5]));
            recoverySettings.add(recoverySetting);
        }
        return recoverySettings;
    }

    protected Map<String, String> constructRecoveryGlobalSettings(List<?> result) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 3 != (values = (Object[])object).length) continue;
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            settings.put(propName, propValue);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryProcessorDetail> getDetailsByLogId(String recoveryLogId) {
        if (null == recoveryLogId) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<RecoveryProcessorDetail> details = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoveryProcessorDetail rpd where rpd.parentDetailId=null and rpd.logId=:logId order by rpd.startTime asc";
            Query query = session.createQuery(queryHQL);
            query.setString("logId", recoveryLogId);
            details = query.list();
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process details failed. Id:" + recoveryLogId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryProcessorDetail> queryDetailsByLogId(String recoveryLogId) {
        if (null == recoveryLogId) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select DETAILID,STARTTIME,ENDTIME,PROCESSNAME,PROCESSNAMEPARAMS,PROCESSDETAIL,PROCESSDETAILPARAMS,PROCESSSTATUS,PROCID,LOGID,RELATEDDETAILID,PREVIOUSPROCID,NEXTPROCID,ISSKIPPED from ti_recoveryprocessordetail where logId=:logId";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("logId", recoveryLogId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                Set<RecoveryProcessorDetail> allDetails = this.constructRecoveryProcessorDetails(results);
                details = this.groupRecoveryLogDetails(allDetails);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process details failed. Id:" + recoveryLogId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return details;
    }

    protected Set<RecoveryProcessorDetail> constructRecoveryProcessorDetails(List<?> results) {
        HashSet<RecoveryProcessorDetail> logDetails = new HashSet<RecoveryProcessorDetail>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 14 != (values = (Object[])object).length) continue;
            RecoveryProcessorDetail logDetail = new RecoveryProcessorDetail();
            logDetail.setDetailId(CommUtil.convertToString((Object)values[0]));
            logDetail.setStartTime(CommUtil.convertToString((Object)values[1]));
            logDetail.setEndTime(CommUtil.convertToString((Object)values[2]));
            logDetail.setProcessName(CommUtil.convertToString((Object)values[3]));
            logDetail.setProcessNameParams(CommUtil.convertToString((Object)values[4]));
            logDetail.setProcessDetail(CommUtil.convertToString((Object)values[5]));
            logDetail.setProcessDetailParams(CommUtil.convertToString((Object)values[6]));
            logDetail.setProcessStatus(CommUtil.convertToInteger((Object)values[7]).intValue());
            logDetail.setProcId(CommUtil.convertToString((Object)values[8]));
            logDetail.setLogId(CommUtil.convertToString((Object)values[9]));
            logDetail.setParentDetailId(CommUtil.convertToString((Object)values[10]));
            logDetail.setPreviousProcId(CommUtil.convertToString((Object)values[11]));
            logDetail.setNextProcId(CommUtil.convertToString((Object)values[12]));
            logDetail.setIsSkipped(CommUtil.convertToBoolean((Object)values[13]));
            logDetails.add(logDetail);
        }
        return logDetails;
    }

    private List<QueryCondition> getRecoveryPlanCondition(Map<String, Object> extFilterMap) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        for (Map.Entry<String, Object> extFilter : extFilterMap.entrySet()) {
            String key = extFilter.getKey();
            Object val = extFilter.getValue();
            if (RECOVERYPLAN_COLUME.stream().anyMatch(col -> col.equalsIgnoreCase(key))) {
                conditions.add(new QueryCondition(key, val));
            }
            if (!"name".equals(key)) continue;
            conditions.add(new QueryCondition(key, val));
        }
        return conditions;
    }

    private List<RecoveryProcessorDetail> extendUnRunningProcessDetail(RecoveryPlan recoveryPlan, List<RecoveryProcessorDetail> details, int procType) {
        Set<RecoveryProcessDefinition> processes = this.getRecoveryProcessesWithSQL(recoveryPlan.getPlanId(), procType);
        RecoveryProcessDefinition rpDefinition = null;
        Iterator<RecoveryProcessDefinition> iterator = processes.iterator();
        rpDefinition = iterator.hasNext() ? iterator.next() : RecoveryServiceUtil.getInitRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)procType));
        Set processors = rpDefinition.getRecoveryProcessors();
        List<RecoveryProcessor> sortedProcesses = RecoveryServiceUtil.sortRecoveryProcessors(processors);
        if (VerifyUtil.isEmpty(details)) {
            return this.generateSortedProcessorDetails(sortedProcesses);
        }
        return this.getSortedProcessorDetails(details, sortedProcesses);
    }

    private List<RecoveryProcessorDetail> generateSortedProcessorDetails(List<RecoveryProcessor> sortedProcesses) {
        ArrayList<RecoveryProcessorDetail> newDetails = new ArrayList<RecoveryProcessorDetail>();
        for (RecoveryProcessor processor : sortedProcesses) {
            if (!processor.getIsEnabled().booleanValue()) continue;
            RecoveryProcessorDetail newDetail = this.createRecoveryProcessorDetail(processor);
            newDetails.add(newDetail);
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc()) || !(processor instanceof IInitialChildProcessor)) continue;
            List<RecoveryProcessorDetail> childDetails = RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc()).stream().map(subRecoveryProcessor -> this.createRecoveryProcessorDetail((RecoveryProcessor)subRecoveryProcessor)).collect(Collectors.toList());
            childDetails.forEach(subDetail -> subDetail.setParentDetailId(newDetail.getDetailId()));
            newDetail.setChildDetails(childDetails);
        }
        return newDetails;
    }

    private List<RecoveryProcessorDetail> getSortedProcessorDetails(List<RecoveryProcessorDetail> details, List<RecoveryProcessor> sortedProcesses) {
        List<RecoveryProcessorDetail> sortedDetails = RecoveryServiceUtil.sortRecoveryProcessorDetails(details);
        this.setChildDetails(sortedProcesses, sortedDetails);
        if (VerifyUtil.isEmpty(sortedDetails)) {
            return sortedDetails;
        }
        RecoveryProcessorDetail lastDetail = sortedDetails.get(sortedDetails.size() - 1);
        if (VerifyUtil.isEmpty((String)lastDetail.getNextProcId())) {
            return sortedDetails;
        }
        RecoveryProcessor matchedProcessor = null;
        for (RecoveryProcessor processor : sortedProcesses) {
            if (!processor.getProcId().equals(lastDetail.getNextProcId())) continue;
            matchedProcessor = processor;
        }
        while (null != matchedProcessor) {
            if (matchedProcessor.getIsEnabled().booleanValue()) {
                RecoveryProcessorDetail newDetail = this.createRecoveryProcessorDetail(matchedProcessor);
                sortedDetails.add(newDetail);
            }
            matchedProcessor = matchedProcessor.getNextProcessor();
        }
        return sortedDetails;
    }

    private void setChildDetails(List<RecoveryProcessor> sortedProcesses, List<RecoveryProcessorDetail> sortedDetails) {
        if (VerifyUtil.isEmpty(sortedProcesses) || VerifyUtil.isEmpty(sortedDetails)) {
            return;
        }
        for (RecoveryProcessorDetail detail : sortedDetails) {
            for (RecoveryProcessor processor : sortedProcesses) {
                if (!(processor instanceof IInitialChildProcessor) || null == detail.getProcId() || !detail.getProcId().equals(processor.getProcId())) continue;
                List<RecoveryProcessorDetail> newChilds = this.getSortedProcessorDetails(detail.getChildDetails(), RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc()));
                newChilds.forEach(child -> child.setParentDetailId(detail.getDetailId()));
                detail.setChildDetails(newChilds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RecoveryProcessDefinition> getRecoveryProcessesWithSQL(String recoveryPlanId, int procType) {
        Set<RecoveryProcessDefinition> processes;
        Session session = null;
        try {
            session = this.getHibernateSession();
            processes = this.getRecoveryProcessesWithSQL(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)procType), session);
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process failed. PlanId:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            processes = new HashSet<RecoveryProcessDefinition>();
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return processes;
    }

    private Set<RecoveryProcessDefinition> getRecoveryProcessesWithSQL(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, Session session) {
        List results;
        HashSet<RecoveryProcessDefinition> processes = new HashSet<RecoveryProcessDefinition>();
        if (null == planId || null == session) {
            return processes;
        }
        String querySQL = "select PROCESSID,PROCTYPE,APPTYPE,PROTECTIONTYPE,PLANID,DISASTERSITEID from ti_recoveryprocessdefinition where PLANID=:planId";
        if (null != type) {
            querySQL = querySQL + " and PROCTYPE=:procType";
        }
        NativeQuery query = session.createSQLQuery(querySQL);
        query.setString("planId", planId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (VerifyUtil.isEmpty((Collection)(results = query.list()))) {
            return processes;
        }
        ProtectGroup protectGroup = this.getProtectGroupByRecoveryPlan(planId);
        Set<RecoveryProcessDefinition> recoveryProcesses = this.constructRecoveryProcessDefinitions(results);
        for (RecoveryProcessDefinition rpDefinition : recoveryProcesses) {
            Set<RecoveryProcessor> recoveryProcessors = this.getRecoveryProcessorsWithSQL(rpDefinition.getProcessId(), type, session);
            for (RecoveryProcessor processor : recoveryProcessors) {
                processor.resetEnableStatus(protectGroup, type);
            }
            rpDefinition.setRecoveryProcessors(recoveryProcessors);
            processes.add(rpDefinition);
        }
        return processes;
    }

    private ProtectGroup getProtectGroupByRecoveryPlan(String planId) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            logger.error((Object)"pgIterator hasNext failed.PlanId:%s", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        Iterator pgIterator = recoveryPlan.getProtectGroups().iterator();
        if (!pgIterator.hasNext()) {
            logger.error((Object)"pgIterator hasNext failed.PlanId:%s", new Object[]{planId});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)pgIterator.next();
        if (null == protectGroup) {
            logger.error((Object)"The protectGroup does not exist.PlanId: %s", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        return protectGroup;
    }

    private Set<RecoveryProcessor> getRecoveryProcessorsWithSQL(String processId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, Session session) {
        List results;
        Set<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (null == processId || null == session) {
            return processors;
        }
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select discriminator,PROCID,PROCNAME,PROCTYPE,PROCSTATUS,STARTTIME,ENDTIME,ISENABLE,");
        querySQL.append("ISEDITABLE,ISPRESET,PROCESSID,PARENTPROCID,PREPROCID,NEXTPROCID,NEXTCASCADEPROCID,PLANID ");
        querySQL.append("from ti_recoveryprocessor where PROCESSID=:processId");
        if (null != type) {
            querySQL.append(" and PROCTYPE=:procType");
        }
        NativeQuery query = session.createSQLQuery(querySQL.toString());
        query.setString("processId", processId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (null != (results = query.list()) && !results.isEmpty()) {
            Set<RecoveryProcessor> recoveryProcessors = this.constructRecoveryProcessors(results);
            processors = this.groupRecoveryProcessors(recoveryProcessors);
        }
        return processors;
    }

    private RecoveryProcessor createRecoveryProcessor(String className, String discriminator) {
        RecoveryProcessor processor = null;
        try {
            ClassLoader clsLoader = DrmObjectSerializableUtil.getGlobalClassLoader();
            if (!VerifyUtil.isEmpty((String)className)) {
                processor = (RecoveryProcessor)Class.forName(className, true, clsLoader).newInstance();
            } else {
                processor = new RecoveryProcessor();
                logger.warn((Object)("The className is null. discriminator:" + discriminator), 90160758784000L);
            }
        }
        catch (Exception e) {
            processor = new RecoveryProcessor();
        }
        return processor;
    }

    private Set<RecoveryProcessor> constructRecoveryProcessors(List<?> results) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 16 != (values = (Object[])object).length) continue;
            String discriminator = CommUtil.convertToString((Object)values[0]);
            String className = CommUtil.convertToString((Object)values[2]);
            RecoveryProcessor processor = this.createRecoveryProcessor(className, discriminator);
            processor.setProcId(CommUtil.convertToString((Object)values[1]));
            processor.setProcName(CommUtil.convertToString((Object)values[2]));
            processor.setProcType(CommUtil.convertToInteger((Object)values[3]).intValue());
            processor.setProcStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            processor.setStartTime(CommUtil.convertToString((Object)values[5]));
            processor.setEndTime(CommUtil.convertToString((Object)values[6]));
            processor.setIsEnabled(CommUtil.convertToBoolean((Object)values[7]));
            processor.setIsEditable(CommUtil.convertToBoolean((Object)values[8]));
            processor.setIsPreset(CommUtil.convertToBoolean((Object)values[9]));
            processor.setProcessId(CommUtil.convertToString((Object)values[10]));
            processor.setParentProcId(CommUtil.convertToString((Object)values[11]));
            processor.setPreProcId(CommUtil.convertToString((Object)values[12]));
            processor.setNextProcId(CommUtil.convertToString((Object)values[13]));
            processor.setNextCascadeProcId(CommUtil.convertToString((Object)values[14]));
            processor.setPlanId(CommUtil.convertToString((Object)values[15]));
            processors.add(processor);
        }
        return processors;
    }

    private Set<RecoveryProcessor> groupRecoveryProcessors(Set<RecoveryProcessor> recoveryProcessors) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (VerifyUtil.isEmpty(recoveryProcessors)) {
            return processors;
        }
        HashMap<String, RecoveryProcessor> processorsMap = new HashMap<String, RecoveryProcessor>();
        HashMap groupProcessors = new HashMap();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            processorsMap.put(recoveryProcessor.getProcId(), recoveryProcessor);
            HashSet subProcessors = (HashSet)groupProcessors.get(recoveryProcessor.getProcId());
            if (null == subProcessors) {
                subProcessors = new HashSet();
                groupProcessors.put(recoveryProcessor.getProcId(), subProcessors);
            }
            recoveryProcessor.setChildProc((Set)subProcessors);
            if (VerifyUtil.isEmpty((String)recoveryProcessor.getParentProcId())) {
                processors.add(recoveryProcessor);
                continue;
            }
            HashSet<RecoveryProcessor> parentSubProcessors = (HashSet<RecoveryProcessor>)groupProcessors.get(recoveryProcessor.getParentProcId());
            if (null == parentSubProcessors) {
                parentSubProcessors = new HashSet<RecoveryProcessor>();
                groupProcessors.put(recoveryProcessor.getParentProcId(), parentSubProcessors);
            }
            parentSubProcessors.add(recoveryProcessor);
        }
        this.resetRecoveryProcessors(processors, processorsMap);
        return processors;
    }

    private void resetRecoveryProcessors(Set<RecoveryProcessor> processors, Map<String, RecoveryProcessor> rpProcessorsMap) {
        if (VerifyUtil.isEmpty(processors)) {
            return;
        }
        for (RecoveryProcessor processor : processors) {
            processor.setParentProc(rpProcessorsMap.get(processor.getParentProcId()));
            processor.setPreviousProcessor(rpProcessorsMap.get(processor.getPreProcId()));
            processor.setNextProcessor(rpProcessorsMap.get(processor.getNextProcId()));
            processor.setNextCascadeProcessor(rpProcessorsMap.get(processor.getNextCascadeProcId()));
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc())) continue;
            this.resetRecoveryProcessors(processor.getChildProc(), rpProcessorsMap);
        }
    }

    private List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByExecType(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E executeType) {
        List<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        String recoveryPlanId = recoveryPlan.getPlanId();
        RecoveryLog recoveryLog = this.getLatestRecoveryLog(recoveryPlanId);
        if (null != recoveryLog && recoveryLog.getLogType() == executeType.getValue()) {
            details = this.getRecoveryProcessorDetailsByLogId(recoveryPlan, recoveryLog.getLogId());
        }
        return this.extendUnRunningProcessDetail(recoveryPlan, details, executeType.getValue());
    }

    private RecoveryProcessorDetail createRecoveryProcessorDetail(RecoveryProcessor process) {
        process.updateProcessName();
        RecoveryProcessorDetail newDetail = new RecoveryProcessorDetail();
        newDetail.setDetailId(UUIDGenerator.getUUID());
        newDetail.setProcessName(process.getProcName());
        newDetail.setProcessStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        newDetail.setProcId(process.getProcId());
        return newDetail;
    }

    private List<String> getProtectGroupIdsByPlanId(String planId, Session session) {
        ArrayList<String> protectGroupIds = new ArrayList<String>();
        String strSQL = "select PGID from ti_drp_r_pg where PLANID=:planId";
        NativeQuery query = session.createSQLQuery(strSQL);
        query.setString("planId", planId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results) && 1 == results.size()) {
            protectGroupIds.add(String.valueOf(results.get(0)));
        } else {
            logger.error((Object)"Can not find protectgroup for planID: %s", new Object[]{planId});
        }
        return protectGroupIds;
    }

    private Set<ProtectGroup> getProtectGroupsByPlanId(String planId, Session session, boolean isQueryPos) {
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        List<String> protectGroupIds = this.getProtectGroupIdsByPlanId(planId, session);
        String querySQL = "select pg.PGID, pg.UUID as PGUUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pt.UUID as PTUUID, pt.NAME, pt.DESCRIPTION, pg.PGPROVIDERSN from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId and pg.PGID=:pgId";
        NativeQuery query = session.createSQLQuery(querySQL);
        for (String protectGroupId : protectGroupIds) {
            query.setString("pgId", protectGroupId);
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) continue;
            List<ProtectGroup> pgs = this.constructProtectGroups(results);
            for (ProtectGroup protectGroup : pgs) {
                Set<ProtectGroupReplica> pgReplicas = this.getProtectGroupReplicas(protectGroup.getUuid(), session);
                protectGroup.setReplicaList(pgReplicas);
                protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
                if (isQueryPos) {
                    Set<ProtectObject> protectObjects = this.getProtectObjects(protectGroup.getUuid(), session);
                    protectGroup.setPolist(protectObjects);
                }
                protectGroups.add(protectGroup);
            }
        }
        return protectGroups;
    }

    protected Set<ProtectGroupReplica> constructProtectGroupReplicas(List<?> result) {
        HashSet<ProtectGroupReplica> pgReplicas = new HashSet<ProtectGroupReplica>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 8 != (values = (Object[])object).length) continue;
            ProtectGroupReplica pgReplica = new ProtectGroupReplica();
            pgReplica.setId(CommUtil.convertToString((Object)values[0]));
            pgReplica.setName(CommUtil.convertToString((Object)values[1]));
            pgReplica.setType(CommUtil.convertToInteger((Object)values[2]).intValue());
            pgReplica.setStatus(CommUtil.convertToInteger((Object)values[3]).intValue());
            pgReplica.setRecoverySite(CommUtil.convertToString((Object)values[4]));
            pgReplica.setProductArray(CommUtil.convertToString((Object)values[5]));
            pgReplica.setRecoveryArray(CommUtil.convertToString((Object)values[6]));
            pgReplica.setProtectLocation(CommUtil.convertToInteger((Object)values[7]).intValue());
            pgReplicas.add(pgReplica);
        }
        return pgReplicas;
    }

    private String constructRpPageQuerySQL(List<QueryCondition> conditions) {
        if (VerifyUtil.isEmpty(conditions)) {
            return "";
        }
        StringBuilder strSQLBuilder = new StringBuilder();
        int count = 0;
        for (QueryCondition condition : conditions) {
            if (condition.getPropName().equalsIgnoreCase("name")) {
                strSQLBuilder.append("planname ilike :" + condition.getPropName());
            } else {
                if (!RECOVERYPLAN_COLUME.stream().anyMatch(col -> col.equalsIgnoreCase(condition.getPropName()))) continue;
                strSQLBuilder.append(condition.getPropName() + "= :" + condition.getPropName());
            }
            if (++count >= conditions.size()) continue;
            strSQLBuilder.append(" and ");
        }
        return strSQLBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RecoveryLog> getHistoryLogsByPlanId(String recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E status, String productionSiteId, String recoverySiteId) {
        List<Object> recoveryLogs = new ArrayList<RecoveryLog>();
        StringBuffer queryHQL = this.getHistoryLogQueryString(recoveryPlanId, type, status, productionSiteId, recoverySiteId);
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHQL.toString());
            if (null != recoveryPlanId) {
                query.setString("planId", recoveryPlanId);
            }
            if (null != type) {
                query.setInteger("logType", type.getValue());
            }
            if (null != status) {
                query.setInteger("logStatus", status.getValue());
            }
            if (null != productionSiteId) {
                query.setString("productionSiteId", productionSiteId);
            }
            if (null != recoverySiteId) {
                query.setString("recoverySiteId", recoverySiteId);
            }
            recoveryLogs = query.list();
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery logs failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLogs;
    }

    private StringBuffer getHistoryLogQueryString(String recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E status, String productionSiteId, String recoverySiteId) {
        StringBuffer queryHQL = new StringBuffer();
        queryHQL.append("from RecoveryLog rl where rl.endTime!=null ");
        if (null != recoveryPlanId) {
            queryHQL.append("and rl.planId=:planId ");
        }
        if (null != type) {
            queryHQL.append("and rl.logType=:logType ");
        }
        if (null != status) {
            queryHQL.append("and rl.logStatus<>:logStatus ");
        }
        if (null != productionSiteId) {
            queryHQL.append("and rl.productionSiteId=:productionSiteId ");
        }
        if (null != recoverySiteId) {
            queryHQL.append("and rl.recoverySiteId=:recoverySiteId ");
        }
        queryHQL.append("order by rl.endTime desc");
        return queryHQL;
    }

    private List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByLogId(RecoveryPlan recoveryPlan, String recoveryLogId) {
        if (null == recoveryPlan || null == recoveryLogId) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryLog recoveryLog = this.queryRecoveryLog(recoveryLogId);
        if (null == recoveryLog) {
            throw new LegoCheckedException(201L);
        }
        List<RecoveryProcessorDetail> details = this.queryDetailsByLogId(recoveryLogId);
        details = this.extendUnRunningProcessDetail(recoveryPlan, details, recoveryLog.getLogType());
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryLog queryRecoveryLog(String logId) {
        Session session;
        RecoveryLog recoveryLog;
        block6: {
            List results;
            block5: {
                recoveryLog = null;
                session = null;
                String querySQL = "select LOGID,LOGSTATUS,LOGTYPE,LOGNAME,OPERATOR,STARTTIME,ENDTIME,ISSYNCHRONIZED,PRODUCTIONSITEID,RECOVERYSITEID,PLANID from ti_recoverylog where LOGID=:logId";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("logId", logId);
                results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block5;
                RecoveryLog recoveryLog2 = null;
                DBOperationUtil.closeSession(session);
                return recoveryLog2;
            }
            try {
                Iterator<RecoveryLog> iterator = this.constructRecoveryLogs(results).iterator();
                if (!iterator.hasNext()) break block6;
                recoveryLog = iterator.next();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Querying recovery log failed. Id:" + logId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return recoveryLog;
    }

    private List<RecoveryLog> constructRecoveryLogs(List<?> results) {
        ArrayList<RecoveryLog> recoveryLogs = new ArrayList<RecoveryLog>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 11 != (values = (Object[])object).length) continue;
            RecoveryLog recoveryLog = new RecoveryLog();
            recoveryLog.setLogId(CommUtil.convertToString((Object)values[0]));
            recoveryLog.setLogStatus(CommUtil.convertToInteger((Object)values[1]).intValue());
            recoveryLog.setLogType(CommUtil.convertToInteger((Object)values[2]).intValue());
            recoveryLog.setLogName(CommUtil.convertToString((Object)values[3]));
            recoveryLog.setOperator(CommUtil.convertToString((Object)values[4]));
            recoveryLog.setStartTime(CommUtil.convertToString((Object)values[5]));
            recoveryLog.setEndTime(CommUtil.convertToString((Object)values[6]));
            recoveryLog.setIsSynchronized(CommUtil.convertToBoolean((Object)values[7]));
            recoveryLog.setProductionSiteId(CommUtil.convertToString((Object)values[8]));
            recoveryLog.setRecoverySiteId(CommUtil.convertToString((Object)values[9]));
            recoveryLog.setPlanId(CommUtil.convertToString((Object)values[10]));
            recoveryLogs.add(recoveryLog);
        }
        return recoveryLogs;
    }

    private List<RecoveryProcessorDetail> groupRecoveryLogDetails(Set<RecoveryProcessorDetail> allDetails) {
        ArrayList<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        if (VerifyUtil.isEmpty(allDetails)) {
            return details;
        }
        HashMap groupDetails = new HashMap();
        for (RecoveryProcessorDetail rpDetail : allDetails) {
            ArrayList subDetails = (ArrayList)groupDetails.get(rpDetail.getDetailId());
            if (null == subDetails) {
                subDetails = new ArrayList();
                groupDetails.put(rpDetail.getDetailId(), subDetails);
            }
            rpDetail.setChildDetails((List)subDetails);
            if (VerifyUtil.isEmpty((String)rpDetail.getParentDetailId())) {
                details.add(rpDetail);
                continue;
            }
            ArrayList<RecoveryProcessorDetail> parentSubDetails = (ArrayList<RecoveryProcessorDetail>)groupDetails.get(rpDetail.getParentDetailId());
            if (null == parentSubDetails) {
                parentSubDetails = new ArrayList<RecoveryProcessorDetail>();
                groupDetails.put(rpDetail.getParentDetailId(), parentSubDetails);
            }
            parentSubDetails.add(rpDetail);
        }
        this.sortRecoveryLogDetails(details, new RecoveryProcessorDetailComparator());
        return details;
    }

    private void sortRecoveryLogDetails(List<RecoveryProcessorDetail> details, RecoveryProcessorDetailComparator comparator) {
        if (VerifyUtil.isEmpty(details)) {
            return;
        }
        Collections.sort(details, comparator);
        for (RecoveryProcessorDetail detail : details) {
            if (VerifyUtil.isEmpty((Collection)detail.getChildDetails())) continue;
            this.sortRecoveryLogDetails(detail.getChildDetails(), comparator);
        }
    }

    private long filterLastReprotectEndTime(String recoveryPlanId) {
        List<RecoveryLog> reprotectHistLogs = this.getHistoryLogsByPlanId(recoveryPlanId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT, null, null, null);
        long lastReprotectEndTime = 0L;
        if (VerifyUtil.isEmpty(reprotectHistLogs)) {
            return lastReprotectEndTime;
        }
        for (RecoveryLog reprotectLog : reprotectHistLogs) {
            long endTime;
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != reprotectLog.getLogStatus() || lastReprotectEndTime >= (endTime = Long.parseLong(reprotectLog.getEndTime()))) continue;
            lastReprotectEndTime = endTime;
        }
        return lastReprotectEndTime;
    }

    private void setQuery(List<QueryCondition> conditions, Query query) {
        for (QueryCondition condition : conditions) {
            if (condition.getPropName().equalsIgnoreCase("name")) {
                String filterValue = ((String)condition.getPropValue()).replaceAll("_", "\\\\_");
                filterValue = filterValue.replaceAll("%", "\\\\%");
                query.setString(condition.getPropName(), "%" + filterValue + "%");
                continue;
            }
            if (condition.getPropName().equalsIgnoreCase("planstatus")) {
                int planStatus = Integer.parseInt(String.valueOf(condition.getPropValue()));
                query.setInteger(condition.getPropName(), planStatus);
                continue;
            }
            if (!condition.getPropName().equalsIgnoreCase("planuse")) continue;
            int planType = Integer.parseInt(String.valueOf(condition.getPropValue()));
            query.setInteger(condition.getPropName(), planType);
        }
    }

    static {
        RECOVERYPLAN_COLUME.add("planid");
        RECOVERYPLAN_COLUME.add("uuid");
        RECOVERYPLAN_COLUME.add("planname");
        RECOVERYPLAN_COLUME.add("plandesc");
        RECOVERYPLAN_COLUME.add("planstatus");
        RECOVERYPLAN_COLUME.add("planprogress");
        RECOVERYPLAN_COLUME.add("plantype");
        RECOVERYPLAN_COLUME.add("lastteststatus");
        RECOVERYPLAN_COLUME.add("processstatus");
        RECOVERYPLAN_COLUME.add("planuse");
    }
}

