/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanServiceImpl;
import com.huawei.ism.drm.drp.synchronize.RecoveryLogSynchronizerJob;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RecoveryProcessServiceImpl
implements IRecoveryProcessService {
    private static final Log LOG = LogFactory.getInstance(RecoveryProcessServiceImpl.class);
    private static final Map<Integer, Integer> statusMapping = new HashMap<Integer, Integer>();
    private IRecoveryPlanService recoveryPlanService;
    private IMoDao moDao;
    private Scheduler quartzScheduler;

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void initialize() {
        List recoveryPlans = this.recoveryPlanService.getAllRecoveryPlan();
        if (VerifyUtil.isEmpty((Collection)recoveryPlans)) {
            return;
        }
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            Integer status;
            DrmEnumDefine.RECOVERY_PLAN_STATUS_E curPlanStatus = DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus());
            this.changePlanStatusToFailed(recoveryPlan, curPlanStatus);
            if (null != recoveryPlan.getUse() && recoveryPlan.getUse().intValue() == RecoveryPlanUse.INTERNAL_USE.getValue() && null != (status = statusMapping.get(recoveryPlan.getPlanStatus()))) {
                recoveryPlan.setPlanStatus(status.intValue());
            }
            this.updateRecoveryPlan(recoveryPlan);
            RecoveryLog recoveryLog = this.recoveryPlanService.getLatestRecoveryLog(recoveryPlan.getPlanId());
            if (null != recoveryLog) {
                this.updateRecoveryLog(recoveryLog.getLogId(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue(), String.valueOf(new Date().getTime()));
            }
            this.updateRecoveryProcessDetail();
        }
        try {
            this.quartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Start quartz failed", (Throwable)e);
            return;
        }
        this.scheduleLogSyncJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryLog(RecoveryLog recoveryLog, RecoveryProcessDefinition processes) {
        if (null == recoveryLog || null == processes || VerifyUtil.isEmpty((Collection)processes.getRecoveryProcessors())) {
            LOG.error((Object)"The parameter is null.");
            return null;
        }
        String recoveryLogId = null;
        Session session = null;
        try {
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            recoveryLog.setLogId(UUIDGenerator.getUUID());
            session.beginTransaction();
            session.save((Object)recoveryLog);
            this.createRecoveryProcessDetails(processes, recoveryLog.getLogId(), session);
            session.getTransaction().commit();
            recoveryLogId = recoveryLog.getLogId();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Creating recovery log failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return recoveryLogId;
    }

    public String createRecoveryProcessDetail(RecoveryProcessorDetail recoveryProcessDetail, boolean isUpdate) {
        if (null == recoveryProcessDetail) {
            LOG.error((Object)"The parameter is null.");
            return null;
        }
        String recoveryProcId = null;
        try {
            HibernateTemplate hibernateTpl = this.moDao.getHibernateTemplate();
            if (isUpdate) {
                hibernateTpl.update((Object)recoveryProcessDetail);
            } else {
                hibernateTpl.save((Object)recoveryProcessDetail);
            }
            recoveryProcId = recoveryProcessDetail.getDetailId();
        }
        catch (Exception e) {
            LOG.error((Object)"Creating process detail failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return recoveryProcId;
    }

    public boolean deleteRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            LOG.error((Object)"The parameter is null.");
            return false;
        }
        boolean isSuccess = true;
        try {
            RecoveryProcessor recoveryProcessor = this.getRecoveryProcess(procId);
            this.deleteRecoveryProcessor(recoveryProcessor);
        }
        catch (Exception e) {
            LOG.error((Object)"DeleteRecoveryProcessor failed.");
            isSuccess = false;
        }
        return isSuccess;
    }

    public void deleteRecoveryProcessor(RecoveryProcessor recoveryProcessor) {
        if (VerifyUtil.isEmpty((Object)recoveryProcessor)) {
            LOG.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)recoveryProcessor);
            LOG.debug((Object)this.recordDeletedRecoveryProcess(recoveryProcessor), 90160758784000L);
        }
        catch (Exception e) {
            String errorMsg = "Delete recovery process failed. ProcId:" + recoveryProcessor.getProcId() + ",Name:" + recoveryProcessor.getName();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlan(String recoveryPlanId, int planStatus, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E planExecuteType, Map<String, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E> poRecoveryStatusMap, Integer planProgress, int processStatus) {
        boolean updateResult = false;
        if (!this.checkParametersForUpdate(recoveryPlanId, planStatus, planExecuteType, planProgress)) {
            return updateResult;
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
        if (null == recoveryPlan) {
            LOG.error((Object)("The recovery plan does not exist. Id:" + recoveryPlanId), 90160758784001L);
            return updateResult;
        }
        try {
            recoveryPlan.setLastExecuteType(planExecuteType.getValue());
            recoveryPlan.setPlanStatus(planStatus);
            recoveryPlan.setProcessStatus(processStatus);
            if (null != planProgress) {
                recoveryPlan.setPlanProgress(planProgress.intValue());
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.equals((Object)planExecuteType)) {
                recoveryPlan.setLastTestStatus(planStatus);
                String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
                recoveryPlan.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(planStatus));
                String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN(recoveryPlan);
                if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                    recoveryPlan.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(planStatus));
                }
            }
            LOG.info((Object)"Update recovery plan status. Plan name: %s, Id:%s, Status:%s,Execute type: %s, Progress: %s", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanId(), planStatus, planExecuteType, planProgress});
            Session session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryPlan);
                RecoveryPlanServiceImpl planServiceImpl = (RecoveryPlanServiceImpl)this.recoveryPlanService;
                planServiceImpl.updatePoRecoveryStatus(recoveryPlan.getProtectGroups(), poRecoveryStatusMap, session);
                session.getTransaction().commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)LOG);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
            DBOperationUtil.closeSession(session);
            updateResult = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Updating recovery plan failed. Id: %s. %s", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        int planProgress;
        NativeQuery query;
        Session session;
        boolean updateResult;
        block9: {
            List results;
            block8: {
                updateResult = false;
                if (VerifyUtil.isEmpty((String)recoveryPlanId) || 0 > progressRatio || 100 < progressRatio) {
                    LOG.error((Object)"The parameter is invalid. Id: %s, ProgressRatio: %s", new Object[]{recoveryPlanId, progressRatio});
                    return updateResult;
                }
                session = null;
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select PLANPROGRESS from ti_recoveryplan where PLANID=:recoveryPlanId";
                query = session.createSQLQuery(querySQL);
                query.setString("recoveryPlanId", recoveryPlanId);
                results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block8;
                LOG.error((Object)"The recovery plan does not exist. Id: %s", new Object[]{recoveryPlanId});
                boolean bl = updateResult;
                DBOperationUtil.closeSession(session);
                return bl;
            }
            planProgress = (Integer)results.get(0);
            if (0 >= planProgress) {
                planProgress = 0;
            }
            if (100 > (planProgress += progressRatio)) break block9;
            LOG.warn((Object)"The progress is extend 100. PlanId: %s, planProgress: %s, progressRatio:", new Object[]{recoveryPlanId, planProgress, progressRatio});
            boolean bl = true;
            DBOperationUtil.closeSession(session);
            return bl;
        }
        try {
            String updateSQL = "update ti_recoveryplan set PLANPROGRESS=:planProgress where PLANID=:recoveryPlanId";
            query = session.createSQLQuery(updateSQL);
            query.setInteger("planProgress", planProgress);
            query.setString("recoveryPlanId", recoveryPlanId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Updating recovery plan progress failed. Id: %s. %s", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessorDetail getRecoveryProcessDetail(String logId, String procId) {
        Session session;
        RecoveryProcessorDetail detail;
        block5: {
            if (VerifyUtil.isEmpty((String)logId) || VerifyUtil.isEmpty((String)procId)) {
                LOG.error((Object)"The parameter is null.");
                return null;
            }
            detail = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from RecoveryProcessorDetail where parentDetailId=null and logId=:logId and procId=:procId";
                Query query = session.createQuery(queryHQL);
                query.setString("logId", logId);
                query.setString("procId", procId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block5;
                detail = (RecoveryProcessorDetail)results.get(0);
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"Getting recovery process detail failed. LogId: %s, ProcId: %s. %s", new Object[]{logId, procId, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return detail;
    }

    public boolean updateRecoveryPlan(RecoveryPlan recoveryPlan) {
        boolean updateResult = false;
        if (null == recoveryPlan) {
            LOG.error((Object)"The parameter is null.");
            return updateResult;
        }
        try {
            ProtectGroup protectGroup = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
            if (30 == protectGroup.getTemplate().getType() && RecoveryPlanUse.PUBLIC_USE.getValue() == recoveryPlan.getUse().intValue()) {
                recoveryPlan.setPlanType(DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue());
            }
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
            updateResult = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Updating recovery plan failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return updateResult;
    }

    public boolean saveOrUpdateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (null == processDetail) {
            LOG.error((Object)"The parameter is null.");
            return updateResult;
        }
        try {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)processDetail);
            updateResult = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Updating recovery process detail failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (null == processDetail || null == processDetail.getDetailId()) {
            LOG.error((Object)"The parameter is null.");
            return updateResult;
        }
        Session session = null;
        try {
            StringBuilder updateSQL = new StringBuilder();
            updateSQL.append("update ti_recoveryprocessordetail set PROCESSSTATUS=:processStatus, ENDTIME=:endTime");
            updateSQL.append(", PROCESSDETAIL=:processDetail, PROCESSDETAILPARAMS=:processDetailParams");
            updateSQL.append(", ISSKIPPED=:isSkipped");
            if (null != processDetail.getProcessName()) {
                updateSQL.append(", PROCESSNAME=:processName");
            }
            if (null != processDetail.getProcessNameParams()) {
                updateSQL.append(", PROCESSNAMEPARAMS=:processNameParams");
            }
            updateSQL.append(" where DETAILID=:detailId");
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSQL.toString());
            query.setInteger("processStatus", processDetail.getProcessStatus());
            query.setString("endTime", processDetail.getEndTime());
            query.setString("processDetail", processDetail.getProcessDetail());
            query.setString("processDetailParams", processDetail.getProcessDetailParams());
            query.setBoolean("isSkipped", processDetail.getIsSkipped().booleanValue());
            if (null != processDetail.getProcessName()) {
                query.setString("processName", processDetail.getProcessName());
            }
            if (null != processDetail.getProcessNameParams()) {
                query.setString("processNameParams", processDetail.getProcessNameParams());
            }
            query.setString("detailId", processDetail.getDetailId());
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            LOG.error((Object)"Updating recovery process detail failed. Id: %s. %s", new Object[]{processDetail.getDetailId(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return updateResult;
    }

    public boolean updateRecoveryProcessDetail(String procDetailId, int procDetailStatus, String procEndTime, String procDetail, String procDetailParams) {
        if (VerifyUtil.isEmpty((String)procDetailId) || null == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.getType((int)procDetailStatus) || VerifyUtil.isEmpty((String)procEndTime)) {
            LOG.error((Object)"The parameter is null.");
            return false;
        }
        RecoveryProcessorDetail processDetail = new RecoveryProcessorDetail();
        processDetail.setDetailId(procDetailId);
        processDetail.setProcessStatus(procDetailStatus);
        processDetail.setEndTime(procEndTime);
        processDetail.setProcessDetail(procDetail);
        processDetail.setProcessDetailParams(procDetailParams);
        return this.updateRecoveryProcessDetail(processDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessor(RecoveryProcessor recoveryProcess) {
        boolean updateResult = false;
        if (null == recoveryProcess) {
            LOG.error((Object)"The parameter is null.");
            return updateResult;
        }
        Session session = null;
        try {
            if (!VerifyUtil.isEmpty((String)recoveryProcess.getProcId()) && recoveryProcess.getIsNeedSave().booleanValue()) {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryProcess);
                session.getTransaction().commit();
            }
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Updating recovery process failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    public void updateRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        Session session = HibernateUtil.getSession();
        if (session != null) {
            session.saveOrUpdate((Object)rpDefinition);
        } else {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)rpDefinition);
        }
    }

    public boolean deleteRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        boolean isSuccess = false;
        if (VerifyUtil.isEmpty((Object)rpDefinition)) {
            LOG.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)rpDefinition);
            isSuccess = true;
        }
        catch (Exception e) {
            String errorMsg = "Delete rpDefinition failed. Plan id:" + rpDefinition.getPlanId() + ",Id:" + rpDefinition.getProcessId();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)LOG);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryLog(String recoveryLogId, int logStatus, String endTime) {
        boolean updateResult = false;
        if (VerifyUtil.isEmpty((String)recoveryLogId) || null == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.getType((int)logStatus) || VerifyUtil.isEmpty((String)endTime)) {
            LOG.error((Object)"The parameter is null. logId: %s, LogStatus: %s, EndTime: %s", new Object[]{recoveryLogId, logStatus, endTime});
            return updateResult;
        }
        Session session = null;
        try {
            String updateSQL = "update ti_recoverylog set LOGSTATUS=:logStatus, ENDTIME=:endTime where LOGID=:logId";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("logStatus", logStatus);
            query.setString("endTime", endTime);
            query.setString("logId", recoveryLogId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Updating recovery log failed. Id: %s. %s", new Object[]{recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryProcessor> getRecoveryProcessors(String planId, List<QueryCondition> conditions, Class<? extends RecoveryProcessor> cls) {
        RecoveryProcessDefinition rpDefinition;
        Session session;
        List<Object> recoveryProcessors;
        block6: {
            recoveryProcessors = new ArrayList<RecoveryProcessor>();
            if (VerifyUtil.isEmpty((String)planId)) {
                LOG.error((Object)"The parameter is null.");
                return recoveryProcessors;
            }
            session = null;
            rpDefinition = this.getRecoveryProcessDefinition(planId, conditions);
            if (null != rpDefinition) break block6;
            ArrayList<RecoveryProcessor> arrayList = recoveryProcessors;
            DBOperationUtil.closeSession(session);
            return arrayList;
        }
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            recoveryProcessors = session.createCriteria(cls).add((Criterion)Restrictions.eq((String)"processId", (Object)rpDefinition.getProcessId())).list();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)"Getting recovery processes failed. PlanId: %s, ClassName: %s. %s", new Object[]{planId, cls.getSimpleName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessDefinition getRecoveryProcessDefinition(String planId, List<QueryCondition> conditions) {
        Session session;
        RecoveryProcessDefinition rpDefinition;
        block6: {
            if (null == planId || VerifyUtil.isEmpty(conditions)) {
                return null;
            }
            rpDefinition = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                List criterionList = this.moDao.translatePropsToCriterions(conditions);
                Criteria criteria = session.createCriteria(RecoveryProcessDefinition.class);
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                for (Criterion criterion : criterionList) {
                    criteria.add(criterion);
                }
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                List results = criteria.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block6;
                rpDefinition = (RecoveryProcessDefinition)results.get(0);
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"Getting recovery process definition failed. PlanId: %s. %s", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return rpDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSubRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            LOG.error((Object)"The parameter is null.");
            return false;
        }
        RecoveryProcessor recoveryProcess = this.getRecoveryProcess(procId);
        boolean isSuccess = true;
        if (null == recoveryProcess) {
            LOG.error((Object)"The recovery process does not exist. ProcId: %s", new Object[]{procId});
            return isSuccess;
        }
        Session session = null;
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            ArrayList<String> logMessages = new ArrayList<String>();
            session.beginTransaction();
            this.deleteSubProcess(session, recoveryProcess, logMessages);
            session.getTransaction().commit();
            for (String logMessage : logMessages) {
                LOG.debug((Object)logMessage, 90160758784000L);
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Delete sub recovery process failed. ProcId: %s", new Object[]{procId});
                isSuccess = false;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return isSuccess;
    }

    public void syncRecoveryLog(String planId, String recoveryLogId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)recoveryLogId)) {
            LOG.error((Object)"Parameter is invalid.");
            return;
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            LOG.error((Object)"RP does not exist. Id: %s", new Object[]{planId});
            return;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() != recoveryPlan.getPlanType()) {
            return;
        }
        RecoveryLog recoveryLog = this.recoveryPlanService.getRecoveryLog(recoveryLogId);
        if (null != recoveryLog) {
            RecoveryPlanServiceImpl rpServiceImpl = (RecoveryPlanServiceImpl)this.recoveryPlanService;
            List<RecoveryProcessorDetail> details = rpServiceImpl.getDetailsByLogId(recoveryLogId);
            HashSet<RecoveryProcessorDetail> rpDetails = new HashSet<RecoveryProcessorDetail>();
            for (RecoveryProcessorDetail detail : details) {
                rpDetails.add(detail);
            }
            recoveryLog.setRecoveryProcessDetails(rpDetails);
            ArrayList<RecoveryLog> recoveryLogs = new ArrayList<RecoveryLog>();
            recoveryLogs.add(recoveryLog);
            rpServiceImpl.saveOrUpdateRecoveryLogs(recoveryLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryLog> getUnsynchronizedRecoveryLogs() {
        Session session;
        ArrayList<RecoveryLog> unSyncRecoveryLogs;
        block5: {
            unSyncRecoveryLogs = new ArrayList<RecoveryLog>();
            session = null;
            try {
                HibernateTemplate template = this.getMoDao().getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                String querySQL = "select LOGID,PLANID from ti_recoverylog where ENDTIME is not null and ISSYNCHRONIZED=0 order by STARTTIME DESC";
                NativeQuery query = session.createSQLQuery(querySQL);
                List logs = query.list();
                if (VerifyUtil.isEmpty((Collection)logs)) break block5;
                for (Object obj : logs) {
                    Object[] objArray = (Object[])obj;
                    if (objArray == null || objArray.length < 2) continue;
                    RecoveryLog recoveryLog = new RecoveryLog();
                    recoveryLog.setLogId(String.valueOf(objArray[0]));
                    recoveryLog.setPlanId(String.valueOf(objArray[1]));
                    unSyncRecoveryLogs.add(recoveryLog);
                }
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"GetUnsynchronizedRecoveryLogs failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return unSyncRecoveryLogs;
    }

    private void createRecoveryProcessDetails(RecoveryProcessDefinition processes, String logId, Session session) {
        List<RecoveryProcessor> sortedProcesses = RecoveryServiceUtil.sortRecoveryProcessors(processes.getRecoveryProcessors());
        for (RecoveryProcessor process : sortedProcesses) {
            if (!process.getIsEnabled().booleanValue()) continue;
            process.updateProcessName();
            RecoveryProcessorDetail newDetail = new RecoveryProcessorDetail();
            newDetail.setDetailId(UUIDGenerator.getUUID());
            newDetail.setProcessName(process.getProcName());
            newDetail.setProcessStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
            newDetail.setProcId(process.getProcId());
            newDetail.setLogId(logId);
            RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor(process);
            RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor(process);
            String previousProcId = null != preProcessor ? preProcessor.getProcId() : null;
            String nextProcId = null != nextProcessor ? nextProcessor.getProcId() : null;
            newDetail.setPreviousProcId(previousProcId);
            newDetail.setNextProcId(nextProcId);
            session.save((Object)newDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteRecoveryProcessGlobalSettings(String planId, String propName) {
        int n;
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)propName)) {
            LOG.error((Object)"Args is empty! planId: %s, propName: %s", new Object[]{planId, propName});
            return 0;
        }
        Session session = null;
        try {
            HibernateTemplate template = this.getMoDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            RecoveryPlan recoveryPlan = new RecoveryPlan();
            HashMap globalSettings = new HashMap();
            recoveryPlan.setPlanId(planId);
            recoveryPlan.setGlobalSettings(globalSettings);
            String deleteSQL = "delete from TI_RP_GLOBALSETTINGS where planId = :planId and propName = :propName ";
            NativeQuery query = session.createSQLQuery(deleteSQL);
            query.setString("planId", planId);
            query.setString("propName", propName);
            n = query.executeUpdate();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)"GetUnsynchronizedRecoveryLogs failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return 0;
        }
        DBOperationUtil.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryProcessor getRecoveryProcess(String procId) {
        Session session;
        RecoveryProcessor recoveryProcess;
        block4: {
            recoveryProcess = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                String queryHQL = "from RecoveryProcessor rp where rp.procId=:procId";
                Query query = session.createQuery(queryHQL);
                query.setString("procId", procId);
                List recoveryProcesses = query.list();
                if (null == recoveryProcesses || recoveryProcesses.isEmpty()) break block4;
                recoveryProcess = (RecoveryProcessor)recoveryProcesses.get(0);
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"Getting recovery process failed. Id: %s. %s", new Object[]{procId, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcess;
    }

    private void deleteSubProcess(Session session, RecoveryProcessor recoveryProcess, List<String> logMessages) {
        if (null != recoveryProcess.getChildProc() && !recoveryProcess.getChildProc().isEmpty()) {
            for (RecoveryProcessor subProcess : recoveryProcess.getChildProc()) {
                session.delete((Object)subProcess);
                String logMsg = this.recordDeletedRecoveryProcess(subProcess);
                logMessages.add(logMsg);
            }
        }
    }

    private String recordDeletedRecoveryProcess(RecoveryProcessor recoveryProcess) {
        return "The process is deleted. ProcName:" + recoveryProcess.getProcName() + ",ProcType:" + recoveryProcess.getProcType() + ",ProcId:" + recoveryProcess.getProcId() + ",PlanId:" + recoveryProcess.getPlanId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecoveryProcessDetail() {
        Session session = null;
        try {
            String updateSQL1 = "update ti_recoveryprocessordetail set PROCESSNAMEPARAMS=:procNameParams ";
            updateSQL1 = updateSQL1 + "where PROCESSSTATUS=3 and (PROCESSNAMEPARAMS is null or PROCESSNAMEPARAMS='')";
            String updateSQL2 = "update ti_recoveryprocessordetail set PROCESSSTATUS=1 ,PROCESSDETAIL=:detail where PROCESSSTATUS=3";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query1 = session.createSQLQuery(updateSQL1);
            NativeQuery query2 = session.createSQLQuery(updateSQL2);
            Object[] strArray = new String[6];
            Arrays.fill(strArray, "--");
            query1.setString("procNameParams", RecoveryProcessUtil.constructParamsString((String[])strArray));
            query2.setString("detail", "lego.err.1073947452");
            session.beginTransaction();
            query1.executeUpdate();
            query2.executeUpdate();
            session.getTransaction().commit();
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            LOG.error((Object)"Updating recovery process detail failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private boolean checkParametersForUpdate(String recoveryPlanId, int planStatus, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E planExecuteType, Integer planProgress) {
        boolean isValidPlanProgress = false;
        if (null == planProgress || 0 <= planProgress && 100 >= planProgress) {
            isValidPlanProgress = true;
        }
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || !isValidPlanProgress || null == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)planStatus) || null == planExecuteType) {
            LOG.error((Object)"Invalid parameter");
            return false;
        }
        return true;
    }

    private void scheduleLogSyncJob() {
        String logSyncInterval = ResourceUtil.getValue("logSyncInterval", "5");
        int syncInterval = 300000;
        try {
            syncInterval = Integer.parseInt(logSyncInterval) * 60 * 1000;
        }
        catch (Exception e) {
            LOG.error((Object)"Parsing log sync interval failed. Str: %s. %s", new Object[]{logSyncInterval, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        SimpleTriggerImpl logSyncTrigger = new SimpleTriggerImpl("LogSyncTrigger", null, new Date(), null, -1, (long)syncInterval);
        try {
            JobDetailImpl logSyncJobDetail = new JobDetailImpl("JOB_LogSynchronizer", "JOB_GROUP_LogSynchronizer", RecoveryLogSynchronizerJob.class);
            logSyncJobDetail.setDurability(true);
            this.quartzScheduler.scheduleJob((JobDetail)logSyncJobDetail, (Trigger)logSyncTrigger);
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Schedule log sync job failed", (Throwable)e);
        }
    }

    private void changePlanStatusToFailed(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_STATUS_E curPlanStatus) {
        Integer targetStatus = curPlanStatus.getFailStatusWhenRunning();
        if (null != targetStatus) {
            recoveryPlan.setPlanStatus(targetStatus.intValue());
        }
    }

    static {
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED.getValue());
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED.getValue());
    }
}

