/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class RecoveryServiceUtil {
    private static Log logger = LogFactory.getInstance(RecoveryServiceUtil.class);

    private RecoveryServiceUtil() {
    }

    public static void checkOperationPrivilegeBySite(RecoveryPlan recoveryPlan) {
        boolean isLocalRecoverySite;
        Set<String> disasterSiteIds;
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("recoveryPlan: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = ((ProtectGroup)iterator.next()).getProductSiteId();
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        if (localSites.contains(productSite) && !VerifyUtil.isEmpty(disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan)) && 1 == disasterSiteIds.size() && !(isLocalRecoverySite = RecoveryServiceUtil.isExistLocalRecoverySite(disasterSiteIds))) {
            throw new LegoCheckedException(1073948711L);
        }
    }

    public static void checkRollBackOperationPrivilege(RecoveryPlan recoveryPlan) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            return;
        }
        provider.checkIfAllowRollBack(recoveryPlan);
    }

    public static void checkReprotectOperationPrivilege(RecoveryPlan recoveryPlan) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            return;
        }
        provider.checkIfAllowReprotect(recoveryPlan);
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
            return;
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site curDisasterSite = siteService.getSiteById(curDisasterSiteId);
        if (null == curDisasterSite) {
            return;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            return;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && (null == procType || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == procType.getValue())) {
            return;
        }
        if (0 != curDisasterSite.getSiteType()) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String newDisasterSiteId) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite(newDisasterSiteId);
        if (0 != recoverySite.getSiteType()) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    public static List<Site> getRemoteSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (null == disasterSite || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        Site productSite = siteService.getSiteById(productSiteId);
        if (null != productSite && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }

    public static List<RecoveryProcessorDetail> sortRecoveryProcessorDetails(List<RecoveryProcessorDetail> details) {
        ArrayList<RecoveryProcessorDetail> sortedDetails = new ArrayList<RecoveryProcessorDetail>();
        if (VerifyUtil.isEmpty(details)) {
            return sortedDetails;
        }
        RecoveryProcessorDetail firstDetail = RecoveryServiceUtil.getFirstRecoveryProcessorDetail(details);
        if (null == firstDetail) {
            return details;
        }
        sortedDetails.add(firstDetail);
        while (null != firstDetail && !VerifyUtil.isEmpty((String)firstDetail.getNextProcId())) {
            String nextProcId = firstDetail.getNextProcId();
            firstDetail = null;
            for (RecoveryProcessorDetail detail : details) {
                if (!VerifyUtil.isEmpty((String)detail.getParentDetailId()) || !detail.getProcId().equals(nextProcId)) continue;
                firstDetail = detail;
                sortedDetails.add(firstDetail);
            }
        }
        if (sortedDetails.size() != details.size()) {
            return details;
        }
        return sortedDetails;
    }

    public static List<RecoveryProcessor> sortRecoveryProcessors(Set<RecoveryProcessor> processors) {
        ArrayList<RecoveryProcessor> processorList = new ArrayList<RecoveryProcessor>();
        RecoveryProcessor startRecoveryProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (null != processor.getPreviousProcessor()) continue;
            startRecoveryProcessor = processor;
            break;
        }
        if (null != startRecoveryProcessor) {
            do {
                processorList.add(startRecoveryProcessor);
            } while (null != (startRecoveryProcessor = startRecoveryProcessor.getNextProcessor()));
        }
        if (processorList.size() != processors.size()) {
            processorList.clear();
            for (RecoveryProcessor processor : processors) {
                processorList.add(processor);
            }
        }
        return processorList;
    }

    public static DrmEnumDefine.APP_TYPE getAppType(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        int poType = ((ProtectGroup)iterator.next()).getPoType();
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)poType);
        return appType;
    }

    public static String getProductSiteId(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        return ((ProtectGroup)iterator.next()).getProductSiteId();
    }

    public static Set<String> getDisasterSiteIds(RecoveryPlan recoveryPlan) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                disasterSites.add(gpReplica.getRecoverySite());
            }
        }
        return disasterSites;
    }

    public static Set<String> getDisasterSiteIds(ProtectGroup protectGroup) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set gpReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica gpReplica : gpReplicas) {
            disasterSites.add(gpReplica.getRecoverySite());
        }
        return disasterSites;
    }

    public static Site getRemoteDisasterSite(RecoveryPlan recoveryPlan) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        HashSet<String> disasterSiteIds = new HashSet<String>();
        disasterSiteIds.addAll(RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan));
        if (1 < disasterSiteIds.size()) {
            String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
            if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
                return null;
            }
            if (!RecoveryServiceUtil.isContainSite(localSites, curDisasterSiteId)) {
                return siteService.getSiteById(curDisasterSiteId);
            }
        } else if (1 == disasterSiteIds.size()) {
            String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
            Site productSite = siteService.getSiteById(productSiteId);
            Site disasterSite = siteService.getSiteById((String)disasterSiteIds.iterator().next());
            if (localSites.contains(productSite) && !localSites.contains(disasterSite)) {
                return disasterSite;
            }
        }
        return null;
    }

    public static boolean isExistLocalRecoverySite(Set<String> disasterSiteIds) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isLoacalDisasterSite = false;
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (null == disasterSite || !localSites.contains(disasterSite)) continue;
            isLoacalDisasterSite = true;
            break;
        }
        return isLoacalDisasterSite;
    }

    public static IRecoveryProcessProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        Set pgs = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)("There is no protect group. planId:" + recoveryPlan.getPlanId()), 90160758784001L);
            return null;
        }
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null. planId:" + recoveryPlan.getPlanId()), 90160758784001L);
            return null;
        }
        return RecoveryServiceUtil.getRecoveryProcessProvider((ProtectGroup)iterator.next());
    }

    public static IRecoveryProcessProvider getRecoveryProcessProvider(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"Protect group is null.", 90160758784001L);
            return null;
        }
        int poType = protectGroup.getPoType();
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)poType);
        if (null == appType) {
            logger.error((Object)("There is no matched APP_TYPE. poType:" + poType), 90160758784001L);
            return null;
        }
        IRecoveryProcessProvider procProvider = RecoveryProcessorMgr.getInstance().getRecoveryProcessProvider(appType.name());
        if (null == procProvider) {
            logger.error((Object)("The recovery process provider is null. appType:" + appType.name()), 90160758784001L);
        }
        return procProvider;
    }

    public static RecoveryProcessDefinition getInitRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procyType) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, procyType, protectGroup);
        return rpDefinition;
    }

    public static Set<RecoveryProcessDefinition> getInitRecoveryProcessDefinitions(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup firstProtectGroup = (ProtectGroup)iterator.next();
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)firstProtectGroup.getPoType());
        if (null == appType) {
            logger.error((Object)("There is no matched APP_TYPE. poType:" + firstProtectGroup.getPoType()), 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        Set processes = provider.getRecoveryProcesses(recoveryPlan, appType, firstProtectGroup);
        return processes;
    }

    public static void updateProgressRatio(List<? extends RecoveryProcessor> processors) {
        List<RecoveryProcessor> newProcessors = RecoveryServiceUtil.filterEnabledProcessors(processors);
        if (null == newProcessors || newProcessors.isEmpty()) {
            return;
        }
        int totalProgressRatio = 100;
        RecoveryProcessor proc = newProcessors.get(0);
        if (null != proc.getParentProc() && !(proc.getParentProc() instanceof IInitialChildProcessor)) {
            totalProgressRatio = proc.getParentProc().getProgressRatio();
        }
        int avgProgressRatio = totalProgressRatio / newProcessors.size();
        int index = 0;
        int countProgressRatio = 0;
        for (RecoveryProcessor recoveryProcessor : newProcessors) {
            if (++index == newProcessors.size()) {
                recoveryProcessor.setProgressRatio(totalProgressRatio - countProgressRatio);
                continue;
            }
            countProgressRatio += avgProgressRatio;
            recoveryProcessor.setProgressRatio(avgProgressRatio);
        }
    }

    public static boolean isContainSite(List<Site> sites, String siteId) {
        if (VerifyUtil.isEmpty(sites) || VerifyUtil.isEmpty((String)siteId)) {
            return false;
        }
        for (Site site : sites) {
            if (!site.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends IProcessor> sortAndUpdateProcessorRation(Set<RecoveryProcessor> processors) {
        List<RecoveryProcessor> rProcessors = RecoveryServiceUtil.sortRecoveryProcessors(processors);
        RecoveryServiceUtil.updateProgressRatio(rProcessors);
        return rProcessors;
    }

    public static void resetRecoverySetting(Set<RecoverySetting> oldSettings, RecoverySetting newSetting) {
        if (VerifyUtil.isEmpty(oldSettings)) {
            oldSettings.add(newSetting);
        }
        boolean isExistedSetting = false;
        for (RecoverySetting oldSetting : oldSettings) {
            if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
            oldSetting.setValue(newSetting.getValue());
            if (!VerifyUtil.isEmpty((String)newSetting.getDisasterSiteId())) {
                oldSetting.setDisasterSiteId(newSetting.getDisasterSiteId());
            }
            isExistedSetting = true;
            break;
        }
        if (!isExistedSetting) {
            oldSettings.add(newSetting);
        }
    }

    public static List<RecoverySetting> filterAddedRecoverySettings(Set<RecoverySetting> oldSettings, Set<RecoverySetting> newSettings) {
        ArrayList<RecoverySetting> addedRecoverySettings = new ArrayList<RecoverySetting>();
        if (VerifyUtil.isEmpty(newSettings)) {
            return addedRecoverySettings;
        }
        for (RecoverySetting newSetting : newSettings) {
            boolean isExistedSetting = false;
            for (RecoverySetting oldSetting : oldSettings) {
                if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
                isExistedSetting = true;
                break;
            }
            if (isExistedSetting) continue;
            addedRecoverySettings.add(newSetting);
        }
        return addedRecoverySettings;
    }

    public static String getDisasterHostSN(RecoveryPlan recoveryPlan) {
        String hostOrGroupId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        if (VerifyUtil.isEmpty((String)hostOrGroupId)) {
            Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)recoveryPlan.getPlanId(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (null == settings) {
                return hostOrGroupId;
            }
            Iterator iterator = settings.iterator();
            if (iterator.hasNext()) {
                hostOrGroupId = ((RecoverySetting)iterator.next()).getValue();
            }
        }
        return hostOrGroupId;
    }

    public static Site getRecoverySite(String recoverySiteId) {
        if (VerifyUtil.isEmpty((String)recoverySiteId)) {
            throw new LegoCheckedException(201L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site recoverySite = siteService.getSiteById(recoverySiteId);
        if (null == recoverySite) {
            throw new LegoCheckedException(201L);
        }
        return recoverySite;
    }

    public static void setProtectGroupsInvalidByPlan(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        try {
            RecoveryProcessorMgr processMgr = RecoveryProcessorMgr.getInstance();
            IRecoveryProcessHandler recoveryProcessHandler = processMgr.getRecoveryProcessHandler();
            String productSiteId = RecoveryServiceUtil.getProductSiteId(plan);
            Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
            boolean operationResult = recoveryProcessHandler.setProtectGroupsInvalid(productSite, plan.getProtectGroups(), type);
            if (!operationResult) {
                logger.error((Object)("Setting protect group invalid failed. planId:" + plan.getPlanId()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect group invalid failed. planId:" + plan.getPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private static List<RecoveryProcessor> filterEnabledProcessors(List<? extends RecoveryProcessor> processors) {
        ArrayList<RecoveryProcessor> newProcessors = new ArrayList<RecoveryProcessor>();
        if (null == processors || processors.isEmpty()) {
            return newProcessors;
        }
        for (RecoveryProcessor recoveryProcessor : processors) {
            if (null == recoveryProcessor || !recoveryProcessor.getIsEnabled().booleanValue()) continue;
            RecoveryServiceUtil.filterEnabledProcessor(recoveryProcessor, newProcessors);
        }
        return newProcessors;
    }

    private static void filterEnabledProcessor(RecoveryProcessor processor, List<RecoveryProcessor> newProcessors) {
        if (processor instanceof IInitialChildProcessor) {
            for (RecoveryProcessor childProcessor : RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc())) {
                if (null == childProcessor || !childProcessor.getIsEnabled().booleanValue()) continue;
                RecoveryServiceUtil.filterEnabledProcessor(childProcessor, newProcessors);
            }
        } else {
            if (null == processor.getNextCascadeProcessor()) {
                newProcessors.add(processor);
                return;
            }
            RecoveryProcessor tempProcessor = processor;
            do {
                if (!tempProcessor.getIsEnabled().booleanValue()) continue;
                newProcessors.add(tempProcessor);
            } while (null != (tempProcessor = tempProcessor.getNextCascadeProcessor()));
        }
    }

    private static RecoveryProcessorDetail getFirstRecoveryProcessorDetail(List<RecoveryProcessorDetail> details) {
        RecoveryProcessorDetail firstDetail = null;
        for (RecoveryProcessorDetail detail : details) {
            if (!VerifyUtil.isEmpty((String)detail.getParentDetailId()) || !VerifyUtil.isEmpty((String)detail.getPreviousProcId()) || VerifyUtil.isEmpty((String)detail.getNextProcId())) continue;
            firstDetail = detail;
            break;
        }
        return firstDetail;
    }

    public static RecoveryProcessor getLastRecoveryProcessor(Set<RecoveryProcessor> processors) {
        RecoveryProcessor lastProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (null != processor.getNextProcessor()) continue;
            lastProcessor = processor;
            break;
        }
        return lastProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAllMoNameMap(List<String> uuidList) {
        Session session;
        HashMap<String, String> nameMap;
        block7: {
            nameMap = new HashMap<String, String>();
            session = null;
            try {
                NativeQuery query;
                List results;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder querSQL = new StringBuilder();
                querSQL.append("select UUID,NAME from T_managedobject");
                if (!VerifyUtil.isEmpty(uuidList)) {
                    querSQL.append(" where UUID in (");
                    for (int i = 0; i < uuidList.size(); ++i) {
                        String uuid = uuidList.get(i);
                        querSQL.append("'" + StringEscapeUtil.escapeSql((String)uuid) + "'");
                        if (i >= uuidList.size() - 1) continue;
                        querSQL.append(",");
                    }
                    querSQL.append(")");
                }
                if (VerifyUtil.isEmpty((Collection)(results = (query = session.createSQLQuery(querSQL.toString())).list()))) break block7;
                for (Object object : results) {
                    Object[] values;
                    if (!(object instanceof Object[]) || (values = (Object[])object).length < 2) continue;
                    String uuid = String.valueOf(values[0]);
                    String name = String.valueOf(values[1]);
                    nameMap.put(uuid, name);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query queryReplicaProps!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return nameMap;
    }
}

