/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.license.sdk.IDRVMPlatinicInter;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service(Name="ILicenseControl", Desc="", Interface=ILicenseControl.class)
public class LicenseControlImpl
extends DrmBaseService
implements ILicenseControl {
    private final transient Log logger = LogFactory.getInstance(LicenseControlImpl.class);
    private IDRVMPlatinicInter vmPlatinicService = null;
    private ILicenseInter licenseService = null;
    private ISoftwareInfoService softInfoService = null;

    public void isEnableCreateProtectGroup(int ptType) {
        this.logger.debug((Object)("ptType->" + ptType), 90160758786816L);
    }

    public void isEnableRecoveryPlan(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            this.logger.debug((Object)"pg is null", 90160758786816L);
            return;
        }
        this.logger.debug((Object)("pgid->" + protectGroup.getUuid()), 90160758786816L);
        this.checkEnablePgCount(protectGroup);
    }

    public boolean isLicenseLegal() {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            return !this.licenseService.isLicenseProbationTimeout();
        }
        return true;
    }

    private boolean isVmPg(ProtectGroup protectGroup) {
        return 10 == protectGroup.getPoType() || 12 == protectGroup.getPoType();
    }

    private void checkDRVMPlatinic(ProtectGroup protectGroup) {
        if (null == this.vmPlatinicService) {
            throw new LegoCheckedException(1073947430L);
        }
        if (!this.vmPlatinicService.isDRVMPlatinic(protectGroup)) {
            throw new LegoCheckedException(1073947430L);
        }
        this.logger.debug((Object)"isDRVMPlatinic true");
    }

    public void checkEnablePgTopo(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            this.logger.error((Object)"pg is null");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa || "UltraVR".equals(softInfo.getProductModel())) {
            this.logger.debug((Object)("softInfo.getProductModel() is VR,pgName:" + protectGroup.getName()));
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            this.logger.debug((Object)("licenseBo is null,pgName:" + protectGroup.getName()));
            if (this.licenseService.isLicenseProbationTimeout()) {
                this.logger.debug((Object)("check DRVMPlatinic,pgName:" + protectGroup.getName()));
                this.checkDRVMPlatinic(protectGroup);
            }
        } else if (this.isVmPg(protectGroup)) {
            this.logger.debug((Object)("pg is vm,pgName:" + protectGroup.getName()));
            if (!this.isHaveLicenseResItem("LSTQDPMP") && !this.isHaveCloudLicenseRes()) {
                this.logger.debug((Object)("check DRVMPlatinic,pgName:" + protectGroup.getName()));
                this.checkDRVMPlatinic(protectGroup);
            }
        } else if (!this.isHaveLicenseResItem("LSTQDPMN")) {
            this.logger.error((Object)"pg:%s is host type, but has no license.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947430L);
        }
    }

    public void checkHasOneLic(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            this.logger.error((Object)"pg is null");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa || "UltraVR".equals(softInfo.getProductModel())) {
            this.logger.debug((Object)("softInfo.getProductModel() is VR,pgName:" + protectGroup.getName()));
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            this.logger.debug((Object)("licenseBo is null,pgName:" + protectGroup.getName()));
            if (this.licenseService.isLicenseProbationTimeout()) {
                this.logger.debug((Object)("check DRVMPlatinic,pgName:" + protectGroup.getName()));
                this.checkDRVMPlatinic(protectGroup);
            }
        }
    }

    public void checkEnablePgCount(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            this.logger.error((Object)"pg is null");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa || "UltraVR".equals(softInfo.getProductModel())) {
            this.logger.debug((Object)("softInfo.getProductModel() is VR,pgName:" + protectGroup.getName()));
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            this.logger.debug((Object)("licenseBo is null,pgName:" + protectGroup.getName()));
            if (this.licenseService.isLicenseProbationTimeout()) {
                this.logger.debug((Object)("license probation is timeout,check DRVMPlatinic,pgName:" + protectGroup.getName()));
                this.checkDRVMPlatinic(protectGroup);
            }
        } else if (this.isVmPg(protectGroup)) {
            this.logger.debug((Object)("pg is vm,pgName:" + protectGroup.getName()));
            if (null == this.vmPlatinicService) {
                throw new LegoCheckedException(1073947430L);
            }
            if (!this.vmPlatinicService.isDRVMPlatinic(protectGroup)) {
                this.logger.debug((Object)("check DRVMPlatinic,pgName:" + protectGroup.getName()));
                int templateType = protectGroup.getTemplate().getType();
                String licResType = this.covertTemplateTypeToLicType(templateType);
                this.checkLicenseEnableWithCount(licResType, 0);
            }
        } else {
            this.logger.debug((Object)("pg is host,pgName:" + protectGroup.getName()));
            this.checkLicenseEnableWithCount("LSTQDPMN", 0);
        }
    }

    private String covertTemplateTypeToLicType(int templateType) {
        String typeLicStr;
        switch (templateType) {
            case 25: {
                typeLicStr = "LSTQCSHA";
                break;
            }
            case 29: {
                typeLicStr = "LSTQVHA";
                break;
            }
            case 21: 
            case 22: {
                typeLicStr = "LSTQCSDR";
                break;
            }
            default: {
                typeLicStr = "LSTQDPMP";
            }
        }
        return typeLicStr;
    }

    public boolean isHaveLicenseResItem(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            return false;
        }
        ResourceItemBo resItem = this.getResControlBean(licenseBo, type);
        return null != resItem;
    }

    public boolean isEnableVisTopo() {
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa || "UltraVR".equals(softInfo.getProductModel())) {
            return true;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo ? (this.vmPlatinicService == null || !this.vmPlatinicService.isDRVMPlatinic()) && this.licenseService.isLicenseProbationTimeout() : !this.isStandardLicense(licenseBo)) {
            throw new LegoCheckedException(1073947430L);
        }
        return true;
    }

    private boolean isLicenseNoNumControl() {
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        return null == licenseBo && !this.licenseService.isLicenseProbationTimeout() || "UltraVR".equals(softInfo.getProductModel()) || isVasa;
    }

    public void checkLicenseEnable(String type, int count) {
        this.logger.info((Object)("checkLicenseEnable: licenseType:" + type + ", count:" + count), 90160758786816L);
        if (this.licenseService.isBasicVersion()) {
            this.logger.info((Object)"checkLicenseEnable: License is a basic version.");
            return;
        }
        this.checkLicenseEnableWithCount(type, count);
    }

    public void checkLicenseEnableWithCount(String type, int count) {
        if (this.isLicenseNoNumControl()) {
            this.logger.debug((Object)"not check License Enable.");
            return;
        }
        if (!this.isLicenseEnable(type, count)) {
            this.logger.error((Object)"license is not enough.");
            throw new LegoCheckedException(1073947451L);
        }
    }

    private boolean isLicenseEnable(String type, int count) {
        if ("LSTQVHA_CSDR".equals(type)) {
            if (!this.checkLicenseNumber("LSTQCSDR", count)) {
                return false;
            }
            return this.checkLicenseNumber("LSTQVHA", count);
        }
        if ("LSTQCSHA_CSDR".equals(type)) {
            if (!this.checkLicenseNumber("LSTQCSDR", count)) {
                return false;
            }
            return this.checkLicenseNumber("LSTQCSHA", count);
        }
        return this.checkLicenseNumber(type, count);
    }

    private boolean checkLicenseNumber(String type, int count) {
        ResourceItemBo resItem = this.countResConsumeNum(type);
        if (null == resItem) {
            return false;
        }
        if (0L != resItem.getErrorCode()) {
            throw new LegoCheckedException(resItem.getErrorCode(), resItem.getParameters());
        }
        int licenseCount = NumberUtil.parseInteger((Object)resItem.getItemValue());
        int useCount = NumberUtil.parseInteger((Object)resItem.getConsumeNum());
        this.logger.info((Object)"License number check.Type : %s ,count: %s, consumeNum : %s,licenseCount: %s", new Object[]{type, count, useCount, licenseCount});
        if (count + useCount > licenseCount) {
            this.logger.error((Object)"license: %s is not enough.", new Object[]{type});
            return false;
        }
        return true;
    }

    private ResourceItemBo countResConsumeNum(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            return null;
        }
        ResourceItemBo resItem = this.getResControlBean(licenseBo, type);
        if (this.isCloudType(type) && !this.isHaveCloudLicenseRes(licenseBo)) {
            resItem = this.getResControlBean(licenseBo, "LSTQDPMP");
        }
        if (null == resItem) {
            resItem = new ResourceItemBo();
            resItem.setItemName(type);
            resItem.setItemValue("0");
        }
        ArrayList<ResourceItemBo> resList = new ArrayList<ResourceItemBo>();
        resList.add(resItem);
        this.licenseService.countResUseNum(resList);
        return resItem;
    }

    public boolean isHaveCloudLicenseRes() {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return this.isHaveCloudLicenseRes(licenseBo);
    }

    private boolean isHaveCloudLicenseRes(LicenseInfoBo licenseBo) {
        return this.getResControlBean(licenseBo, "LSTQCSHA") != null || this.getResControlBean(licenseBo, "LSTQCSDR") != null || this.getResControlBean(licenseBo, "LSTQVHA") != null;
    }

    private boolean isCloudType(String type) {
        return "LSTQCSHA".equals(type) || "LSTQCSDR".equals(type) || "LSTQVHA".equals(type);
    }

    public void checkLicenseOutOfControlAlarm() {
        this.checkLicenseOutOfControlAlarm(false);
    }

    public void checkLicenseOutOfControlAlarm(boolean isClear) {
        try {
            LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
            if (null == licenseBo) {
                return;
            }
            if (!this.isLicenseEnable("LSTQDPMN", 0) || !this.isLicenseEnable("LSTQDPMP", 0)) {
                ResourceItemBo hostItem = this.countResConsumeNum("LSTQDPMN");
                ResourceItemBo vmItem = this.countResConsumeNum("LSTQDPMP");
                this.generateLicenseAlarm(hostItem, vmItem);
            } else if (isClear) {
                this.logger.debug((Object)"clear alarm , alerm id :52625439");
                AlarmReporter.restoreAlarm(52625439L, "");
                this.logger.debug((Object)"clear alarm , alerm id :52625481");
                AlarmReporter.restoreAlarm(52625481L, "FLAG_SYSTEM_PROBATION_TIMEOUT_ALARM");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("check license alarm fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    public void checkLicenseRestoreAlarm() {
        try {
            if (this.isLicenseEnable("LSTQDPMN", 0) && this.isLicenseEnable("LSTQDPMP", 0)) {
                AlarmReporter.restoreAlarm(52625439L, "");
            }
            if (this.isLicenseEnable("LSTQVHA", 0) && this.isLicenseEnable("LSTQCSHA", 0) && this.isLicenseEnable("LSTQCSDR", 0)) {
                AlarmReporter.restoreAlarm(52625480L, "");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("restore license alarm fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private void generateLicenseCloudAlarm(ResourceItemBo vhaItem, ResourceItemBo cshaItem, ResourceItemBo csdrItem) {
        if (null == vhaItem || null == cshaItem || null == csdrItem) {
            this.logger.debug((Object)"vhaItem or cshaItem or csdrItem is null.", 90160758787071L);
            return;
        }
        String[] alramParams = new String[]{vhaItem.getConsumeNum(), cshaItem.getConsumeNum(), csdrItem.getConsumeNum(), vhaItem.getItemValue(), cshaItem.getItemValue(), csdrItem.getItemValue()};
        AlarmReporter.sendLicenseAlarmForParamsNoRepeat(52625480L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alramParams);
    }

    private void generateLicenseAlarm(ResourceItemBo hostItem, ResourceItemBo vmItem) {
        if (null == hostItem || null == vmItem) {
            this.logger.debug((Object)"hostItem or vmItem is null.", 90160758787071L);
            return;
        }
        String[] alramParams = new String[]{hostItem.getConsumeNum(), vmItem.getConsumeNum(), hostItem.getItemValue(), vmItem.getItemValue()};
        AlarmReporter.sendLicenseAlarmForParamsNoRepeat(52625439L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alramParams);
    }

    private boolean isStandardLicense(LicenseInfoBo licenseBo) {
        FeatureBo fitem;
        List resourceItemBoList;
        if (licenseBo.getFeaBolst() != null && !licenseBo.getFeaBolst().isEmpty() && (resourceItemBoList = (fitem = (FeatureBo)licenseBo.getFeaBolst().get(0)).getReslst()) != null && !resourceItemBoList.isEmpty()) {
            this.logger.debug((Object)"this is a StandardLicense");
            return true;
        }
        return false;
    }

    private ResourceItemBo getResControlBean(LicenseInfoBo licenseBo, String resName) {
        List fitems = licenseBo.getFeaBolst();
        if (null == fitems) {
            this.logger.error((Object)"fea bo list is empty", 90160758787071L);
            return null;
        }
        try {
            for (FeatureBo fitem : fitems) {
                List resList = fitem.getReslst();
                if (resList == null || resList.isEmpty()) continue;
                for (ResourceItemBo item : resList) {
                    if (!resName.equals(item.getItemName())) continue;
                    return item;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get ResourceItemBo fail" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return null;
    }

    public void onBindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = service;
        this.logger.info((Object)("onBindDRVMPlatinic->" + this.vmPlatinicService), 90160758786816L);
    }

    public void onUnbindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = null;
        this.logger.info((Object)("onUnbindDRVMPlatinic->" + service), 90160758786816L);
    }

    public ILicenseInter getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(ILicenseInter licenseService) {
        this.licenseService = licenseService;
    }

    public ISoftwareInfoService getSoftInfoService() {
        return this.softInfoService;
    }

    public void setSoftInfoService(ISoftwareInfoService softInfoService) {
        this.softInfoService = softInfoService;
    }
}

