/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.calculator;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.calculator.RPOUtil;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.ExpectedRPO;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.ConfigRPOBean;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public abstract class BaseRecoveryPointObjectiveCalculator
implements IRecoveryPointObjectiveCalculator {
    private static Log logger = LogFactory.getInstance(BaseRecoveryPointObjectiveCalculator.class);
    private static final long SECOND = 1000L;
    private static final long SIXTY = 60L;
    private static final long TWENTYFOURE = 24L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final double RATE = 0.9;

    public Map<String, Object> calculate(RPOContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        if (null == protectGroup) {
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> rpoResults = new HashMap<String, Object>();
        String pgMsg = "pgId:" + protectGroup.getUuid() + ",Name:" + protectGroup.getName();
        Map<String, Object> configuredRPOs = this.calcConfiguredRPO(context);
        if (VerifyUtil.isEmpty(configuredRPOs)) {
            logger.error((Object)("No configured Rpo. " + pgMsg), 90160758784001L);
            return rpoResults;
        }
        Map<String, Object> actualRPOs = this.calcActualRPO(context);
        if (VerifyUtil.isEmpty(actualRPOs)) {
            logger.error((Object)("No actual Rpo. " + pgMsg), 90160758784001L);
            actualRPOs = new HashMap<String, Object>();
        }
        JSONArray rpoJsonArray = new JSONArray();
        for (Map.Entry<String, Object> entry : configuredRPOs.entrySet()) {
            JSONObject rpoJsonObject = new JSONObject();
            rpoJsonObject.put((Object)"siteId", (Object)this.getSiteId(entry.getKey()));
            rpoJsonObject.put((Object)"productSiteId", this.getProductSiteId(entry.getKey()));
            rpoJsonObject.put((Object)"protectedType", this.getProtectedType(entry.getKey()));
            rpoJsonObject.put((Object)"configuredRPO", entry.getValue());
            if (null == actualRPOs.get(entry.getKey())) continue;
            rpoJsonObject.put((Object)"actualRPO", actualRPOs.get(entry.getKey()));
            rpoJsonArray.add((Object)rpoJsonObject);
        }
        rpoResults.put("RPO_ITEM_KEY", rpoJsonArray.toString());
        logger.info((Object)("ProtectGroup info:[" + pgMsg + "],RPO result : [" + rpoJsonArray + "]."), 90160758786816L);
        return rpoResults;
    }

    protected Object getProductSiteId(String key) {
        logger.debug((Object)"use default method[getProductSiteId]");
        return "--";
    }

    protected Object getProtectedType(String key) {
        logger.debug((Object)"use default method[getProtectedType]");
        return "--";
    }

    protected abstract Map<String, Object> calcConfiguredRPO(RPOContext var1);

    protected abstract Map<String, Object> calcActualRPO(RPOContext var1);

    public Boolean isNeedRpoEarlyAlarm(RPOContext context) {
        logger.debug((Object)"use default method[isNeedRpoEarlyAlarm]");
        return true;
    }

    protected Long getLastSuccessExcTime(ProtectGroup protectGroup, String replicaId) {
        return RPOUtil.getLastSuccessExcTime(protectGroup, replicaId);
    }

    protected Boolean checkRpoEarlyAlarm(ProtectGroup protectGroup, String replicaId) {
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        List<ProtectGroupLog> pgLogs = this.getRecentFourSuccessfulLog(protectGroup, replicaId);
        if (null == pgLogs || pgLogs.size() < 4) {
            logger.debug((Object)"pgLogs is empty! or the pgLogs size is less than four!");
            return false;
        }
        List<Long> allTime = this.getAllLogStartTime(protectGroup, pgLogs, replicaId);
        ArrayList<Long> oneGroupTime = new ArrayList<Long>();
        int count = 0;
        for (int i = 1; i <= allTime.size(); ++i) {
            long t3;
            double period;
            long time = allTime.get(i - 1);
            oneGroupTime.add(time);
            if (i == 1 || i % 3 != 0) continue;
            long t1 = (Long)oneGroupTime.get(0);
            long t2 = (Long)oneGroupTime.get(1);
            double duration = t2 - t1;
            double percent = duration / (period = (double)((t3 = ((Long)oneGroupTime.get(2)).longValue()) - t1));
            if (percent >= 0.9) {
                ++count;
            }
            oneGroupTime.clear();
        }
        if (count == 3) {
            logger.warn((Object)"the count is more than three! so need to send alarm!");
            return true;
        }
        return false;
    }

    private List<Long> getAllLogStartTime(ProtectGroup protectGroup, List<ProtectGroupLog> protectGroupLogs, String replicaId) {
        ArrayList<Long> allTimes = new ArrayList<Long>();
        for (int i = 3; i > 0; --i) {
            ProtectGroupLog log = protectGroupLogs.get(i);
            allTimes.add(NumberUtil.convertToLong((Object)log.getStartTime()));
            allTimes.add(NumberUtil.convertToLong((Object)log.getEndTime()));
            ProtectGroupLog recentLog = this.getRecentLog(protectGroup, replicaId, log);
            if (null == recentLog) continue;
            allTimes.add(NumberUtil.convertToLong((Object)recentLog.getStartTime()));
        }
        return allTimes;
    }

    private List<ProtectGroupLog> getRecentFourSuccessfulLog(ProtectGroup protectGroup, String replicaId) {
        List result = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectGroupLog.class);
            crit.add((Criterion)Restrictions.eq((String)"flag", (Object)1)).add((Criterion)Restrictions.eq((String)"result", (Object)Long.valueOf("1")));
            crit.add((Criterion)Restrictions.eq((String)"pgId", (Object)protectGroup.getUuid()));
            if (!VerifyUtil.isEmpty((String)replicaId)) {
                crit.add((Criterion)Restrictions.like((String)"replicaId", (Object)("%" + replicaId + "%")));
            }
            crit.addOrder(Order.desc((String)"startTime"));
            crit.setMaxResults(4);
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    private ProtectGroupLog getRecentLog(ProtectGroup protectGroup, String replicaId, ProtectGroupLog log) {
        List result = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectGroupLog.class);
            crit.add((Criterion)Restrictions.eq((String)"flag", (Object)1)).add((Criterion)Restrictions.eq((String)"result", (Object)Long.valueOf("1")));
            crit.add((Criterion)Restrictions.eq((String)"pgId", (Object)protectGroup.getUuid()));
            if (!VerifyUtil.isEmpty((String)replicaId)) {
                crit.add((Criterion)Restrictions.like((String)"replicaId", (Object)("%" + replicaId + "%")));
            }
            crit.add((Criterion)Restrictions.gt((String)"startTime", (Object)log.getStartTime()));
            crit.addOrder(Order.asc((String)"startTime"));
            crit.setMaxResults(1);
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        if (result != null && !result.isEmpty()) {
            return (ProtectGroupLog)result.get(0);
        }
        return null;
    }

    protected int getStorageStatus(String sn) {
        String status;
        logger.debug((Object)("sn:" + sn));
        DrResource drResource = TopoServiceUtil.getDrResource(sn);
        if (drResource != null && !VerifyUtil.isEmpty((String)(status = drResource.getStatus()))) {
            return NumberUtil.convertToInteger((Object)status, (int)-3);
        }
        return -3;
    }

    protected Site getSiteByResourceSN(String sn) {
        logger.debug((Object)("sn:" + sn));
        DrResource drResource = TopoServiceUtil.getDrResource(sn);
        if (drResource == null) {
            logger.warn((Object)("drResource is null. sn:" + sn));
            return null;
        }
        String srcSiteId = drResource.getSiteId();
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(srcSiteId);
        return site;
    }

    protected String getSiteId(String str) {
        logger.debug((Object)("use default method[getSiteId]. str:" + str));
        return str;
    }

    protected ProtectGroupReplica getLatestActivatedReplica(List<ProtectGroupReplica> pgReplicas) {
        if (VerifyUtil.isEmpty(pgReplicas)) {
            logger.error((Object)"pgReplicas is empty! ", 90160758787071L);
            return null;
        }
        ArrayList<ProtectGroupReplica> activePgReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (pgReplica.getStatus() != DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue()) continue;
            activePgReplicas.add(pgReplica);
        }
        if (VerifyUtil.isEmpty(activePgReplicas)) {
            logger.warn((Object)"activePgReplicas is empty!", 90160758787071L);
            return null;
        }
        Collections.sort(activePgReplicas);
        return (ProtectGroupReplica)activePgReplicas.get(activePgReplicas.size() - 1);
    }

    protected ProtectGroupReplica getLatestActivatedReplica(List<ProtectGroupReplica> pgReplicas, int protectedType) {
        if (VerifyUtil.isEmpty(pgReplicas)) {
            logger.error((Object)"pgReplicas is empty! ", 90160758787071L);
            return null;
        }
        ArrayList<ProtectGroupReplica> activePgReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (pgReplica.getStatus() != DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() || !ScheduleProtectedType.isSameType((int)pgReplica.getType(), (int)protectedType)) continue;
            activePgReplicas.add(pgReplica);
        }
        if (VerifyUtil.isEmpty(activePgReplicas)) {
            logger.warn((Object)"activePgReplicas is empty!", 90160758787071L);
            return null;
        }
        Collections.sort(activePgReplicas);
        return (ProtectGroupReplica)activePgReplicas.get(activePgReplicas.size() - 1);
    }

    protected void loadProtectGroupReplica(ProtectGroup protectGroup) {
        logger.debug((Object)("protectGroup name:" + protectGroup.getName() + ", uuid:" + protectGroup.getUuid()));
        List replicaList = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(protectGroup.getUuid(), null, false, null);
        protectGroup.getReplicaList().clear();
        protectGroup.getReplicaList().addAll(replicaList);
    }

    protected long getConfigRPO(ExpectedRPO expectedRPO) {
        if (VerifyUtil.isEmpty((Object)expectedRPO)) {
            logger.debug((Object)"expectedRPO is empty!");
            return -3L;
        }
        return expectedRPO.getExpectedRPOValue();
    }

    protected long getConfigRPO(Map<String, String> props, int protectLocation) {
        if (VerifyUtil.isEmpty(props)) {
            logger.debug((Object)"props is empty!");
            return -3L;
        }
        String configRpoStr = props.get("RPO_SETTINGS");
        List configRpoList = ConfigRPOBean.str2Bean((String)configRpoStr);
        if (VerifyUtil.isEmpty((Collection)configRpoList)) {
            logger.debug((Object)("configRpoList is empty!configRpoStr:" + configRpoStr));
            return -3L;
        }
        for (ConfigRPOBean rpoBean : configRpoList) {
            String protectLocationStrA = rpoBean.getProtectLocation();
            String protectLocationStrB = "ProtectLocation_" + protectLocation;
            boolean enableRPOChecking = rpoBean.isEnableRPOChecking();
            if (!enableRPOChecking || !protectLocationStrB.equals(protectLocationStrA)) continue;
            long day = rpoBean.getDay();
            long hour = rpoBean.getHour();
            long minute = rpoBean.getMinute();
            long configRpoValue = day * 86400000L + hour * 3600000L + minute * 60000L;
            return configRpoValue;
        }
        return -3L;
    }
}

