/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.checker.sdk.service.IProtectionChecker;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.util.RPOMeetCaculator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RecoveryPointObjectiveChecker
implements IProtectionChecker {
    private static final Log logger = LogFactory.getInstance(RecoveryPointObjectiveChecker.class);
    private static RecoveryPointObjectiveChecker rpoChecker = new RecoveryPointObjectiveChecker();
    private Map<String, IRecoveryPointObjectiveCalculator> rpoCalculators = new HashMap<String, IRecoveryPointObjectiveCalculator>();

    private RecoveryPointObjectiveChecker() {
    }

    public static RecoveryPointObjectiveChecker getInstance() {
        return rpoChecker;
    }

    public Map<String, Object> check(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"Invalid parameter for RPO checker: pg is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String templateType = String.valueOf(protectGroup.getTemplate().getType());
        IRecoveryPointObjectiveCalculator rpoCalculator = this.rpoCalculators.get(templateType);
        if (null == rpoCalculator) {
            logger.info((Object)"There is no RPO calculator for pg: %s, type:%s", new Object[]{protectGroup.getName(), templateType});
            return new HashMap<String, Object>();
        }
        RPOContext context = new RPOContext();
        context.addObject("PG_ENTITY", (Object)protectGroup);
        try {
            Map results = rpoCalculator.calculate(context);
            Object rpoStr = results.get("RPO_ITEM_KEY");
            if (VerifyUtil.isEmpty(rpoStr)) {
                logger.error((Object)"RPO_ITEM_KEY value is null!", 90160758787071L);
                return results;
            }
            JSONArray rpoJsonArray = JSONArray.fromObject(rpoStr);
            this.dealRpoNotOkAlarm(protectGroup, rpoJsonArray);
            Boolean isNeedRpoEarlyAlarm = rpoCalculator.isNeedRpoEarlyAlarm(context);
            if (isNeedRpoEarlyAlarm != null) {
                this.dealRpoEarlyAlarm(protectGroup, isNeedRpoEarlyAlarm);
            }
            return results;
        }
        catch (Exception e) {
            String errorMsg = "pgId:" + protectGroup.getUuid() + ",Name:" + protectGroup.getName();
            logger.error((Object)("calculate rpo and deal alarm error~!" + errorMsg + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return new HashMap<String, Object>();
        }
    }

    public String getName() {
        return RecoveryPointObjectiveChecker.class.getName();
    }

    public void onBind(IRecoveryPointObjectiveCalculator calculator, Map<?, ?> properties) {
        if (null == calculator || VerifyUtil.isEmpty((Collection)calculator.getTypes())) {
            logger.debug((Object)"NO onbind,calculator is null or calculator type is null.");
            return;
        }
        for (String supportedType : calculator.getTypes()) {
            this.rpoCalculators.put(supportedType, calculator);
        }
    }

    public void onUnbind(IRecoveryPointObjectiveCalculator calculator, Map<?, ?> properties) {
        for (String supportedType : calculator.getTypes()) {
            this.rpoCalculators.remove(supportedType);
        }
    }

    protected IRecoveryPointObjectiveCalculator getRPOCalculatorByType(String type) {
        return this.rpoCalculators.get(type);
    }

    protected void dealRpoEarlyAlarm(ProtectGroup protectGroup, Boolean isOk) {
        if (isOk.booleanValue()) {
            AlarmReporter.restoreAlarm(52625431L, protectGroup.getUuid());
        } else {
            AlarmReporter.sendAlarm(52625431L, protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MINOR, protectGroup.getUuid(), protectGroup.getName(), "--", "--");
        }
    }

    protected void dealRpoNotOkAlarm(ProtectGroup protectGroup, JSONArray rpoJsonArray) {
        int meetStatus = RPOMeetCaculator.calculateSinglePgRPOMet((JSONArray)rpoJsonArray);
        if (meetStatus == -1) {
            this.generatePGNotMeetAlarm(protectGroup);
        } else {
            AlarmReporter.restoreAlarm(52625430L, protectGroup.getUuid());
        }
    }

    protected void generatePGNotMeetAlarm(ProtectGroup pg) {
        AlarmReporter.sendAlarm(52625430L, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MAJOR, pg.getUuid(), pg.getName(), "--", "--");
    }
}

