/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.checker.manager.AbRateConfigBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:0##3_1##5_1")
public class RateConfigByPosiServiceImpl
extends AbRateConfigBaseService
implements IRateConfigService {
    private static Log logger = LogFactory.getInstance(RateConfigByPosiServiceImpl.class);

    public void modifyRate(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"pg or protectionLocation is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int times1 = 0;
        while (true) {
            if (times1 >= 3) {
                AlarmReporter.sendAlarm(52625438L, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MINOR, pg.getUuid(), pg.getName());
                break;
            }
            try {
                this.syncRateByReplicationPair(speedLevel, pg);
                AlarmReporter.restoreAlarm(52625438L, pg.getUuid(), pg.getName());
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("cannot alter ArrayRate..." + pg.getName()), e.getErrorCode());
                ++times1;
                CommonUtil.sleep((long)60000L);
                continue;
            }
            break;
        }
    }

    private List<ReplicationPair> getPair(ProtectGroup pg, String devSn) {
        List<ReplicationPair> nasPair;
        List<ReplicationPair> lunPair;
        ArrayList<ReplicationPair> pairs = new ArrayList<ReplicationPair>();
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : pg.getPolist()) {
            protectObjects.add(protectObject);
        }
        List<ProtectObjectStorageInfo> allStorageInfo = this.getAllStorageInfo(protectObjects);
        HashSet<String> lunIdSet = new HashSet<String>();
        HashSet<String> nasIdSet = new HashSet<String>();
        for (ProtectObjectStorageInfo posi : allStorageInfo) {
            if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue()) {
                nasIdSet.add(posi.getResourceId());
                continue;
            }
            lunIdSet.add(posi.getResourceId());
        }
        ArrayList<String> lunIdList = new ArrayList<String>();
        lunIdList.addAll(lunIdSet);
        ArrayList<String> nasIdList = new ArrayList<String>();
        nasIdList.addAll(nasIdSet);
        if (!VerifyUtil.isEmpty(lunIdList) && !VerifyUtil.isEmpty(lunPair = this.getPairsByLun(lunIdList, devSn, DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()))) {
            pairs.addAll(lunPair);
        }
        if (!VerifyUtil.isEmpty(nasIdList) && !VerifyUtil.isEmpty(nasPair = this.getPairsByLun(lunIdList, devSn, DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()))) {
            pairs.addAll(nasPair);
        }
        return pairs;
    }

    private String getDevSn(ProtectGroup pg) {
        Set polist = pg.getPolist();
        Iterator iterator = polist.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        ProtectObject po = (ProtectObject)iterator.next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        Iterator usedStorageIterator = usedStorageResourceSet.iterator();
        if (!usedStorageIterator.hasNext()) {
            return "";
        }
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)usedStorageIterator.next();
        logger.debug((Object)("getDevSn end. providerSN:" + storageInfo.getResourceProviderSN()));
        return storageInfo.getResourceProviderSN();
    }

    private void syncRateByReplicationPair(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg) {
        String devSn = this.getDevSn(pg);
        List<ReplicationPair> pairs = this.getPair(pg, devSn);
        if (VerifyUtil.isEmpty(pairs)) {
            logger.warn((Object)("pairs is empty. devSn:" + devSn));
            throw new LegoCheckedException(2117645L);
        }
        for (ReplicationPair replicationPair : pairs) {
            boolean isCg;
            String pairId;
            if (replicationPair.getReplicationMode().intValue() != XveEnumDefinePParent.RM_MODEL_E.RM_MODEL_SYNC.getValue()) continue;
            String consistentGroupId = replicationPair.getConsistentGroupId();
            if (null != consistentGroupId && !"--".equals(consistentGroupId)) {
                pairId = consistentGroupId;
                isCg = true;
            } else {
                pairId = replicationPair.getReplicationId();
                isCg = false;
            }
            this.changeSyncRateByPosi(speedLevel, devSn, pairId, isCg, replicationPair);
        }
    }

    private void changeSyncRateByPosi(DmEnumDefine.SPEED_LEVEL_E speedLevel, String devSn, String pairId, boolean isCg, ReplicationPair replicationPair) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            logger.error((Object)"drResource is null");
            throw new LegoCheckedException(2117645L);
        }
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        proxy.changeRate(devSn, pairId, isCg, speedLevel);
        if (!isCg) {
            this.alterAndSaveSpeedLevel(replicationPair.getRepTgtLuns(), speedLevel);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("replicationId", pairId);
            props.put("srcDevSN", devSn);
            List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationGroup.class, props);
            this.alterAndSaveCGSpeedLevel(groups, speedLevel);
        }
    }
}

