/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class BaseAsyncReplicateAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BaseAsyncReplicateAction.class);
    private static final int SPITE_STATUS = 26;

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseAsyncReplicateAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        this.setProtectGroupReplicaTimestamp(context);
        boolean execRes = this.asyncReplicate(context);
        if (!execRes) {
            this.setFailedTask(context);
        }
        return execRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean asyncReplicate(ActionContext context) {
        boolean bl;
        boolean flag = false;
        List<ReplicationRelationBo> bos = this.getReplicationRelationBos(context);
        try {
            if (this.checkSyncReplicationRelation(bos)) {
                boolean bl2 = true;
                return bl2;
            }
            if (!this.checkReplicationRelation(bos)) {
                boolean bl3 = flag;
                return bl3;
            }
            IRecoveryProcessHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            boolean isVstoreReplicationPair = this.isVstoreScenarioAndHandleReplications(bos, context);
            for (ReplicationRelationBo obj : bos) {
                logger.info((Object)("begin to sync once {srcSN:" + obj.getSrcDeviceSn() + ",tgtSN:" + obj.getTgtDeviceSn() + ",mirrorID:" + obj.getReplicationId() + ",isConsistGroup:" + obj.isConsistentGroup() + "}"), 90160758786988L);
                OperationResultBill optResultBill = this.synchronize(isVstoreReplicationPair, obj, recoveryProcHandler);
                if (null != optResultBill && optResultBill.isHasFailRecord() && !VerifyUtil.isEmpty((Collection)optResultBill.getOperationResults())) {
                    OperationResult optResult = (OperationResult)optResultBill.getOperationResults().get(0);
                    logger.error((Object)("sync mirror failed.the error code is " + optResult.getErrorCode()), 90160758786989L);
                    this.setDetail("lego.err." + optResult.getErrorCode());
                    boolean bl4 = flag;
                    return bl4;
                }
                logger.info((Object)("End to sync once:" + obj.getReplicationId()), 90160758786988L);
            }
            logger.info((Object)"BaseAsyncReplicateAction end to execute!", 90160758786988L);
            boolean bl5 = flag = true;
            return bl5;
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", e.getErrorCode());
            bl = flag;
            return bl;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948448");
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", 1073948448L);
            bl = flag;
            return bl;
        }
        finally {
            this.setPos(context, flag);
        }
    }

    private boolean isVstoreScenarioAndHandleReplications(List<ReplicationRelationBo> relationBos, ActionContext context) {
        Optional optional = context.getProtectGroup();
        if (VerifyUtil.isEmpty(relationBos) || !optional.isPresent()) {
            return false;
        }
        ProtectGroup protectGroup = (ProtectGroup)optional.get();
        String vStoreReplicationPairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_REPLICATION_PAIR_ID");
        if (VerifyUtil.isEmpty((String)vStoreReplicationPairId)) {
            logger.info((Object)"Normal replication pair synchronization scenario.");
            return false;
        }
        IRecoveryProcessHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        ReplicationRelationBo tempRelationBo = relationBos.get(0);
        Iterator<ReplicationRelationBo> iterator = relationBos.iterator();
        while (iterator.hasNext()) {
            ReplicationRelationBo relationBo = iterator.next();
            ReplicationRelation replicationRelation = recoveryProcHandler.queryReplication(relationBo);
            if (!(replicationRelation instanceof ReplicationPair)) {
                logger.error((Object)"Can't cast ReplicationRelation{%s} to ReplicationPair", new Object[]{replicationRelation.getReplicationId()});
                throw new LegoCheckedException(1073947394L);
            }
            ReplicationPair pair = (ReplicationPair)replicationRelation;
            if (!vStoreReplicationPairId.equals(pair.getVstorePairId())) {
                logger.error((Object)"The replication vStore pair of the replication pair {%s} is not equal with {%s}", new Object[]{pair.getReplicationId(), vStoreReplicationPairId});
                throw new LegoCheckedException(1073948476L);
            }
            iterator.remove();
        }
        logger.info((Object)"Remote replication Vstore pair synchronization scenario: pair id is %s", new Object[]{vStoreReplicationPairId});
        tempRelationBo.setReplicationId(vStoreReplicationPairId);
        relationBos.add(tempRelationBo);
        return true;
    }

    private OperationResultBill synchronize(boolean isVstoreReplicationPair, ReplicationRelationBo relationBo, IRecoveryProcessHandler recoveryProcHandler) {
        String srcDeviceSn = relationBo.getSrcDeviceSn();
        String tgtDeviceSn = relationBo.getTgtDeviceSn();
        String replicationId = relationBo.getReplicationId();
        if (isVstoreReplicationPair) {
            logger.info((Object)"Start synchronizing replication vstore pair{%s}", new Object[]{replicationId});
            return recoveryProcHandler.synchronizeVstorePair(srcDeviceSn, tgtDeviceSn, replicationId);
        }
        logger.info((Object)"Start synchronizing normal replication pair{%s}", new Object[]{replicationId});
        return recoveryProcHandler.synchronize(replicationId, srcDeviceSn, tgtDeviceSn, relationBo.isConsistentGroup());
    }

    private void setPos(ActionContext context, boolean flag) {
        if (!flag && context.getContext().containsKey("FREEZE_PO_ENTITY")) {
            Set pos = (Set)context.getObject("FREEZE_PO_ENTITY");
            for (ProtectObject po : pos) {
                this.thaw(po);
            }
        }
    }

    private void setFailedTask(ActionContext context) {
        EnablePortTask task = (EnablePortTask)context.getObject("linkPortTaskInfo", EnablePortTask.class);
        AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
        Integer executionMode = (Integer)context.getObject("PG_EXECUTION_MODE", Integer.class);
        portUtil.consumeFailedAirGapTask(task, executionMode);
    }

    private void thaw(ProtectObject po) {
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        if (appManager != null) {
            appManager.thaw(po);
        } else {
            logger.error((Object)("appManager is null!poType:" + po.getPoType()));
        }
    }

    protected boolean checkReplicationRelation(List<ReplicationRelationBo> bos) {
        boolean flag = false;
        try {
            for (ReplicationRelationBo obj : bos) {
                if (!this.isSyncing(obj)) continue;
                this.setDetail("lego.err.1073948434");
                logger.error((Object)"Pair's status is syncing.", 1073948434L);
                return flag;
            }
            logger.info((Object)"BaseAsyncReplicateAction end to execute!", 90160758786988L);
            flag = true;
            return flag;
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            logger.error((Object)"BaseAsyncReplicateAction executed failed!", (Throwable)e, errorCode);
            return flag;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948448");
            logger.error((Object)("BaseAsyncReplicateAction executed failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948448L);
            return flag;
        }
    }

    protected boolean checkSyncReplicationRelation(List<ReplicationRelationBo> bos) {
        boolean rightStatus = true;
        block0: for (ReplicationRelationBo obj : bos) {
            if (obj.getSyncMode() == 2) {
                return false;
            }
            List<ReplicationTargetLun> targetLuns = this.getReplicationTargetLuns(obj);
            for (ReplicationTargetLun targetLun : targetLuns) {
                if (targetLun.getPairStatus() != 26) continue;
                rightStatus = false;
                continue block0;
            }
        }
        return rightStatus;
    }

    protected boolean isSyncing(ReplicationRelationBo obj) {
        List<ReplicationTargetLun> targetLuns = this.getReplicationTargetLuns(obj);
        for (ReplicationTargetLun targetLun : targetLuns) {
            if (2 != targetLun.getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue() && XveEuumDefineParent.RUNNING_STATUS_E.INITIAL_SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue()) continue;
            return true;
        }
        return false;
    }

    private List<ReplicationTargetLun> getReplicationTargetLuns(ReplicationRelationBo obj) {
        IRecoveryProcessHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        List targetLuns = recoveryProcHandler.querySyncStatus(obj.getSrcDeviceSn(), obj.getTgtDeviceSn(), obj.getReplicationId(), obj.isConsistentGroup());
        if (null == targetLuns || targetLuns.isEmpty()) {
            logger.error((Object)"Query Replication Target Lun error when check Sync state.", 1073948461L);
            throw new LegoCheckedException(1073948461L, "query Replication Target Lun error when check Sync state.");
        }
        return targetLuns;
    }

    private void setProtectGroupReplicaTimestamp(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        if (null == context.getObject("REPLICA_TIMESTANP")) {
            context.addObject("REPLICA_TIMESTANP", (Object)String.valueOf(new Date().getTime()));
        }
    }
}

