/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CreateNasSnapshotAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(CreateNasSnapshotAction.class);
    private ProtectGroup protectGroup = null;

    @Override
    public boolean doExecute(ActionContext context) {
        this.protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)"BaseNasSnapshotAction begin to execute,pgId: %s pgName: %s. Code: %d", new Object[]{this.protectGroup.getUuid(), this.protectGroup.getName(), 90160758786988L});
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(this.protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")));
        if (null == pgReplica) {
            logger.error((Object)"CreateNasSnapshotAction get replica error,pgId: %s pgName: %s.", new Object[]{this.protectGroup.getUuid(), this.protectGroup.getName()});
            this.setDetail("lego.err.2117645");
            return false;
        }
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        context.addObject("PO_REPLICA_ENTITY", (Object)pgReplica.getReplicas());
        return this.refreshSnapShort(context);
    }

    protected boolean refreshSnapShort(ActionContext context) {
        Set poReplicas = (Set)context.getObject("PO_REPLICA_ENTITY");
        SnapShotAssociateProtectObject apo = null;
        Iterator iterator = poReplicas.iterator();
        if (iterator.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)iterator.next();
            for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
                String srcArraySN = stor.getStorageProviderSN();
                if (VerifyUtil.isEmpty((String)srcArraySN)) continue;
                apo = new SnapShotAssociateProtectObject();
                apo.setSrcStorageProviderSN(srcArraySN);
                apo.setTgtStorageProviderSN(srcArraySN);
                break;
            }
        }
        try {
            apo = this.makeSnapshotGroup(apo, poReplicas);
            if (null == apo) {
                return false;
            }
            context.addObject("PO_GROUP_MAP", (Object)apo);
            this.setTimeStamp(context);
            logger.info((Object)"BaseNasSnapshotAction end to execute!", 90160758786988L);
            return true;
        }
        catch (Exception e) {
            if ("--".equals(this.getDetail())) {
                this.setDetail("lego.err.-1");
            }
            logger.error((Object)"BaseNasSnapshotAction executed failed! Error Messgae: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), -1L});
            return false;
        }
    }

    protected SnapShotAssociateProtectObject makeSnapshotGroup(SnapShotAssociateProtectObject snapshotPo, Set<ProtectObjectReplica> poReplicas) {
        if (null == snapshotPo) {
            return null;
        }
        for (ProtectObjectReplica poReplica : poReplicas) {
            if (this.createOrDeleteSnapshot(snapshotPo, poReplica) != null) continue;
            return null;
        }
        return snapshotPo;
    }

    private SnapShotAssociateProtectObject createOrDeleteSnapshot(SnapShotAssociateProtectObject snapshotPo, ProtectObjectReplica poReplica) {
        for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
            LocalStorageReplica localStor = (LocalStorageReplica)stor;
            String nasId = localStor.getSrcStorageId();
            if (VerifyUtil.isEmpty((String)nasId)) {
                logger.error((Object)"ProtectObject(%s) does not have snapshot.", new Object[]{poReplica.getPoId()});
                this.setDetail("lego.err.1073948446");
                return null;
            }
            if (snapshotPo.getSnapshotInfo().containsKey(nasId)) {
                String snapshotId = snapshotPo.getSnapshotInfo().get(nasId);
                localStor.setStorageId(snapshotId);
                continue;
            }
            this.createSnapShotAndLocalStor(snapshotPo, localStor);
        }
        return snapshotPo;
    }

    protected void createSnapShotAndLocalStor(SnapShotAssociateProtectObject apo, LocalStorageReplica localStor) {
        String snapshotId = this.createSnapshot(localStor);
        if (!VerifyUtil.isEmpty((String)snapshotId)) {
            try {
                localStor.setStorageId(snapshotId);
                apo.getSnapshotInfo().put(localStor.getSrcStorageId(), snapshotId);
            }
            catch (Exception e) {
                this.deleteSnapshotOnStorage(localStor.getSrcStorageProviderSN(), snapshotId, localStor.getSnapshotName());
                ExceptionUtil.rethrowException((Throwable)e, (String)"update snapshot db info error.", (long)-1L, (String[])new String[0], (Log)logger);
            }
        } else {
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L, "Create snapshot error.");
        }
    }

    protected String createSnapshot(LocalStorageReplica localStor) {
        IStorageFileSystemManager fileSystemManagerProxy = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(localStor.getSrcStorageProviderSN());
        this.checkFileSystemMgr(fileSystemManagerProxy, localStor);
        ArrayList<String> nasFileIds = new ArrayList<String>();
        nasFileIds.add(localStor.getSrcStorageId());
        List nasFiles = fileSystemManagerProxy.queryFileSystems(localStor.getSrcStorageProviderSN(), nasFileIds, this.getVstoreId(this.protectGroup));
        if (VerifyUtil.isEmpty((Collection)nasFiles)) {
            logger.error((Object)"Nas(%s:%s) is null.", new Object[]{localStor.getSrcStorageProviderSN(), localStor.getSrcStorageId()});
            this.setDetail("lego.err.1073948454");
            throw new LegoCheckedException(1073948454L);
        }
        String snapId = null;
        try {
            IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(localStor.getSrcStorageProviderSN());
            this.checkStorageFileSystemSnapshotMgr(fileSystemSnapshotManagerProxy, localStor.getSrcStorageProviderSN());
            String nasId = ((NasFileSystem)nasFiles.get(0)).getResourceId();
            snapId = this.createSnapshot(fileSystemSnapshotManagerProxy, localStor, nasId);
            if (VerifyUtil.isEmpty((String)snapId)) {
                logger.error((Object)"SnapId is empty!", 90160758784001L);
                throw new LegoCheckedException(1073948680L);
            }
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            logger.error((Object)"GenerateProtectGroupReplica Creating snapshot failed. DevSN: %s, Name:%s, LunId:%s. Error Code:%d.", (Throwable)e, new Object[]{localStor.getSrcStorageProviderSN(), localStor.getSnapshotName(), localStor.getSrcStorageId(), errorCode});
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            this.sendSnapShotExceedLimitMsg(this.protectGroup.getUuid(), errorCode);
            throw new LegoCheckedException(errorCode, (Throwable)e);
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948454");
            String errorMsg = String.format("GenerateProtectGroupReplica Creating snapshot failed. DevSN: %s, Name:%s, LunId:%s.", localStor.getSrcStorageProviderSN(), localStor.getSnapshotName(), localStor.getSrcStorageId());
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948454L, (String[])new String[0], (Log)logger);
        }
        return snapId;
    }

    private void checkFileSystemMgr(IStorageFileSystemManager fileSystemManagerProxy, LocalStorageReplica storageSn) {
        if (fileSystemManagerProxy == null) {
            logger.error((Object)"IStorageFileSystemManager is null!arraySN: %s", new Object[]{storageSn.getSrcStorageProviderSN()});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void deleteSnapshotOnStorage(String arraySN, String snapshotId, String snapshotName) {
        block5: {
            try {
                IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(arraySN);
                this.checkStorageFileSystemSnapshotMgr(fileSystemSnapshotManagerProxy, arraySN);
                OperationResult result = fileSystemSnapshotManagerProxy.deleteSnapshot(arraySN, snapshotId);
                if (result.isSuccess()) break block5;
                String errorCode = result.getErrorCode();
                long errCode = 1073948679L;
                try {
                    errCode = Long.parseLong(errorCode);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)"Operation<Long.parseLong(errorCode)> error!");
                }
                logger.error((Object)"Delete SnapshotOnStorage error code: %d", new Object[]{errCode, 1073948679L});
                throw new LegoCheckedException(errCode, result.getArgs());
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                logger.error((Object)"DeleteSnapshotOnStorage error: %s, Name: %s, Id:%s. Error Code:%d", (Throwable)e, new Object[]{arraySN, snapshotName, snapshotId, errorCode});
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                throw new LegoCheckedException(errorCode, (Throwable)e);
            }
            catch (Exception e) {
                this.setDetail("lego.err.1073948679");
                String errorMsg = String.format("DeleteSnapshotOnStorage error: %s, Name: %s, Id:%s.", arraySN, snapshotName, snapshotId);
                ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073948679L, (String[])new String[0], (Log)logger);
            }
        }
    }

    private void checkStorageFileSystemSnapshotMgr(IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy, String arraySN) {
        if (fileSystemSnapshotManagerProxy == null) {
            logger.error((Object)"fileSystemSnapshotManagerProxy is null!arraySN: %s", new Object[]{arraySN});
            this.setDetail("lego.err.1073947394");
            throw new LegoCheckedException(1073947394L);
        }
    }

    private String getVstoreId(ProtectGroup pg) {
        String vStoreId = null;
        if (null != pg && null != pg.getPolist() && pg.getPolist().size() > 0) {
            ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
            vStoreId = this.getVstoreId(protectObject);
        }
        return vStoreId;
    }

    private String getVstoreId(ProtectObject protectObject) {
        String vStoreId = null;
        if (null != protectObject && null != protectObject.getUsedStorageResourceSet() && !protectObject.getUsedStorageResourceSet().isEmpty()) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vStoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vStoreId;
    }

    private String createSnapshot(IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy, LocalStorageReplica localStor, String nasId) {
        Set schedules = Optional.ofNullable(this.protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getSchedules).orElse(null);
        boolean needSecureSnapshot = false;
        RetentionPolicy retentionPolicy = null;
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            needSecureSnapshot = schedules.stream().findFirst().map(Schedule::isNeedSecureSnapshot).orElse(false);
            retentionPolicy = schedules.stream().findFirst().map(Schedule::getRetentionPolicy).orElse(null);
        }
        if (needSecureSnapshot && VerifyUtil.isEmpty(retentionPolicy)) {
            logger.error((Object)"RetentionPolicy of nasFileSystem(nasId: %s) is empty!", new Object[]{nasId});
            throw new LegoCheckedException(1073948680L);
        }
        return this.createSnapshot(fileSystemSnapshotManagerProxy, localStor, nasId, needSecureSnapshot, retentionPolicy);
    }

    protected String createSnapshot(IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy, LocalStorageReplica localStor, String nasId, boolean needSecureSnapshot, RetentionPolicy retentionPolicy) {
        if (needSecureSnapshot) {
            return fileSystemSnapshotManagerProxy.createSecureSnapshot(localStor.getSrcStorageProviderSN(), nasId, localStor.getSnapshotName(), retentionPolicy.getProtectPeriod(), retentionPolicy.getUnitType());
        }
        return fileSystemSnapshotManagerProxy.createSnapshot(localStor.getSrcStorageProviderSN(), nasId, localStor.getSnapshotName());
    }

    @Override
    protected void setTimeStamp(ActionContext context) {
        if (!this.protectGroup.isNeedSecureSnapshot()) {
            return;
        }
        String curTimeStamp = String.valueOf(new Date().getTime());
        context.addObject("REPLICA_TIMESTANP", (Object)curTimeStamp);
        Object object = context.getObject("TASK_ENTITY");
        if (!(object instanceof ProtectionTask)) {
            return;
        }
        ProtectionTask curTask = (ProtectionTask)object;
        RetentionPolicy policy = this.getRetentionPolicy(curTask);
        int replicaProtectPeriod = policy.getProtectPeriod();
        int unit = policy.getUnitType();
        Long tmp = Long.parseLong(curTimeStamp);
        long deadlineStamp = this.getReplicaDeadLineTimeStamp(tmp, replicaProtectPeriod, unit);
        logger.info((Object)"Replica deadline timeStamp: %d", deadlineStamp);
        context.addObject("REPLICA_DEADLINE_TIMESTANP", (Object)String.valueOf(deadlineStamp));
        context.addObject("REPLICA_ACTIVE_PERIOD", (Object)(replicaProtectPeriod + ":" + unit));
        context.addObject("REPLICA_SCHEDULEID", (Object)curTask.getSchedule().getScheduleId());
    }

    private Long getReplicaDeadLineTimeStamp(Long curTimeStamp, int period, int unit) {
        long endTime;
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        date.setTime(curTimeStamp);
        calendar.setTime(date);
        DrmEnumDefine.UnitTypeEnum unitTypeE = DrmEnumDefine.UnitTypeEnum.getUnitTypeEnum((int)unit);
        switch (unitTypeE) {
            case DAY: {
                calendar.add(5, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            case MONTH: {
                calendar.add(2, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            case YEAR: {
                calendar.add(1, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            default: {
                endTime = -1L;
            }
        }
        return endTime;
    }

    private RetentionPolicy getRetentionPolicy(ProtectionTask curTask) {
        Schedule schedule = curTask.getSchedule();
        RetentionPolicy policy = schedule.getRetentionPolicy();
        if (VerifyUtil.isEmpty((Object)policy)) {
            logger.error((Object)"Not find policy for create secure snapshot.");
            throw new LegoCheckedException(1073947394L);
        }
        return policy;
    }
}

